/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.LogicalExpressionSimplifier;

class LogicalExpressionProxy
extends LogicalExpression {
    LogicalExpression src;

    LogicalExpressionProxy(OperatorPlan plan, LogicalExpression src) {
        super("Proxy: " + src.getName(), plan);
        this.src = src;
        LogicalExpressionSimplifier.LogicalExpressionSimplifierTransformer.incrDNFSplitCount(src);
    }

    public void accept(PlanVisitor v) throws FrontendException {
        throw new FrontendException("Visitor not accepted by proxy.");
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof LogicalExpressionProxy) {
            return this.src.isEqual(((LogicalExpressionProxy)other).src);
        }
        return false;
    }

    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        return this.src.getFieldSchema();
    }

    public void decrSrcDNFSplitCounter() {
        LogicalExpressionSimplifier.LogicalExpressionSimplifierTransformer.decrDNFSplitCount(this.src);
        if (LogicalExpressionSimplifier.LogicalExpressionSimplifierTransformer.getSplitCount(this.src) == 1) {
            LogicalExpressionSimplifier.LogicalExpressionSimplifierTransformer.decrDNFSplitCount(this.src);
        }
    }

    public void restoreSrc() {
        while (LogicalExpressionSimplifier.LogicalExpressionSimplifierTransformer.getSplitCount(this.src) > 1) {
            LogicalExpressionSimplifier.LogicalExpressionSimplifierTransformer.decrDNFSplitCount(this.src);
        }
    }

    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        throw new FrontendException("Deepcopy not expected");
    }
}

