/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import org.apache.log4j.Logger;
import voldemort.server.VoldemortConfig;
import voldemort.server.VoldemortServer;
import voldemort.utils.Utils;

public class VoldemortJsvcDaemon {
    private static final Logger logger = Logger.getLogger((String)VoldemortServer.class.getName());
    private VoldemortServer server = null;

    public void init(String[] args) throws Exception {
        VoldemortConfig config = null;
        try {
            if (args.length == 0) {
                config = VoldemortConfig.loadFromEnvironmentVariable();
            } else if (args.length == 1) {
                config = VoldemortConfig.loadFromVoldemortHome(args[0]);
            } else if (args.length == 2) {
                config = VoldemortConfig.loadFromVoldemortHome(args[0], args[1]);
            } else {
                Utils.croak("USAGE: java " + VoldemortJsvcDaemon.class.getName() + " [voldemort_home_dir] [voldemort_config_dir]");
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            Utils.croak("Error while loading configuration: " + e.getMessage());
        }
        this.server = new VoldemortServer(config);
    }

    public void start() {
        if (!this.server.isStarted()) {
            this.server.start();
        }
    }

    public void stop() {
        if (this.server.isStarted()) {
            this.server.stop();
        }
    }

    public void destroy() {
    }
}

