/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import voldemort.utils.Utils;
import voldemort.utils.pool.ExcessiveInvalidResourcesException;
import voldemort.utils.pool.ResourceFactory;
import voldemort.utils.pool.ResourcePoolConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedResourcePool<K, V> {
    private static final Logger logger = Logger.getLogger((String)KeyedResourcePool.class.getName());
    private final ResourceFactory<K, V> objectFactory;
    private final ConcurrentMap<K, Pool<V>> resourcesMap;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private final long timeoutNs;
    private final int poolMaxSize;
    private final int maxCreateAttempts;
    private final boolean isFair;

    public KeyedResourcePool(ResourceFactory<K, V> objectFactory, ResourcePoolConfig config) {
        this.objectFactory = Utils.notNull(objectFactory);
        this.timeoutNs = Utils.notNull(config).getTimeout(TimeUnit.NANOSECONDS);
        this.poolMaxSize = config.getMaxPoolSize();
        this.maxCreateAttempts = config.getMaximumInvalidResourceCreationLimit();
        this.resourcesMap = new ConcurrentHashMap<K, Pool<V>>();
        this.isFair = config.isFair();
    }

    public static <K, V> KeyedResourcePool<K, V> create(ResourceFactory<K, V> factory, ResourcePoolConfig config) {
        return new KeyedResourcePool<K, V>(factory, config);
    }

    public static <K, V> KeyedResourcePool<K, V> create(ResourceFactory<K, V> factory) {
        return KeyedResourcePool.create(factory, new ResourcePoolConfig());
    }

    public V checkout(K key) throws Exception {
        this.checkNotClosed();
        long startNs = System.nanoTime();
        Pool<V> resources = this.getResourcePoolForKey(key);
        V resource = null;
        try {
            int attempts;
            for (attempts = 0; attempts < this.maxCreateAttempts; ++attempts) {
                resource = null;
                this.checkNotClosed();
                long timeRemainingNs = this.timeoutNs - (System.nanoTime() - startNs);
                if (timeRemainingNs < 0L) {
                    throw new TimeoutException("Could not acquire resource in " + this.timeoutNs / 1000000L + " ms.");
                }
                resource = this.checkoutOrCreateResource(key, resources, timeRemainingNs);
                if (this.objectFactory.validate(key, resource)) {
                    return resource;
                }
                this.destroyResource(key, resources, resource);
            }
            throw new ExcessiveInvalidResourcesException(attempts);
        }
        catch (Exception e) {
            this.destroyResource(key, resources, resource);
            throw e;
        }
    }

    private V checkoutOrCreateResource(K key, Pool<V> pool, long timeoutNs) throws Exception {
        V resource = pool.nonBlockingGet();
        if (resource != null) {
            return resource;
        }
        if (pool.size.get() < this.poolMaxSize) {
            this.attemptGrow(key, pool);
        }
        if ((resource = pool.blockingGet(timeoutNs)) == null) {
            throw new TimeoutException("Timed out wait for resource after " + timeoutNs / 1000000L + " ms.");
        }
        return resource;
    }

    private void attemptGrow(K key, Pool<V> pool) throws Exception {
        if (pool.size.incrementAndGet() <= this.poolMaxSize) {
            try {
                V resource = this.objectFactory.create(key);
                pool.nonBlockingPut(resource);
            }
            catch (Exception e) {
                pool.size.decrementAndGet();
                throw e;
            }
        } else {
            pool.size.decrementAndGet();
        }
    }

    private Pool<V> getResourcePoolForKey(K key) {
        Pool pool = (Pool)this.resourcesMap.get(key);
        if (pool == null) {
            pool = new Pool(this.poolMaxSize, this.isFair);
            this.resourcesMap.putIfAbsent(key, pool);
            pool = (Pool)this.resourcesMap.get(key);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyResource(K key, Pool<V> resources, V resource) {
        if (resource != null) {
            try {
                this.objectFactory.destroy(key, resource);
            }
            catch (Exception e) {
                logger.error((Object)"Exception while destorying invalid resource:", (Throwable)e);
            }
            finally {
                resources.size.decrementAndGet();
            }
        }
    }

    public void checkin(K key, V resource) throws Exception {
        Pool pool = (Pool)this.resourcesMap.get(key);
        if (pool == null) {
            throw new IllegalArgumentException("Invalid key '" + key + "': no resource pool exists for that key.");
        }
        if (this.isOpen.get() && this.objectFactory.validate(key, resource)) {
            boolean success = pool.nonBlockingPut(resource);
            if (!success) {
                this.destroyResource(key, pool, resource);
                throw new IllegalStateException("Checkin failed is the pool already full?");
            }
        } else {
            this.destroyResource(key, pool, resource);
        }
    }

    public void close() {
        if (this.isOpen.compareAndSet(true, false)) {
            for (Map.Entry entry : this.resourcesMap.entrySet()) {
                Pool pool = (Pool)entry.getValue();
                Object value = pool.nonBlockingGet();
                while (value != null) {
                    this.destroyResource(entry.getKey(), (Pool)entry.getValue(), value);
                    value = pool.nonBlockingGet();
                }
                this.resourcesMap.remove(entry.getKey());
            }
        }
    }

    public void close(K key) {
        Pool pool = (Pool)this.resourcesMap.get(key);
        if (pool == null) {
            throw new IllegalArgumentException("Invalid key '" + key + "': no resource pool exists for that key.");
        }
        List list = pool.close();
        for (Object value : list) {
            this.destroyResource(key, pool, value);
        }
    }

    public int getTotalResourceCount(K k) {
        Pool pool = (Pool)this.resourcesMap.get(k);
        return pool.size.get();
    }

    public int getTotalResourceCount() {
        int count = 0;
        for (Map.Entry entry : this.resourcesMap.entrySet()) {
            count += ((Pool)entry.getValue()).size.get();
        }
        return count;
    }

    public int getCheckedInResourcesCount(K k) {
        Pool pool = (Pool)this.resourcesMap.get(k);
        return pool.queue.size();
    }

    public int getCheckedInResourceCount() {
        int count = 0;
        for (Map.Entry entry : this.resourcesMap.entrySet()) {
            count += ((Pool)entry.getValue()).queue.size();
        }
        return count;
    }

    private void checkNotClosed() {
        if (!this.isOpen.get()) {
            throw new IllegalStateException("Pool is closed!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pool<V> {
        final BlockingQueue<V> queue;
        final AtomicInteger size = new AtomicInteger(0);

        public Pool(int defaultPoolSize, boolean isFair) {
            this.queue = new ArrayBlockingQueue<V>(defaultPoolSize, isFair);
        }

        public V nonBlockingGet() {
            return (V)this.queue.poll();
        }

        public V blockingGet(long timeoutNs) throws InterruptedException {
            return this.queue.poll(timeoutNs, TimeUnit.NANOSECONDS);
        }

        public boolean nonBlockingPut(V v) {
            return this.queue.offer(v);
        }

        public List<V> close() {
            ArrayList list = new ArrayList();
            this.queue.drainTo(list);
            return list;
        }
    }
}

