/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import voldemort.server.ServiceType;
import voldemort.server.VoldemortServer;
import voldemort.server.http.HttpService;
import voldemort.server.protocol.RequestHandler;
import voldemort.utils.Utils;

public class StoreServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(StoreServlet.class);
    private static final long serialVersionUID = 1L;
    private RequestHandler requestHandler;

    public StoreServlet() {
    }

    public StoreServlet(RequestHandler handler) {
        this.requestHandler = handler;
    }

    public void init() throws ServletException {
        super.init();
        if (this.requestHandler == null) {
            ServletContext context = this.getServletContext();
            VoldemortServer server = (VoldemortServer)Utils.notNull(context.getAttribute("vldmt_server"));
            HttpService httpService = (HttpService)server.getService(ServiceType.HTTP);
            this.requestHandler = httpService.getRequestHandler();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.requestHandler.handleRequest(new DataInputStream((InputStream)request.getInputStream()), new DataOutputStream((OutputStream)response.getOutputStream()));
        }
        catch (Exception e) {
            logger.error((Object)"Uncaught exception in store servlet:", (Throwable)e);
            response.sendError(503, e.getMessage());
        }
    }
}

