/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.compress;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.compress.CompressionStrategy;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressingStore
implements Store<ByteArray, byte[], byte[]> {
    private final Store<ByteArray, byte[], byte[]> innerStore;
    private final CompressionStrategy keysCompressionStrategy;
    private final CompressionStrategy valuesCompressionStrategy;

    public CompressingStore(Store<ByteArray, byte[], byte[]> innerStore, CompressionStrategy keysCompressionStrategy, CompressionStrategy valuesCompressionStrategy) {
        this.keysCompressionStrategy = Utils.notNull(keysCompressionStrategy);
        this.valuesCompressionStrategy = Utils.notNull(valuesCompressionStrategy);
        this.innerStore = Utils.notNull(innerStore);
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        ArrayList processedKeys = keys;
        ArrayList deflatedKeys = Lists.newArrayList();
        for (ByteArray key : keys) {
            deflatedKeys.add(this.deflateKey(key));
        }
        processedKeys = deflatedKeys;
        HashMap newTransforms = Maps.newHashMap();
        if (transforms != null) {
            for (Map.Entry entry : transforms.entrySet()) {
                newTransforms.put(this.deflateKey((ByteArray)entry.getKey()), entry.getValue());
            }
        } else {
            for (ByteArray byteArray : processedKeys) {
                newTransforms.put(byteArray, null);
            }
        }
        Map<ByteArray, List<Versioned<byte[]>>> deflatedResult = this.innerStore.getAll(processedKeys, newTransforms);
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)deflatedResult.size());
        for (Map.Entry<ByteArray, List<Versioned<byte[]>>> mapEntry : deflatedResult.entrySet()) {
            hashMap.put(this.inflateKey(mapEntry.getKey()), this.inflateValues(mapEntry.getValue()));
        }
        return hashMap;
    }

    private ByteArray inflateKey(ByteArray key) {
        byte[] inflated = this.inflate(this.keysCompressionStrategy, key.get());
        if (inflated == key.get()) {
            return key;
        }
        return new ByteArray(inflated);
    }

    private ByteArray deflateKey(ByteArray key) {
        byte[] deflated = this.deflate(this.keysCompressionStrategy, key.get());
        if (deflated == key.get()) {
            return key;
        }
        return new ByteArray(deflated);
    }

    private Versioned<byte[]> deflateValue(Versioned<byte[]> versioned) {
        return new Versioned<byte[]>(this.deflate(this.valuesCompressionStrategy, versioned.getValue()), versioned.getVersion());
    }

    private Versioned<byte[]> inflateValue(Versioned<byte[]> versioned) {
        return new Versioned<byte[]>(this.inflate(this.valuesCompressionStrategy, versioned.getValue()), versioned.getVersion());
    }

    private byte[] inflate(CompressionStrategy compressionStrategy, byte[] data) throws VoldemortException {
        try {
            return compressionStrategy.inflate(data);
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    private byte[] deflate(CompressionStrategy compressionStrategy, byte[] data) throws VoldemortException {
        try {
            return compressionStrategy.deflate(data);
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.inflateValues(this.innerStore.get(this.deflateKey(key), transforms));
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return this.innerStore.getVersions(this.deflateKey(key));
    }

    private List<Versioned<byte[]>> inflateValues(List<Versioned<byte[]>> result) {
        ArrayList<Versioned<byte[]>> inflated = new ArrayList<Versioned<byte[]>>(result.size());
        for (Versioned<byte[]> item : result) {
            inflated.add(this.inflateValue(item));
        }
        return inflated;
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        this.innerStore.put(this.deflateKey(key), this.deflateValue(value), transforms);
    }

    @Override
    public void close() throws VoldemortException {
        this.innerStore.close();
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        return this.innerStore.getCapability(capability);
    }

    @Override
    public String getName() {
        return this.innerStore.getName();
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.innerStore.delete(this.deflateKey(key), version);
    }
}

