/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import voldemort.annotations.concurrency.NotThreadsafe;
import voldemort.utils.UndefinedPropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadsafe
public class Props
implements Map<String, String> {
    private final Map<String, String> props = new HashMap<String, String>();

    public Props() {
    }

    public Props(File ... files) throws FileNotFoundException, IOException {
        for (int i = files.length - 1; i >= 0; --i) {
            Properties properties = new Properties();
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(files[i].getAbsolutePath()));
            properties.load(input);
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                this.props.put((String)e.getKey(), (String)e.getValue());
            }
            ((InputStream)input).close();
        }
    }

    public Props(Map<String, String> ... props) {
        for (int i = props.length - 1; i >= 0; --i) {
            this.props.putAll(props[i]);
        }
    }

    public Props(Properties ... properties) {
        this.loadProperties(properties);
    }

    public void loadProperties(Properties ... properties) {
        for (int i = properties.length - 1; i >= 0; --i) {
            for (Map.Entry<Object, Object> e : properties[i].entrySet()) {
                this.props.put((String)e.getKey(), (String)e.getValue());
            }
        }
    }

    @Override
    public void clear() {
        this.props.clear();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.props.containsKey(k);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.props.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.props.entrySet();
    }

    @Override
    public String get(Object key) {
        return this.props.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.props.keySet();
    }

    @Override
    public String put(String key, String value) {
        return this.props.put(key, value);
    }

    @Override
    public String put(String key, Integer value) {
        return this.props.put(key, value.toString());
    }

    @Override
    public String put(String key, Long value) {
        return this.props.put(key, value.toString());
    }

    @Override
    public String put(String key, Double value) {
        return this.props.put(key, value.toString());
    }

    public Props with(String key, String value) {
        this.put(key, value);
        return this;
    }

    public Props with(String key, Integer value) {
        this.put(key, value);
        return this;
    }

    public Props with(String key, Double value) {
        this.put(key, value);
        return this;
    }

    public Props with(String key, Long value) {
        this.put(key, value);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.props.putAll(m);
    }

    @Override
    public String remove(Object s) {
        return this.props.remove(s);
    }

    @Override
    public int size() {
        return this.props.size();
    }

    @Override
    public Collection<String> values() {
        return this.props.values();
    }

    public String getString(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        return defaultValue;
    }

    public String getString(String key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        throw new UndefinedPropertyException(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (this.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        return defaultValue;
    }

    public boolean getBoolean(String key) {
        if (this.containsKey(key)) {
            return "true".equalsIgnoreCase(this.get(key));
        }
        throw new UndefinedPropertyException(key);
    }

    public long getLong(String name, long defaultValue) {
        if (this.containsKey(name)) {
            return Long.parseLong(this.get(name));
        }
        return defaultValue;
    }

    public long getLong(String name) {
        if (this.containsKey(name)) {
            return Long.parseLong(this.get(name));
        }
        throw new UndefinedPropertyException(name);
    }

    public int getInt(String name, int defaultValue) {
        if (this.containsKey(name)) {
            return Integer.parseInt(this.get(name));
        }
        return defaultValue;
    }

    public int getInt(String name) {
        if (this.containsKey(name)) {
            return Integer.parseInt(this.get(name));
        }
        throw new UndefinedPropertyException(name);
    }

    public double getDouble(String name, double defaultValue) {
        if (this.containsKey(name)) {
            return Double.parseDouble(this.get(name));
        }
        return defaultValue;
    }

    public double getDouble(String name) {
        if (this.containsKey(name)) {
            return Double.parseDouble(this.get(name));
        }
        throw new UndefinedPropertyException(name);
    }

    public long getBytes(String name, long defaultValue) {
        if (this.containsKey(name)) {
            return this.getBytes(name);
        }
        return defaultValue;
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.props).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.props).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        for (Map.Entry<String, String> entry : this.props.entrySet()) {
            builder.append(entry.getKey());
            builder.append(": ");
            builder.append(entry.getValue());
            builder.append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    public long getBytes(String name) {
        if (!this.containsKey(name)) {
            throw new UndefinedPropertyException(name);
        }
        String bytes = this.get(name);
        String bytesLc = bytes.toLowerCase().trim();
        if (bytesLc.endsWith("kb")) {
            return Long.parseLong(bytes.substring(0, bytes.length() - 2)) * 1024L;
        }
        if (bytesLc.endsWith("k")) {
            return Long.parseLong(bytes.substring(0, bytes.length() - 1)) * 1024L;
        }
        if (bytesLc.endsWith("mb")) {
            return Long.parseLong(bytes.substring(0, bytes.length() - 2)) * 1024L * 1024L;
        }
        if (bytesLc.endsWith("m")) {
            return Long.parseLong(bytes.substring(0, bytes.length() - 1)) * 1024L * 1024L;
        }
        if (bytesLc.endsWith("gb")) {
            return Long.parseLong(bytes.substring(0, bytes.length() - 2)) * 1024L * 1024L * 1024L;
        }
        if (bytesLc.endsWith("g")) {
            return Long.parseLong(bytes.substring(0, bytes.length() - 1)) * 1024L * 1024L * 1024L;
        }
        return Long.parseLong(bytes);
    }

    public List<String> getList(String key, List<String> defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        String value = this.get(key);
        String[] pieces = value.split("\\s*,\\s*");
        return Arrays.asList(pieces);
    }

    public List<String> getList(String key) {
        if (!this.containsKey(key)) {
            throw new UndefinedPropertyException(key);
        }
        return this.getList(key, null);
    }
}

