/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.server.storage.RepairJob;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.slop.SlopStorageEngine;
import voldemort.utils.ByteArray;
import voldemort.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Threadsafe
public class StoreRepository {
    private volatile SlopStorageEngine slopStore;
    private final ConcurrentMap<String, Store<ByteArray, byte[], byte[]>> localStores = new ConcurrentHashMap<String, Store<ByteArray, byte[], byte[]>>();
    private final ConcurrentMap<String, StorageEngine<ByteArray, byte[], byte[]>> storageEngines = new ConcurrentHashMap<String, StorageEngine<ByteArray, byte[], byte[]>>();
    private final ConcurrentMap<String, Store<ByteArray, byte[], byte[]>> routedStores = new ConcurrentHashMap<String, Store<ByteArray, byte[], byte[]>>();
    private final ConcurrentMap<Pair<String, Integer>, Store<ByteArray, byte[], byte[]>> nodeStores = new ConcurrentHashMap<Pair<String, Integer>, Store<ByteArray, byte[], byte[]>>();
    private final ConcurrentMap<Pair<String, Integer>, Store<ByteArray, byte[], byte[]>> redirectingSocketStores = new ConcurrentHashMap<Pair<String, Integer>, Store<ByteArray, byte[], byte[]>>();
    private RepairJob repairJob;

    public boolean hasLocalStore(String name) {
        return this.localStores.containsKey(name);
    }

    public Store<ByteArray, byte[], byte[]> getLocalStore(String storeName) {
        return (Store)this.localStores.get(storeName);
    }

    public Store<ByteArray, byte[], byte[]> removeLocalStore(String storeName) {
        return (Store)this.localStores.remove(storeName);
    }

    public void addLocalStore(Store<ByteArray, byte[], byte[]> store) {
        Store<ByteArray, byte[], byte[]> found = this.localStores.putIfAbsent(store.getName(), store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' has already been initialized.");
        }
    }

    public List<Store<ByteArray, byte[], byte[]>> getAllLocalStores() {
        return new ArrayList<Store<ByteArray, byte[], byte[]>>(this.localStores.values());
    }

    public boolean hasStorageEngine(String name) {
        return this.storageEngines.containsKey(name);
    }

    public StorageEngine<ByteArray, byte[], byte[]> getStorageEngine(String storeName) {
        return (StorageEngine)this.storageEngines.get(storeName);
    }

    public void addStorageEngine(StorageEngine<ByteArray, byte[], byte[]> engine) {
        StorageEngine<ByteArray, byte[], byte[]> found = this.storageEngines.putIfAbsent(engine.getName(), engine);
        if (found != null) {
            throw new VoldemortException("Storage Engine '" + engine.getName() + "' has already been initialized.");
        }
    }

    public Store<ByteArray, byte[], byte[]> removeStorageEngine(String storeName) {
        return (Store)this.storageEngines.remove(storeName);
    }

    public List<StorageEngine<ByteArray, byte[], byte[]>> getAllStorageEngines() {
        return new ArrayList<StorageEngine<ByteArray, byte[], byte[]>>(this.storageEngines.values());
    }

    public List<StorageEngine<ByteArray, byte[], byte[]>> getStorageEnginesByClass(Class<? extends StorageEngine<?, ?, ?>> c) {
        ArrayList<StorageEngine<ByteArray, byte[], byte[]>> l = new ArrayList<StorageEngine<ByteArray, byte[], byte[]>>();
        for (StorageEngine engine : this.storageEngines.values()) {
            if (!engine.getClass().equals(c)) continue;
            l.add(engine);
        }
        return l;
    }

    public boolean hasRoutedStore(String name) {
        return this.routedStores.containsKey(name);
    }

    public Store<ByteArray, byte[], byte[]> getRoutedStore(String storeName) {
        return (Store)this.routedStores.get(storeName);
    }

    public void addRoutedStore(Store<ByteArray, byte[], byte[]> store) {
        Store<ByteArray, byte[], byte[]> found = this.routedStores.putIfAbsent(store.getName(), store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' has already been initialized.");
        }
    }

    public List<Store<ByteArray, byte[], byte[]>> getAllRoutedStores() {
        return new ArrayList<Store<ByteArray, byte[], byte[]>>(this.routedStores.values());
    }

    public Store<ByteArray, byte[], byte[]> removeRoutedStore(String storeName) {
        return (Store)this.routedStores.remove(storeName);
    }

    public boolean hasNodeStore(String name, int nodeId) {
        return this.nodeStores.containsKey(Pair.create(name, nodeId));
    }

    public Store<ByteArray, byte[], byte[]> getNodeStore(String storeName, Integer id) {
        return (Store)this.nodeStores.get(Pair.create(storeName, id));
    }

    public Store<ByteArray, byte[], byte[]> removeNodeStore(String storeName, int nodeId) {
        return (Store)this.nodeStores.remove(Pair.create(storeName, nodeId));
    }

    public void addNodeStore(int nodeId, Store<ByteArray, byte[], byte[]> store) {
        Pair<String, Integer> key = Pair.create(store.getName(), nodeId);
        Store<ByteArray, byte[], byte[]> found = this.nodeStores.putIfAbsent(key, store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' for node " + nodeId + " has already been initialized.");
        }
    }

    public List<Pair<Integer, Store<ByteArray, byte[], byte[]>>> getAllNodeStores() {
        ArrayList<Pair<Integer, Store<ByteArray, byte[], byte[]>>> vals = new ArrayList<Pair<Integer, Store<ByteArray, byte[], byte[]>>>();
        for (Map.Entry entry : this.nodeStores.entrySet()) {
            vals.add(Pair.create(((Pair)entry.getKey()).getSecond(), entry.getValue()));
        }
        return vals;
    }

    public boolean hasRedirectingSocketStore(String name, int nodeId) {
        return this.redirectingSocketStores.containsKey(Pair.create(name, nodeId));
    }

    public Store<ByteArray, byte[], byte[]> getRedirectingSocketStore(String storeName, Integer id) {
        return (Store)this.redirectingSocketStores.get(Pair.create(storeName, id));
    }

    public void addRedirectingSocketStore(int nodeId, Store<ByteArray, byte[], byte[]> store) {
        Pair<String, Integer> key = Pair.create(store.getName(), nodeId);
        Store<ByteArray, byte[], byte[]> found = this.redirectingSocketStores.putIfAbsent(key, store);
        if (found != null) {
            throw new VoldemortException("Store '" + store.getName() + "' for node " + nodeId + " has already been initialized.");
        }
    }

    public SlopStorageEngine getSlopStore() {
        if (this.slopStore == null) {
            throw new IllegalStateException("Slop store has not been set!");
        }
        return this.slopStore;
    }

    public void setSlopStore(SlopStorageEngine slopStore) {
        this.slopStore = slopStore;
    }

    public boolean hasSlopStore() {
        return this.slopStore != null;
    }

    public RepairJob getRepairJob() {
        return this.repairJob;
    }

    public void registerRepairJob(RepairJob job) {
        this.repairJob = job;
    }
}

