/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.executor.ExecutableFlow;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.UndefinedPropertyException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;

public class PropsUtils {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([a-zA-Z_.0-9]+)\\}");

    public static Props loadPropsInDir(File dir, String ... suffixes) {
        return PropsUtils.loadPropsInDir(null, dir, suffixes);
    }

    public static Props loadPropsInDir(Props parent, File dir, String ... suffixes) {
        try {
            Props props = new Props(parent);
            Object[] files = dir.listFiles();
            Arrays.sort(files);
            if (files != null) {
                for (Object f : files) {
                    if (!((File)f).isFile() || !PropsUtils.endsWith((File)f, suffixes)) continue;
                    props.putAll(new Props(null, ((File)f).getAbsolutePath()));
                }
            }
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties.", e);
        }
    }

    public static Props loadProps(Props parent, File ... propFiles) {
        try {
            Props props = new Props(parent);
            for (File f : propFiles) {
                if (!f.isFile()) continue;
                props = new Props(props, f);
            }
            return props;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties.", e);
        }
    }

    public static Props loadPropsInDirs(List<File> dirs, String ... suffixes) {
        Props props = new Props();
        for (File dir : dirs) {
            props.putLocal(PropsUtils.loadPropsInDir(dir, suffixes));
        }
        return props;
    }

    public static void loadPropsBySuffix(File jobPath, Props props, String ... suffixes) {
        try {
            if (jobPath.isDirectory()) {
                File[] files = jobPath.listFiles();
                if (files != null) {
                    for (File file : files) {
                        PropsUtils.loadPropsBySuffix(file, props, suffixes);
                    }
                }
            } else if (PropsUtils.endsWith(jobPath, suffixes)) {
                props.putAll(new Props(null, jobPath.getAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading schedule properties.", e);
        }
    }

    public static boolean endsWith(File file, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!file.getName().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static Props resolveProps(Props props) {
        if (props == null) {
            return null;
        }
        Props resolvedProps = new Props();
        for (String key : props.getKeySet()) {
            StringBuffer replaced = new StringBuffer();
            String value = props.get(key);
            Matcher matcher = VARIABLE_PATTERN.matcher(value);
            while (matcher.find()) {
                String variableName = matcher.group(1);
                if (variableName.equals(key)) {
                    throw new IllegalArgumentException(String.format("Circular property definition starting from property[%s]", key));
                }
                String replacement = props.get(variableName);
                if (replacement == null) {
                    throw new UndefinedPropertyException("Could not find variable substitution for variable '" + variableName + "' in key '" + key + "'.");
                }
                replacement = replacement.replaceAll("\\\\", "\\\\\\\\");
                replacement = replacement.replaceAll("\\$", "\\\\\\$");
                matcher.appendReplacement(replaced, replacement);
                matcher.appendTail(replaced);
                value = replaced.toString();
                replaced = new StringBuffer();
                matcher = VARIABLE_PATTERN.matcher(value);
            }
            matcher.appendTail(replaced);
            resolvedProps.put(key, replaced.toString());
        }
        return resolvedProps;
    }

    public static Props addCommonFlowProperties(ExecutableFlow flow) {
        Props parentProps = new Props();
        parentProps.put("azkaban.flow.flowid", flow.getFlowId());
        parentProps.put("azkaban.flow.execid", flow.getExecutionId());
        parentProps.put("azkaban.flow.projectid", flow.getProjectId());
        parentProps.put("azkaban.flow.projectversion", flow.getVersion());
        parentProps.put("azkaban.flow.uuid", UUID.randomUUID().toString());
        DateTime loadTime = new DateTime();
        parentProps.put("azkaban.flow.start.timestamp", loadTime.toString());
        parentProps.put("azkaban.flow.start.year", loadTime.toString("yyyy"));
        parentProps.put("azkaban.flow.start.month", loadTime.toString("MM"));
        parentProps.put("azkaban.flow.start.day", loadTime.toString("dd"));
        parentProps.put("azkaban.flow.start.hour", loadTime.toString("HH"));
        parentProps.put("azkaban.flow.start.minute", loadTime.toString("mm"));
        parentProps.put("azkaban.flow.start.second", loadTime.toString("ss"));
        parentProps.put("azkaban.flow.start.milliseconds", loadTime.toString("SSS"));
        parentProps.put("azkaban.flow.start.timezone", loadTime.toString("ZZZZ"));
        return parentProps;
    }

    public static String toJSONString(Props props, boolean localOnly) {
        Map<String, String> map = PropsUtils.toStringMap(props, localOnly);
        return JSONUtils.toJSON(map);
    }

    public static Map<String, String> toStringMap(Props props, boolean localOnly) {
        HashMap<String, String> map = new HashMap<String, String>();
        Set<String> keyset = localOnly ? props.localKeySet() : props.getKeySet();
        for (String key : keyset) {
            String value = props.get(key);
            map.put(key, value);
        }
        return map;
    }

    public static Props fromJSONString(String json) {
        try {
            Map obj = (Map)JSONUtils.parseJSONFromString(json);
            Props props = new Props(null, obj);
            return props;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Props fromHierarchicalMap(Map<String, Object> propsMap) {
        if (propsMap == null) {
            return null;
        }
        String source = (String)propsMap.get("source");
        Map propsParams = (Map)propsMap.get("props");
        Map parent = (Map)propsMap.get("parent");
        Props parentProps = PropsUtils.fromHierarchicalMap(parent);
        Props props = new Props(parentProps, propsParams);
        props.setSource(source);
        return props;
    }

    public static Map<String, Object> toHierarchicalMap(Props props) {
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put("source", props.getSource());
        propsMap.put("props", PropsUtils.toStringMap(props, true));
        if (props.getParent() != null) {
            propsMap.put("parent", PropsUtils.toHierarchicalMap(props.getParent()));
        }
        return propsMap;
    }
}

