/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project;

public class ProjectLogEvent {
    private final int projectId;
    private final String user;
    private final long time;
    private final EventType type;
    private final String message;

    public ProjectLogEvent(int projectId, EventType type, long time, String user, String message) {
        this.projectId = projectId;
        this.user = user;
        this.time = time;
        this.type = type;
        this.message = message;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public String getUser() {
        return this.user;
    }

    public long getTime() {
        return this.time;
    }

    public EventType getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum EventType {
        ERROR(128),
        CREATED(1),
        DELETED(2),
        USER_PERMISSION(3),
        GROUP_PERMISSION(4),
        DESCRIPTION(5),
        UPLOADED(6),
        SCHEDULE(7),
        SLA(8);

        private int numVal;

        private EventType(int numVal) {
            this.numVal = numVal;
        }

        public int getNumVal() {
            return this.numVal;
        }

        public static EventType fromInteger(int x) {
            switch (x) {
                case 1: {
                    return CREATED;
                }
                case 2: {
                    return DELETED;
                }
                case 3: {
                    return USER_PERMISSION;
                }
                case 4: {
                    return GROUP_PERMISSION;
                }
                case 5: {
                    return DESCRIPTION;
                }
                case 6: {
                    return UPLOADED;
                }
                case 7: {
                    return SCHEDULE;
                }
                case 8: {
                    return SLA;
                }
                case 128: {
                    return ERROR;
                }
            }
            return ERROR;
        }
    }
}

