/*
 * Decompiled with CFR 0.152.
 */
package voldemort;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import voldemort.VoldemortException;
import voldemort.client.ClientConfig;
import voldemort.client.DefaultStoreClient;
import voldemort.client.SocketStoreClientFactory;
import voldemort.client.StoreClientFactory;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.serialization.SerializationException;
import voldemort.serialization.json.EndOfFileException;
import voldemort.serialization.json.JsonReader;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortClientShell {
    private static final String PROMPT = "> ";
    private static DefaultStoreClient<Object, Object> client;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        OptionParser parser = new OptionParser();
        parser.accepts("client-zone-id", "client zone id for zone routing").withRequiredArg().describedAs("zone-id").ofType(Integer.class);
        OptionSet options = parser.parse(args);
        List nonOptions = options.nonOptionArguments();
        if (nonOptions.size() < 2 || nonOptions.size() > 3) {
            System.err.println("Usage: java VoldemortClientShell store_name bootstrap_url [command_file] [options]");
            parser.printHelpOn((OutputStream)System.err);
            System.exit(-1);
        }
        String storeName = (String)nonOptions.get(0);
        String bootstrapUrl = (String)nonOptions.get(1);
        String commandsFileName = "";
        BufferedReader fileReader = null;
        BufferedReader inputReader = null;
        try {
            if (nonOptions.size() == 3) {
                commandsFileName = (String)nonOptions.get(2);
                fileReader = new BufferedReader(new FileReader(commandsFileName));
            }
            inputReader = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (IOException e) {
            Utils.croak("Failure to open input stream: " + e.getMessage());
        }
        ClientConfig clientConfig = new ClientConfig().setBootstrapUrls(bootstrapUrl).setEnableLazy(false).setRequestFormatType(RequestFormatType.VOLDEMORT_V3);
        if (options.has("client-zone-id")) {
            clientConfig.setClientZoneId((Integer)options.valueOf("client-zone-id"));
        }
        SocketStoreClientFactory factory = null;
        AdminClient adminClient = null;
        try {
            try {
                factory = new SocketStoreClientFactory(clientConfig);
                client = (DefaultStoreClient)factory.getStoreClient(storeName);
                adminClient = new AdminClient(bootstrapUrl, new AdminClientConfig());
            }
            catch (Exception e) {
                Utils.croak("Could not connect to server: " + e.getMessage());
            }
            System.out.println("Established connection to " + storeName + " via " + bootstrapUrl);
            System.out.print(PROMPT);
            if (fileReader != null) {
                VoldemortClientShell.processCommands(factory, adminClient, fileReader, true);
                fileReader.close();
            }
            VoldemortClientShell.processCommands(factory, adminClient, inputReader, false);
        }
        finally {
            if (adminClient != null) {
                adminClient.stop();
            }
            if (factory != null) {
                factory.close();
            }
        }
    }

    private static void processCommands(StoreClientFactory factory, AdminClient adminClient, BufferedReader reader, boolean printCommands) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (!line.trim().equals("")) {
                block41: {
                    if (printCommands) {
                        System.out.println(line);
                    }
                    try {
                        BufferedWriter writer;
                        List<Integer> partititionList;
                        String storeName;
                        String[] args;
                        Object key;
                        JsonReader jsonReader;
                        if (line.toLowerCase().startsWith("put")) {
                            jsonReader = new JsonReader(new StringReader(line.substring("put".length())));
                            key = VoldemortClientShell.tightenNumericTypes(jsonReader.read());
                            Object value = VoldemortClientShell.tightenNumericTypes(jsonReader.read());
                            if (jsonReader.hasMore()) {
                                client.put(key, value, VoldemortClientShell.tightenNumericTypes(jsonReader.read()));
                            } else {
                                client.put(key, value);
                            }
                            break block41;
                        }
                        if (line.toLowerCase().startsWith("getall")) {
                            jsonReader = new JsonReader(new StringReader(line.substring("getall".length())));
                            ArrayList<Object> keys = new ArrayList<Object>();
                            try {
                                while (true) {
                                    keys.add(jsonReader.read());
                                }
                            }
                            catch (EndOfFileException e) {
                                Map<Object, Versioned<Object>> vals = client.getAll(keys);
                                if (vals.size() > 0) {
                                    for (Map.Entry<Object, Versioned<Object>> entry : vals.entrySet()) {
                                        System.out.print(entry.getKey());
                                        System.out.print(" => ");
                                        VoldemortClientShell.printVersioned(entry.getValue());
                                    }
                                } else {
                                    System.out.println("null");
                                }
                                break block41;
                            }
                        }
                        if (line.toLowerCase().startsWith("getmetadata")) {
                            String key2;
                            args = line.substring("getmetadata".length() + 1).split("\\s+");
                            int remoteNodeId = Integer.valueOf(args[0]);
                            Versioned<String> versioned = adminClient.getRemoteMetadata(remoteNodeId, key2 = args[1]);
                            if (versioned == null) {
                                System.out.println("null");
                            } else {
                                System.out.println(versioned.getVersion());
                                System.out.print(": ");
                                System.out.println(versioned.getValue());
                                System.out.println();
                            }
                            break block41;
                        }
                        if (line.toLowerCase().startsWith("get")) {
                            jsonReader = new JsonReader(new StringReader(line.substring("get".length())));
                            key = VoldemortClientShell.tightenNumericTypes(jsonReader.read());
                            if (jsonReader.hasMore()) {
                                VoldemortClientShell.printVersioned(client.get(key, VoldemortClientShell.tightenNumericTypes(jsonReader.read())));
                            } else {
                                VoldemortClientShell.printVersioned(client.get(key));
                            }
                            break block41;
                        }
                        if (line.toLowerCase().startsWith("delete")) {
                            jsonReader = new JsonReader(new StringReader(line.substring("delete".length())));
                            client.delete(VoldemortClientShell.tightenNumericTypes(jsonReader.read()));
                            break block41;
                        }
                        if (line.startsWith("preflist")) {
                            jsonReader = new JsonReader(new StringReader(line.substring("preflist".length())));
                            key = VoldemortClientShell.tightenNumericTypes(jsonReader.read());
                            VoldemortClientShell.printNodeList(client.getResponsibleNodes(key), factory.getFailureDetector());
                            break block41;
                        }
                        if (line.toLowerCase().startsWith("fetchkeys")) {
                            args = line.substring("fetchkeys".length() + 1).split("\\s+");
                            int remoteNodeId = Integer.valueOf(args[0]);
                            storeName = args[1];
                            partititionList = VoldemortClientShell.parseCsv(args[2]);
                            Iterator<ByteArray> partitionKeys = adminClient.fetchKeys(remoteNodeId, storeName, partititionList, null, false);
                            writer = null;
                            try {
                                writer = args.length > 3 ? new BufferedWriter(new FileWriter(new File(args[3]))) : new BufferedWriter(new OutputStreamWriter(System.out));
                            }
                            catch (IOException e) {
                                System.err.println("Failed to open the output stream");
                                e.printStackTrace();
                            }
                            if (writer != null) {
                                while (partitionKeys.hasNext()) {
                                    ByteArray keyByteArray = partitionKeys.next();
                                    StringBuilder lineBuilder = new StringBuilder();
                                    lineBuilder.append(ByteUtils.getString(keyByteArray.get(), "UTF-8"));
                                    lineBuilder.append("\n");
                                    writer.write(lineBuilder.toString());
                                }
                                writer.flush();
                            }
                            break block41;
                        }
                        if (line.toLowerCase().startsWith("fetch")) {
                            args = line.substring("fetch".length() + 1).split("\\s+");
                            int remoteNodeId = Integer.valueOf(args[0]);
                            storeName = args[1];
                            partititionList = VoldemortClientShell.parseCsv(args[2]);
                            Iterator<Pair<ByteArray, Versioned<byte[]>>> partitionEntries = adminClient.fetchEntries(remoteNodeId, storeName, partititionList, null, false);
                            writer = null;
                            try {
                                writer = args.length > 3 ? new BufferedWriter(new FileWriter(new File(args[3]))) : new BufferedWriter(new OutputStreamWriter(System.out));
                            }
                            catch (IOException e) {
                                System.err.println("Failed to open the output stream");
                                e.printStackTrace();
                            }
                            if (writer != null) {
                                while (partitionEntries.hasNext()) {
                                    Pair<ByteArray, Versioned<byte[]>> pair = partitionEntries.next();
                                    ByteArray keyByteArray = pair.getFirst();
                                    Versioned<byte[]> versioned = pair.getSecond();
                                    StringBuilder lineBuilder = new StringBuilder();
                                    lineBuilder.append(ByteUtils.getString(keyByteArray.get(), "UTF-8"));
                                    lineBuilder.append("\t");
                                    lineBuilder.append(versioned.getVersion());
                                    lineBuilder.append("\t");
                                    lineBuilder.append(ByteUtils.getString(versioned.getValue(), "UTF-8"));
                                    lineBuilder.append("\n");
                                    writer.write(lineBuilder.toString());
                                }
                                writer.flush();
                            }
                            break block41;
                        }
                        if (line.startsWith("help")) {
                            System.out.println("Commands:");
                            System.out.println("put key value -- Associate the given value with the key.");
                            System.out.println("get key -- Retrieve the value associated with the key.");
                            System.out.println("getall key -- Retrieve the value(s) associated with the key.");
                            System.out.println("delete key -- Remove all values associated with the key.");
                            System.out.println("preflist key -- Get node preference list for given key.");
                            System.out.println("getmetadata node_id key -- Get metadata associated with key from node_id.");
                            System.out.println("fetchkeys node_id store_name partitions <file_name> -- Fetch all keys from given partitions (a comma separated list) of store_name on node_id. Optionally, write to file_name.");
                            System.out.println("fetch node_id store_name partitions <file_name> -- Fetch all entries from given partitions (a comma separated list) of store_name on node_id. Optionally, write to file_name.");
                            System.out.println("help -- Print this message.");
                            System.out.println("exit -- Exit from this shell.");
                            System.out.println();
                        } else if (line.startsWith("quit") || line.startsWith("exit")) {
                            System.out.println("k k thx bye.");
                            System.exit(0);
                        } else {
                            System.err.println("Invalid command.");
                        }
                    }
                    catch (EndOfFileException e) {
                        System.err.println("Expected additional token.");
                    }
                    catch (SerializationException e) {
                        System.err.print("Error serializing values: ");
                        e.printStackTrace();
                    }
                    catch (VoldemortException e) {
                        System.err.println("Exception thrown during operation.");
                        e.printStackTrace(System.err);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        System.err.println("Invalid command.");
                    }
                    catch (Exception e) {
                        System.err.println("Unexpected error:");
                        e.printStackTrace(System.err);
                    }
                }
                System.out.print(PROMPT);
            }
            line = reader.readLine();
        }
    }

    private static List<Integer> parseCsv(String csv) {
        return Lists.transform(Arrays.asList(csv.split(",")), (Function)new Function<String, Integer>(){

            public Integer apply(String input) {
                return Integer.valueOf(input);
            }
        });
    }

    private static void printNodeList(List<Node> nodes, FailureDetector failureDetector) {
        if (nodes.size() > 0) {
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                System.out.println("Node " + node.getId());
                System.out.println("host:  " + node.getHost());
                System.out.println("port: " + node.getSocketPort());
                System.out.println("available: " + (failureDetector.isAvailable(node) ? "yes" : "no"));
                System.out.println("last checked: " + failureDetector.getLastChecked(node) + " ms ago");
                System.out.println();
            }
        }
    }

    private static void printVersioned(Versioned<Object> v) {
        if (v == null) {
            System.out.println("null");
        } else {
            System.out.print(v.getVersion());
            System.out.print(": ");
            VoldemortClientShell.printObject(v.getValue());
            System.out.println();
        }
    }

    private static void printObject(Object o) {
        if (o == null) {
            System.out.print("null");
        } else if (o instanceof String) {
            System.out.print('\"');
            System.out.print(o);
            System.out.print('\"');
        } else if (o instanceof Date) {
            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            System.out.print("'");
            System.out.print(df.format((Date)o));
            System.out.print("'");
        } else if (o instanceof List) {
            List l = (List)o;
            System.out.print("[");
            for (Object obj : l) {
                VoldemortClientShell.printObject(obj);
            }
            System.out.print("]");
        } else if (o instanceof Map) {
            Map m = (Map)o;
            System.out.print('{');
            for (String s : m.keySet()) {
                VoldemortClientShell.printObject(s);
                System.out.print(':');
                VoldemortClientShell.printObject(m.get(s));
                System.out.print(", ");
            }
            System.out.print('}');
        } else {
            System.out.print(o);
        }
    }

    private static Object tightenNumericTypes(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List l = (List)o;
            for (int i = 0; i < l.size(); ++i) {
                l.set(i, VoldemortClientShell.tightenNumericTypes(l.get(i)));
            }
            return l;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                m.put(entry.getKey(), VoldemortClientShell.tightenNumericTypes(entry.getValue()));
            }
            return m;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if (o instanceof Integer) {
                if (n.intValue() < 127) {
                    return n.byteValue();
                }
                if (n.intValue() < Short.MAX_VALUE) {
                    return n.shortValue();
                }
                return n;
            }
            if (o instanceof Double) {
                if (n.doubleValue() < 3.4028234663852886E38) {
                    return Float.valueOf(n.floatValue());
                }
                return n;
            }
            throw new RuntimeException("Unsupported numeric type: " + o.getClass());
        }
        return o;
    }
}

