/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.rebalance;

import voldemort.annotations.jmx.JmxManaged;
import voldemort.server.AbstractService;
import voldemort.server.ServiceType;
import voldemort.server.StoreRepository;
import voldemort.server.VoldemortConfig;
import voldemort.server.protocol.admin.AsyncOperationService;
import voldemort.server.rebalance.Rebalancer;
import voldemort.server.scheduler.SchedulerService;
import voldemort.store.metadata.MetadataStore;

@JmxManaged(description="Rebalancer service to help with rebalancing")
public class RebalancerService
extends AbstractService {
    private final SchedulerService schedulerService;
    private final Rebalancer rebalancer;

    public RebalancerService(StoreRepository storeRepository, MetadataStore metadataStore, VoldemortConfig voldemortConfig, AsyncOperationService asyncService, SchedulerService service) {
        super(ServiceType.REBALANCE);
        this.schedulerService = service;
        this.rebalancer = new Rebalancer(storeRepository, metadataStore, voldemortConfig, asyncService);
    }

    protected void startInner() {
        this.rebalancer.start();
        this.schedulerService.scheduleNow(this.rebalancer);
    }

    protected void stopInner() {
        this.rebalancer.stop();
    }

    public Rebalancer getRebalancer() {
        return this.rebalancer;
    }
}

