/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import com.google.common.collect.Lists;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.VoldemortUnsupportedOperationalException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.routing.RoutingStrategy;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.StorageEngine;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.readonly.ReadOnlyStorageFormat;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.SearchStrategy;
import voldemort.store.readonly.chunk.ChunkedFileSet;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStorageEngine
implements StorageEngine<ByteArray, byte[], byte[]> {
    private static Logger logger = Logger.getLogger(ReadOnlyStorageEngine.class);
    private final String name;
    private final int numBackups;
    private final int nodeId;
    private long currentVersionId;
    private final File storeDir;
    private final ReadWriteLock fileModificationLock;
    private final SearchStrategy searchStrategy;
    private RoutingStrategy routingStrategy;
    private volatile ChunkedFileSet fileSet;
    private volatile boolean isOpen;
    private int deleteBackupMs = 0;
    private long lastSwapped;

    public ReadOnlyStorageEngine(String name, SearchStrategy searchStrategy, RoutingStrategy routingStrategy, int nodeId, File storeDir, int numBackups, int deleteBackupMs) {
        this(name, searchStrategy, routingStrategy, nodeId, storeDir, numBackups);
        this.deleteBackupMs = deleteBackupMs;
    }

    public ReadOnlyStorageEngine(String name, SearchStrategy searchStrategy, RoutingStrategy routingStrategy, int nodeId, File storeDir, int numBackups) {
        this.storeDir = storeDir;
        this.numBackups = numBackups;
        this.name = Utils.notNull(name);
        this.searchStrategy = searchStrategy;
        this.routingStrategy = Utils.notNull(routingStrategy);
        this.nodeId = nodeId;
        this.fileSet = null;
        this.currentVersionId = 0L;
        this.fileModificationLock = new ReentrantReadWriteLock();
        this.isOpen = false;
        this.open(null);
    }

    public ChunkedFileSet getChunkedFileSet() {
        return this.fileSet;
    }

    @JmxGetter(name="getChunkIdToNumChunks", description="Returns a string representation of the map of chunk id to number of chunks")
    public String getChunkIdToNumChunks() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Integer> entry : this.fileSet.getChunkIdToNumChunks().entrySet()) {
            builder.append(entry.getKey().toString() + " - " + entry.getValue().toString() + ", ");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File versionDir) {
        this.fileModificationLock.writeLock().lock();
        try {
            long versionId;
            if (this.isOpen) {
                throw new IllegalStateException("Attempt to open already open store.");
            }
            if (versionDir == null && (versionDir = ReadOnlyUtils.getCurrentVersion(this.storeDir)) == null) {
                versionDir = new File(this.storeDir, "version-0");
            }
            if ((versionId = ReadOnlyUtils.getVersionId(versionDir)) == -1L) {
                throw new VoldemortException("Unable to parse id from version directory " + versionDir.getAbsolutePath());
            }
            this.currentVersionId = versionId;
            Utils.mkdirs(versionDir);
            logger.info((Object)("Creating symbolic link for '" + this.getName() + "' using directory " + versionDir.getAbsolutePath()));
            Utils.symlink(versionDir.getAbsolutePath(), this.storeDir.getAbsolutePath() + File.separator + "latest");
            this.fileSet = new ChunkedFileSet(versionDir, this.routingStrategy, this.nodeId);
            this.lastSwapped = System.currentTimeMillis();
            this.isOpen = true;
            Object var5_3 = null;
            this.fileModificationLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.fileModificationLock.writeLock().unlock();
            throw throwable;
        }
    }

    public void setRoutingStrategy(RoutingStrategy routingStrategy) {
        if (this.fileSet == null) {
            throw new VoldemortException("File set should not be null");
        }
        this.routingStrategy = routingStrategy;
    }

    public String getCurrentDirPath() {
        return this.storeDir.getAbsolutePath() + File.separator + "version-" + Long.toString(this.currentVersionId);
    }

    public long getCurrentVersionId() {
        return this.currentVersionId;
    }

    public String getStoreDirPath() {
        return this.storeDir.getAbsolutePath();
    }

    public ReadOnlyStorageFormat getReadOnlyStorageFormat() {
        return this.fileSet.getReadOnlyStorageFormat();
    }

    @JmxGetter(name="lastSwapped", description="Time in milliseconds since the store was swapped")
    public long getLastSwapped() {
        long timeSinceLastSwap = System.currentTimeMillis() - this.lastSwapped;
        return timeSinceLastSwap > 0L ? timeSinceLastSwap : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws VoldemortException {
        logger.debug((Object)"Close called for read-only store.");
        this.fileModificationLock.writeLock().lock();
        try {
            if (this.isOpen) {
                this.isOpen = false;
                this.fileSet.close();
            } else {
                logger.debug((Object)("Attempt to close already closed store " + this.getName()));
            }
            Object var2_1 = null;
            this.fileModificationLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.fileModificationLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JmxOperation(description="swapFiles changes this store to use the new data directory")
    public void swapFiles(String newStoreDirectory) {
        logger.info((Object)("Swapping files for store '" + this.getName() + "' to " + newStoreDirectory));
        File newVersionDir = new File(newStoreDirectory);
        if (!newVersionDir.exists()) {
            throw new VoldemortException("File " + newVersionDir.getAbsolutePath() + " does not exist.");
        }
        if (newVersionDir.getParentFile().compareTo(this.storeDir.getAbsoluteFile()) != 0) throw new VoldemortException("Invalid version folder name '" + newVersionDir + "'. Either parent directory is incorrect or format(version-n) is incorrect");
        if (!ReadOnlyUtils.checkVersionDirName(newVersionDir)) {
            throw new VoldemortException("Invalid version folder name '" + newVersionDir + "'. Either parent directory is incorrect or format(version-n) is incorrect");
        }
        File previousVersionDir = ReadOnlyUtils.getCurrentVersion(this.storeDir);
        if (previousVersionDir == null) {
            throw new VoldemortException("Could not find any latest directory to swap with in store '" + this.getName() + "'");
        }
        long newVersionId = ReadOnlyUtils.getVersionId(newVersionDir);
        long previousVersionId = ReadOnlyUtils.getVersionId(previousVersionDir);
        if (newVersionId == -1L) throw new VoldemortException("Unable to parse folder names (" + newVersionDir.getName() + "," + previousVersionDir.getName() + ") since format(version-n) is incorrect");
        if (previousVersionId == -1L) {
            throw new VoldemortException("Unable to parse folder names (" + newVersionDir.getName() + "," + previousVersionDir.getName() + ") since format(version-n) is incorrect");
        }
        if (previousVersionId > newVersionId) {
            logger.info((Object)("No swap required since current latest version " + previousVersionId + " is greater than swap version " + newVersionId));
            this.deleteBackups();
            return;
        }
        logger.info((Object)("Acquiring write lock on '" + this.getName() + "':"));
        this.fileModificationLock.writeLock().lock();
        boolean success = false;
        try {
            this.close();
            logger.info((Object)("Opening primary files for store '" + this.getName() + "' at " + newStoreDirectory));
            this.open(newVersionDir);
            success = true;
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            try {}
            catch (Throwable throwable2) {
                Object var12_12 = null;
                this.fileModificationLock.writeLock().unlock();
                if (success) {
                    logger.info((Object)("Swap operation completed successfully on store " + this.getName() + ", releasing lock."));
                    throw throwable2;
                }
                logger.error((Object)"Swap operation failed.");
                throw throwable2;
            }
            if (!success) {
                this.rollback(previousVersionDir);
            }
            Object var12_11 = null;
            this.fileModificationLock.writeLock().unlock();
            if (success) {
                logger.info((Object)("Swap operation completed successfully on store " + this.getName() + ", releasing lock."));
                throw throwable;
            }
            logger.error((Object)"Swap operation failed.");
            throw throwable;
        }
        try {
            if (!success) {
                this.rollback(previousVersionDir);
            }
            Object var12_9 = null;
            this.fileModificationLock.writeLock().unlock();
            if (success) {
                logger.info((Object)("Swap operation completed successfully on store " + this.getName() + ", releasing lock."));
            }
            logger.error((Object)"Swap operation failed.");
        }
        catch (Throwable throwable) {
            Object var12_10 = null;
            this.fileModificationLock.writeLock().unlock();
            if (success) {
                logger.info((Object)("Swap operation completed successfully on store " + this.getName() + ", releasing lock."));
                throw throwable;
            }
            logger.error((Object)"Swap operation failed.");
            throw throwable;
        }
        this.deleteBackups();
    }

    private void deleteBackups() {
        File[] extraBackups;
        File[] storeDirList = ReadOnlyUtils.getVersionDirs(this.storeDir, 0L, this.currentVersionId);
        if (storeDirList != null && storeDirList.length > this.numBackups + 1 && (extraBackups = ReadOnlyUtils.findKthVersionedDir(storeDirList, 0, storeDirList.length - (this.numBackups + 1) - 1)) != null) {
            for (File backUpFile : extraBackups) {
                this.deleteAsync(backUpFile);
            }
        }
    }

    private void deleteAsync(final File file) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        logger.info((Object)("Waiting for " + ReadOnlyStorageEngine.this.deleteBackupMs + " milliseconds before deleting " + file.getAbsolutePath()));
                        Thread.sleep(ReadOnlyStorageEngine.this.deleteBackupMs);
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)"Did not sleep enough before deleting backups");
                    }
                    logger.info((Object)("Deleting file " + file.getAbsolutePath()));
                    Utils.rm(file);
                    logger.info((Object)("Deleting of " + file.getAbsolutePath() + " completed successfully."));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }, "background-file-delete").start();
    }

    @JmxOperation(description="Rollback to a previous version directory ( full path ) ")
    public void rollback(String rollbackToDir) {
        this.rollback(new File(rollbackToDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(File rollbackToDir) {
        block9: {
            block8: {
                logger.info((Object)("Rolling back store '" + this.getName() + "'"));
                this.fileModificationLock.writeLock().lock();
                try {
                    if (rollbackToDir == null) {
                        throw new VoldemortException("Version directory specified to rollback is null");
                    }
                    if (!rollbackToDir.exists()) {
                        throw new VoldemortException("Version directory " + rollbackToDir.getAbsolutePath() + " specified to rollback does not exist");
                    }
                    long versionId = ReadOnlyUtils.getVersionId(rollbackToDir);
                    if (versionId == -1L) {
                        throw new VoldemortException("Cannot parse version id");
                    }
                    File[] backUpDirs = ReadOnlyUtils.getVersionDirs(this.storeDir, versionId, Long.MAX_VALUE);
                    if (backUpDirs == null || backUpDirs.length <= 1) {
                        logger.warn((Object)"No rollback performed since there are no back-up directories");
                        Object var8_4 = null;
                        this.fileModificationLock.writeLock().unlock();
                        break block8;
                    }
                    backUpDirs = ReadOnlyUtils.findKthVersionedDir(backUpDirs, 0, backUpDirs.length - 1);
                    if (this.isOpen) {
                        this.close();
                    }
                    this.open(rollbackToDir);
                    SimpleDateFormat df = new SimpleDateFormat("MM-dd-yyyy");
                    for (int index = 1; index < backUpDirs.length; ++index) {
                        Utils.move(backUpDirs[index], new File(this.storeDir, backUpDirs[index].getName() + "." + df.format(new Date()) + ".bak"));
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var8_6 = null;
                    this.fileModificationLock.writeLock().unlock();
                    logger.info((Object)("Rollback operation completed on '" + this.getName() + "', releasing lock."));
                    throw throwable;
                }
            }
            logger.info((Object)("Rollback operation completed on '" + this.getName() + "', releasing lock."));
            return;
        }
        Object var8_5 = null;
        this.fileModificationLock.writeLock().unlock();
        logger.info((Object)("Rollback operation completed on '" + this.getName() + "', releasing lock."));
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        if (this.fileSet.getReadOnlyStorageFormat().compareTo(ReadOnlyStorageFormat.READONLY_V2) != 0) {
            throw new UnsupportedOperationException("Iteration is not supported for " + this.getClass().getName() + " with storage format " + (Object)((Object)this.fileSet.getReadOnlyStorageFormat()));
        }
        return new ChunkedFileSet.ROKeyIterator(this.fileSet, this.fileModificationLock);
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        if (this.fileSet.getReadOnlyStorageFormat().compareTo(ReadOnlyStorageFormat.READONLY_V2) != 0) {
            throw new UnsupportedOperationException("Iteration is not supported for " + this.getClass().getName() + " with storage format " + (Object)((Object)this.fileSet.getReadOnlyStorageFormat()));
        }
        return new ChunkedFileSet.ROEntriesIterator(this.fileSet, this.fileModificationLock);
    }

    @Override
    public void truncate() {
        if (this.isOpen) {
            this.close();
        }
        Utils.rm(this.storeDir);
        logger.debug((Object)"Truncate successful for read-only store ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        block6: {
            byte[] value;
            block7: {
                int chunk;
                block5: {
                    StoreUtils.assertValidKey(key);
                    try {
                        this.fileModificationLock.readLock().lock();
                        chunk = this.fileSet.getChunkForKey(key.get());
                        if (chunk >= 0) break block5;
                        logger.warn((Object)"Invalid chunk id returned. Either routing strategy is inconsistent or storage format not understood");
                        List<Versioned<byte[]>> list = Collections.emptyList();
                        Object var8_6 = null;
                        this.fileModificationLock.readLock().unlock();
                        return list;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        this.fileModificationLock.readLock().unlock();
                        throw throwable;
                    }
                }
                int location = this.searchStrategy.indexOf(this.fileSet.indexFileFor(chunk), this.fileSet.keyToStorageFormat(key.get()), this.fileSet.getIndexFileSize(chunk));
                if (location < 0) break block6;
                value = this.fileSet.readValue(key.get(), chunk, location);
                if (value.length != 0) break block7;
                List<Versioned<byte[]>> list = Collections.emptyList();
                Object var8_7 = null;
                this.fileModificationLock.readLock().unlock();
                return list;
            }
            List<Versioned<byte[]>> list = Collections.singletonList(Versioned.value(value));
            Object var8_8 = null;
            this.fileModificationLock.readLock().unlock();
            return list;
        }
        List<Versioned<byte[]>> list = Collections.emptyList();
        Object var8_9 = null;
        this.fileModificationLock.readLock().unlock();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        HashMap<ByteArray, List<Versioned<byte[]>>> results = StoreUtils.newEmptyHashMap(keys);
        try {
            this.fileModificationLock.readLock().lock();
            ArrayList keysAndValueLocations = Lists.newArrayList();
            for (ByteArray key : keys) {
                int chunk = this.fileSet.getChunkForKey(key.get());
                int valueLocation = this.searchStrategy.indexOf(this.fileSet.indexFileFor(chunk), this.fileSet.keyToStorageFormat(key.get()), this.fileSet.getIndexFileSize(chunk));
                if (valueLocation < 0) continue;
                keysAndValueLocations.add(new KeyValueLocation(chunk, key, valueLocation));
            }
            Collections.sort(keysAndValueLocations);
            for (KeyValueLocation keyVal : keysAndValueLocations) {
                byte[] value = this.fileSet.readValue(keyVal.getKey().get(), keyVal.getChunk(), keyVal.getValueLocation());
                if (value.length <= 0) continue;
                results.put(keyVal.getKey(), Collections.singletonList(Versioned.value(value)));
            }
            HashMap<ByteArray, List<Versioned<byte[]>>> hashMap = results;
            Object var10_10 = null;
            this.fileModificationLock.readLock().unlock();
            return hashMap;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.fileModificationLock.readLock().unlock();
            throw throwable;
        }
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        throw new UnsupportedOperationException("Delete is not supported on this store, it is read-only.");
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        throw new VoldemortUnsupportedOperationalException("Put is not supported on this store, it is read-only.");
    }

    @Override
    @JmxGetter(name="name", description="The name of the store.")
    public String getName() {
        return this.name;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        return StoreUtils.getVersions(this.get(key, null));
    }

    @Override
    public boolean isPartitionAware() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class KeyValueLocation
    implements Comparable<KeyValueLocation> {
        private final int chunk;
        private final ByteArray key;
        private final int valueLocation;

        private KeyValueLocation(int chunk, ByteArray key, int valueLocation) {
            this.chunk = chunk;
            this.key = key;
            this.valueLocation = valueLocation;
        }

        public int getChunk() {
            return this.chunk;
        }

        public ByteArray getKey() {
            return this.key;
        }

        public int getValueLocation() {
            return this.valueLocation;
        }

        @Override
        public int compareTo(KeyValueLocation kvl) {
            if (this.chunk == kvl.getChunk()) {
                if (this.valueLocation == kvl.getValueLocation()) {
                    return ByteUtils.compare(this.getKey().get(), kvl.getKey().get());
                }
                return Integer.signum(this.valueLocation - kvl.getValueLocation());
            }
            return this.getChunk() - kvl.getChunk();
        }
    }
}

