/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.AccumulativeTupleBuffer;
import org.apache.pig.data.AccumulativeBag;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataType;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.IdentityHashSet;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.pen.util.ExampleTuple;
import org.apache.pig.pen.util.LineageTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POPackage
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    transient Iterator<NullableTuple> tupIter;
    Object key;
    protected boolean isKeyTuple = false;
    protected Tuple keyAsTuple;
    byte keyType;
    int numInputs = -1;
    boolean useSecondaryKey = false;
    boolean[] inner;
    protected boolean distinct = false;
    protected Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo = new HashMap<Integer, Pair<Boolean, Map<Integer, Integer>>>();
    protected static final BagFactory mBagFactory = BagFactory.getInstance();
    protected static final TupleFactory mTupleFactory = TupleFactory.getInstance();
    private boolean firstTime = true;
    private boolean useDefaultBag = false;
    private PackageType pkgType;

    public POPackage(OperatorKey k) {
        this(k, -1, null);
    }

    public POPackage(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POPackage(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POPackage(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Package" + "[" + DataType.findTypeName(this.resultType) + "]" + "{" + DataType.findTypeName(this.keyType) + "}" + " - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitPackage(this);
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void attachInput(PigNullableWritable k, Iterator<NullableTuple> inp) {
        this.tupIter = inp;
        this.key = k.getValueAsPigType();
        if (this.useSecondaryKey) {
            try {
                this.key = ((Tuple)this.key).get(0);
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.isKeyTuple) {
            this.keyAsTuple = (Tuple)this.key;
        }
    }

    @Override
    public void detachInput() {
        this.tupIter = null;
        this.key = null;
    }

    public int getNumInps() {
        return this.numInputs;
    }

    public void setNumInps(int numInps) {
        this.numInputs = numInps;
    }

    public boolean[] getInner() {
        return this.inner;
    }

    public void setInner(boolean[] inner) {
        this.inner = inner;
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        Tuple res;
        if (this.firstTime) {
            String bagType;
            this.firstTime = false;
            if (PigMapReduce.sJobConfInternal.get() != null && (bagType = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.cachedbag.type")) != null && bagType.equalsIgnoreCase("default")) {
                this.useDefaultBag = true;
            }
        }
        if (this.distinct) {
            res = mTupleFactory.newTuple(1);
            res.set(0, this.key);
        } else {
            DataBag[] dbs = null;
            dbs = new DataBag[this.numInputs];
            if (this.isAccumulative()) {
                POPackageTupleBuffer buffer = new POPackageTupleBuffer();
                for (int i = 0; i < this.numInputs; ++i) {
                    dbs[i] = new AccumulativeBag(buffer, i);
                }
            } else {
                for (int i = 0; i < this.numInputs; ++i) {
                    dbs[i] = this.useDefaultBag ? BagFactory.getInstance().newDefaultBag() : new InternalCachedBag(this.numInputs);
                }
                while (this.tupIter.hasNext()) {
                    NullableTuple ntup = this.tupIter.next();
                    byte index = ntup.getIndex();
                    Tuple copy = this.getValueTuple(ntup, index);
                    if (this.numInputs == 1) {
                        dbs[0].add(copy);
                    } else {
                        dbs[index].add(copy);
                    }
                    if (reporter == null) continue;
                    reporter.progress();
                }
            }
            res = mTupleFactory.newTuple(this.numInputs + 1);
            res.set(0, this.key);
            int i = -1;
            for (DataBag bag : dbs) {
                if (this.inner[++i] && !this.isAccumulative() && bag.size() == 0L) {
                    this.detachInput();
                    Result r = new Result();
                    r.returnStatus = 1;
                    return r;
                }
                res.set(i + 1, bag);
            }
        }
        Result r = new Result();
        r.returnStatus = 0;
        r.result = !this.isAccumulative() ? this.illustratorMarkup(null, res, 0) : res;
        this.detachInput();
        return r;
    }

    protected Tuple getValueTuple(NullableTuple ntup, int index) throws ExecException {
        Tuple val = (Tuple)ntup.getValueAsPigType();
        Tuple copy = null;
        Pair<Boolean, Map<Integer, Integer>> lrKeyInfo = this.keyInfo.get(index);
        boolean isProjectStar = (Boolean)lrKeyInfo.first;
        Map keyLookup = (Map)lrKeyInfo.second;
        int keyLookupSize = keyLookup.size();
        if (keyLookupSize > 0) {
            int finalValueSize = keyLookupSize + val.size();
            copy = mTupleFactory.newTuple(finalValueSize);
            int valIndex = 0;
            for (int i = 0; i < finalValueSize; ++i) {
                Integer keyIndex = (Integer)keyLookup.get(i);
                if (keyIndex == null) {
                    copy.set(i, val.get(valIndex));
                    ++valIndex;
                    continue;
                }
                if (this.isKeyTuple) {
                    copy.set(i, this.keyAsTuple.get(keyIndex));
                    continue;
                }
                copy.set(i, this.key);
            }
            copy = this.illustratorMarkup2(val, copy);
        } else if (isProjectStar) {
            copy = mTupleFactory.newTuple(this.keyAsTuple.getAll());
            copy = this.illustratorMarkup2(this.keyAsTuple, copy);
        } else {
            copy = mTupleFactory.newTuple(val.getAll());
            copy = this.illustratorMarkup2(val, copy);
        }
        return copy;
    }

    public byte getKeyType() {
        return this.keyType;
    }

    public void setKeyType(byte keyType) {
        this.keyType = keyType;
    }

    @Override
    public POPackage clone() throws CloneNotSupportedException {
        POPackage clone = (POPackage)super.clone();
        clone.mKey = new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope));
        clone.requestedParallelism = this.requestedParallelism;
        clone.resultType = this.resultType;
        clone.keyType = this.keyType;
        clone.numInputs = this.numInputs;
        if (this.inner != null) {
            clone.inner = new boolean[this.inner.length];
            for (int i = 0; i < this.inner.length; ++i) {
                clone.inner[i] = this.inner[i];
            }
        } else {
            clone.inner = null;
        }
        return clone;
    }

    public void setKeyInfo(Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo) {
        this.keyInfo = keyInfo;
    }

    public void setKeyTuple(boolean keyTuple) {
        this.isKeyTuple = keyTuple;
    }

    public Map<Integer, Pair<Boolean, Map<Integer, Integer>>> getKeyInfo() {
        return this.keyInfo;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setUseSecondaryKey(boolean useSecondaryKey) {
        this.useSecondaryKey = useSecondaryKey;
    }

    public void setPackageType(PackageType type) {
        this.pkgType = type;
    }

    public PackageType getPackageType() {
        return this.pkgType;
    }

    private Tuple illustratorMarkup2(Object in, Object out) {
        if (this.illustrator != null) {
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            this.illustrator.getLineage().insert(tOut);
            tOut.synthetic = ((ExampleTuple)in).synthetic;
            this.illustrator.getLineage().union(tOut, (Tuple)in);
            return tOut;
        }
        return (Tuple)out;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            int i;
            ExampleTuple tOut = new ExampleTuple((Tuple)out);
            LineageTracer lineageTracer = this.illustrator.getLineage();
            lineageTracer.insert(tOut);
            boolean synthetic = false;
            if (this.illustrator.getEquivalenceClasses() == null) {
                LinkedList<IdentityHashSet<Tuple>> equivalenceClasses = new LinkedList<IdentityHashSet<Tuple>>();
                for (i = 0; i < this.numInputs; ++i) {
                    IdentityHashSet equivalenceClass = new IdentityHashSet();
                    equivalenceClasses.add(equivalenceClass);
                }
                this.illustrator.setEquivalenceClasses(equivalenceClasses, this);
            }
            if (this.distinct) {
                int count = 0;
                while (this.tupIter.hasNext()) {
                    NullableTuple ntp = this.tupIter.next();
                    Tuple tmp = (Tuple)ntp.getValueAsPigType();
                    if (!tmp.equals(tOut)) {
                        lineageTracer.union(tOut, tmp);
                    }
                    ++count;
                }
                if (count > 1) {
                    this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tOut);
                }
                this.illustrator.addData(tOut);
                return tOut;
            }
            boolean outInEqClass = true;
            try {
                for (i = 1; i < this.numInputs + 1; ++i) {
                    DataBag dbs = (DataBag)((Tuple)out).get(i);
                    Iterator<Tuple> iter = dbs.iterator();
                    if (dbs.size() <= 1L && outInEqClass) {
                        outInEqClass = false;
                    }
                    while (iter.hasNext()) {
                        Tuple tmp = iter.next();
                        if (!synthetic && ((ExampleTuple)tmp).synthetic) {
                            synthetic = true;
                        }
                        lineageTracer.union(tOut, tmp);
                    }
                }
            }
            catch (ExecException e) {
                throw new RuntimeException("Illustrator exception :" + e.getMessage());
            }
            if (outInEqClass) {
                this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tOut);
            }
            tOut.synthetic = synthetic;
            this.illustrator.addData(tOut);
            return tOut;
        }
        return (Tuple)out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class POPackageTupleBuffer
    implements AccumulativeTupleBuffer {
        private List<Tuple>[] bags;
        private Iterator<NullableTuple> iter;
        private int batchSize = 20000;
        private Object currKey;

        public POPackageTupleBuffer() {
            String size;
            if (PigMapReduce.sJobConfInternal.get() != null && (size = ((Configuration)PigMapReduce.sJobConfInternal.get()).get("pig.accumulative.batchsize")) != null) {
                this.batchSize = Integer.parseInt(size);
            }
            this.bags = new List[POPackage.this.numInputs];
            for (int i = 0; i < POPackage.this.numInputs; ++i) {
                this.bags[i] = new ArrayList<Tuple>();
            }
            this.iter = POPackage.this.tupIter;
            this.currKey = POPackage.this.key;
        }

        @Override
        public boolean hasNextBatch() {
            return this.iter.hasNext();
        }

        @Override
        public void nextBatch() throws IOException {
            int i;
            for (i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            POPackage.this.key = this.currKey;
            for (i = 0; i < this.batchSize && this.iter.hasNext(); ++i) {
                NullableTuple ntup = this.iter.next();
                byte index = ntup.getIndex();
                Tuple copy = POPackage.this.getValueTuple(ntup, index);
                if (POPackage.this.numInputs == 1) {
                    this.bags[0].add(copy);
                    continue;
                }
                this.bags[index].add(copy);
            }
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            this.iter = null;
        }

        @Override
        public Iterator<Tuple> getTuples(int index) {
            return this.bags[index].iterator();
        }

        public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
            return POPackage.this.illustratorMarkup(in, out, eqClassIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackageType {
        GROUP,
        JOIN;

    }
}

