/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import com.google.common.collect.ImmutableList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.DefaultStoreClient;
import voldemort.client.LazyStoreClient;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.Store;
import voldemort.utils.Pair;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="A StoreClientFactory which caches clients")
public class CachingStoreClientFactory
implements StoreClientFactory {
    private static final Logger logger = Logger.getLogger(CachingStoreClientFactory.class);
    private final StoreClientFactory inner;
    private final ConcurrentMap<Pair<String, Object>, StoreClient<?, ?>> cache;

    public CachingStoreClientFactory(StoreClientFactory inner) {
        this.inner = inner;
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName) {
        Pair<String, Object> key = Pair.create(storeName, null);
        if (!this.cache.containsKey(key)) {
            StoreClient result = this.inner.getStoreClient(storeName);
            this.cache.putIfAbsent(key, result);
        }
        return (StoreClient)this.cache.get(key);
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        Pair<String, InconsistencyResolver<Versioned<V>>> key = Pair.create(storeName, resolver);
        if (!this.cache.containsKey(key)) {
            StoreClient result = this.inner.getStoreClient(storeName, resolver);
            this.cache.putIfAbsent(key, result);
        }
        return (StoreClient)this.cache.get(key);
    }

    @Override
    public <K, V, T> Store<K, V, T> getRawStore(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        return this.inner.getRawStore(storeName, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.cache.clear();
        }
        finally {
            this.inner.close();
        }
    }

    @Override
    public FailureDetector getFailureDetector() {
        return this.inner.getFailureDetector();
    }

    @JmxOperation(description="Clear the cache")
    public synchronized void clear() {
        try {
            this.cache.clear();
        }
        catch (Exception e) {
            logger.warn((Object)"Exception when clearing the cache", (Throwable)e);
        }
    }

    @JmxOperation(description="Bootstrap all clients in the cache")
    public void bootstrapAllClients() {
        ImmutableList allClients = ImmutableList.copyOf(this.cache.values());
        try {
            for (StoreClient client : allClients) {
                if (client instanceof DefaultStoreClient) {
                    ((DefaultStoreClient)client).bootStrap();
                    continue;
                }
                if (!(client instanceof LazyStoreClient)) continue;
                LazyStoreClient lazyStoreClient = (LazyStoreClient)client;
                ((DefaultStoreClient)lazyStoreClient.getStoreClient()).bootStrap();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Exception during bootstrapAllClients", (Throwable)e);
        }
    }
}

