/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.trigger.TriggerAction;
import azkaban.utils.AbstractMailer;
import azkaban.utils.EmailMessage;
import azkaban.utils.Props;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SendEmailAction
implements TriggerAction {
    private static final Logger logger = Logger.getLogger(SendEmailAction.class);
    private String actionId;
    private Map<String, Object> context;
    private static AbstractMailer mailer;
    private String message;
    public static final String type = "SendEmailAction";
    private String mimetype = "text/html";
    private List<String> emailList;
    private String subject;

    public static void init(Props props) {
        mailer = new AbstractMailer(props);
    }

    public SendEmailAction(String actionId, String subject, String message, List<String> emailList) {
        this.actionId = actionId;
        this.message = message;
        this.subject = subject;
        this.emailList = emailList;
    }

    @Override
    public String getId() {
        return this.actionId;
    }

    @Override
    public String getType() {
        return type;
    }

    public static SendEmailAction createFromJson(Object obj) throws Exception {
        HashMap jsonObj = (HashMap)obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create action of SendEmailAction from " + jsonObj.get("type"));
        }
        String actionId = (String)jsonObj.get("actionId");
        String subject = (String)jsonObj.get("subject");
        String message = (String)jsonObj.get("message");
        List emailList = (List)jsonObj.get("emailList");
        return new SendEmailAction(actionId, subject, message, emailList);
    }

    @Override
    public TriggerAction fromJson(Object obj) throws Exception {
        return SendEmailAction.createFromJson(obj);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("actionId", this.actionId);
        jsonObj.put("type", type);
        jsonObj.put("subject", this.subject);
        jsonObj.put("message", this.message);
        jsonObj.put("emailList", this.emailList);
        return jsonObj;
    }

    @Override
    public void doAction() throws Exception {
        EmailMessage email = mailer.prepareEmailMessage(this.subject, this.mimetype, this.emailList);
        email.setBody(this.message);
        email.sendEmail();
    }

    @Override
    public void setContext(Map<String, Object> context) {
    }

    @Override
    public String getDescription() {
        return type;
    }
}

