/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.DotPOPrinter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.impl.plan.DotPlanDumper;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotMRPrinter
extends DotPlanDumper<MapReduceOper, MROperPlan, InnerOperator, InnerPlan> {
    static int counter = 0;
    boolean isVerboseNesting = true;

    public DotMRPrinter(MROperPlan plan, PrintStream ps) {
        this(plan, ps, false, (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>(), (Set<Operator>)new HashSet<Operator>());
    }

    private DotMRPrinter(MROperPlan plan, PrintStream ps, boolean isSubGraph, Set<Operator> subgraphs, Set<Operator> multiInputSubgraphs, Set<Operator> multiOutputSubgraphs) {
        super(plan, ps, isSubGraph, subgraphs, multiInputSubgraphs, multiOutputSubgraphs);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.isVerboseNesting = verbose;
    }

    protected DotPlanDumper makeDumper(InnerPlan plan, PrintStream ps) {
        return new InnerPrinter(plan, ps, (Set<Operator>)this.mSubgraphs, (Set<Operator>)this.mMultiInputSubgraphs, (Set<Operator>)this.mMultiOutputSubgraphs);
    }

    @Override
    protected String getName(MapReduceOper op) {
        String name = "Map";
        if (!op.combinePlan.isEmpty()) {
            name = name + " - Combine";
        }
        if (!op.reducePlan.isEmpty()) {
            name = name + " - Reduce";
        }
        if (op.getRequestedParallelism() != -1) {
            name = name + " Parallelism: " + op.getRequestedParallelism();
        }
        name = name + ", Global Sort: " + op.isGlobalSort();
        return name;
    }

    @Override
    protected Collection<InnerPlan> getNestedPlans(MapReduceOper op) {
        LinkedList<InnerPlan> plans = new LinkedList<InnerPlan>();
        plans.add(new InnerPlan(op.mapPlan, op.combinePlan, op.reducePlan));
        return plans;
    }

    @Override
    protected String[] getAttributes(MapReduceOper op) {
        String[] attributes = new String[]{"label=\"" + this.getName(op) + "\"", "style=\"filled\"", "fillcolor=\"#EEEEEE\""};
        return attributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InnerPrinter
    extends DotPlanDumper<InnerOperator, InnerPlan, PhysicalOperator, PhysicalPlan> {
        public InnerPrinter(InnerPlan plan, PrintStream ps, Set<Operator> subgraphs, Set<Operator> multiInputSubgraphs, Set<Operator> multiOutputSubgraphs) {
            super(plan, ps, true, subgraphs, multiInputSubgraphs, multiOutputSubgraphs);
        }

        @Override
        protected String[] getAttributes(InnerOperator op) {
            String[] attributes = new String[]{"label=\"" + super.getName(op) + "\"", "style=\"filled\"", "fillcolor=\"white\""};
            return attributes;
        }

        @Override
        protected Collection<PhysicalPlan> getNestedPlans(InnerOperator op) {
            LinkedList<PhysicalPlan> l = new LinkedList<PhysicalPlan>();
            l.add(op.getPlan());
            return l;
        }

        protected DotPOPrinter makeDumper(PhysicalPlan plan, PrintStream ps) {
            DotPOPrinter printer = new DotPOPrinter(plan, ps, true, (Set<Operator>)this.mSubgraphs, (Set<Operator>)this.mMultiInputSubgraphs, (Set<Operator>)this.mMultiOutputSubgraphs);
            printer.setVerbose(DotMRPrinter.this.isVerboseNesting);
            return printer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InnerPlan
    extends OperatorPlan<InnerOperator> {
        private static final long serialVersionUID = 1L;

        public InnerPlan(PhysicalPlan mapPlan, PhysicalPlan combinePlan, PhysicalPlan reducePlan) {
            try {
                InnerOperator map = new InnerOperator(mapPlan, "Map");
                this.add(map);
                if (!combinePlan.isEmpty()) {
                    InnerOperator combine = new InnerOperator(combinePlan, "Combine");
                    InnerOperator reduce = new InnerOperator(reducePlan, "Reduce");
                    this.add(combine);
                    this.connect(map, combine);
                    this.add(reduce);
                    this.connect(combine, reduce);
                } else if (!reducePlan.isEmpty()) {
                    InnerOperator reduce = new InnerOperator(reducePlan, "Reduce");
                    this.add(reduce);
                    this.connect(map, reduce);
                }
            }
            catch (PlanException e) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InnerOperator
    extends Operator<PlanVisitor> {
        private static final long serialVersionUID = 1L;
        String name;
        PhysicalPlan plan;
        int code;

        public InnerOperator(PhysicalPlan plan, String name) {
            super(new OperatorKey());
            this.name = name;
            this.plan = plan;
            this.code = counter++;
        }

        @Override
        public void visit(PlanVisitor v) {
        }

        @Override
        public boolean supportsMultipleInputs() {
            return false;
        }

        @Override
        public boolean supportsMultipleOutputs() {
            return false;
        }

        @Override
        public String name() {
            return this.name;
        }

        public PhysicalPlan getPlan() {
            return this.plan;
        }

        @Override
        public int hashCode() {
            return this.code;
        }
    }
}

