package azkaban.jmx;

import java.util.ArrayList;
import java.util.List;

import org.joda.time.DateTime;

import azkaban.trigger.TriggerManager;
import azkaban.trigger.TriggerManagerAdapter;
import azkaban.trigger.TriggerManagerAdapter.TriggerJMX;

public class JmxTriggerManager implements JmxTriggerManagerMBean {
	private TriggerJMX jmxStats;

	public JmxTriggerManager(TriggerManagerAdapter manager) {
		this.jmxStats = manager.getJMX();
	}

	@Override
	public String getLastRunnerThreadCheckTime() {
		return new DateTime(jmxStats.getLastRunnerThreadCheckTime()).toString();
	}

	@Override
	public boolean isRunnerThreadActive() {
		return jmxStats.isRunnerThreadActive();
	}

	@Override
	public String getPrimaryTriggerHostPort() {
		return jmxStats.getPrimaryServerHost();
	}

//	@Override
//	public List<String> getAllTriggerHostPorts() {
//		return new ArrayList<String>(manager.getAllActiveTriggerServerHosts());
//	}

	@Override
	public int getNumTriggers() {
		return jmxStats.getNumTriggers();
	}

	@Override
	public String getTriggerSources() {
		return jmxStats.getTriggerSources();
	}

	@Override
	public String getTriggerIds() {
		return jmxStats.getTriggerIds();
	}

	@Override
	public long getScannerIdleTime() {
		return jmxStats.getScannerIdleTime();
	}
	
	
	
}
