/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import com.sun.mail.smtp.SMTPTransport;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EmailMessage {
    private static String protocol = "smtp";
    private List<String> _toAddress = new ArrayList<String>();
    private String _mailHost;
    private String _mailUser;
    private String _mailPassword;
    private String _subject;
    private String _fromAddress;
    private String _mimeType = "text/plain";
    private StringBuffer _body = new StringBuffer();
    private ArrayList<BodyPart> _attachments = new ArrayList();

    public EmailMessage() {
        this("localhost", "", "");
    }

    public EmailMessage(String host, String user, String password) {
        this._mailUser = user;
        this._mailHost = host;
        this._mailPassword = password;
    }

    public EmailMessage setMailHost(String host) {
        this._mailHost = host;
        return this;
    }

    public EmailMessage setMailUser(String user) {
        this._mailUser = user;
        return this;
    }

    public EmailMessage setMailPassword(String password) {
        this._mailPassword = password;
        return this;
    }

    public EmailMessage addAllToAddress(Collection<? extends String> addresses) {
        this._toAddress.addAll(addresses);
        return this;
    }

    public EmailMessage addToAddress(String address) {
        this._toAddress.add(address);
        return this;
    }

    public EmailMessage setSubject(String subject) {
        this._subject = subject;
        return this;
    }

    public EmailMessage setFromAddress(String fromAddress) {
        this._fromAddress = fromAddress;
        return this;
    }

    public EmailMessage addAttachment(File file) throws MessagingException {
        return this.addAttachment(file.getName(), file);
    }

    public EmailMessage addAttachment(String attachmentName, File file) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource fileDataSource = new FileDataSource(file);
        attachmentPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
        attachmentPart.setFileName(attachmentName);
        this._attachments.add((BodyPart)attachmentPart);
        return this;
    }

    public EmailMessage addAttachment(String attachmentName, InputStream stream) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart(stream);
        attachmentPart.setFileName(attachmentName);
        this._attachments.add((BodyPart)attachmentPart);
        return this;
    }

    private void checkSettings() {
        if (this._mailHost == null) {
            throw new RuntimeException("Mail host not set.");
        }
        if (this._fromAddress == null || this._fromAddress.length() == 0) {
            throw new RuntimeException("From address not set.");
        }
        if (this._subject == null) {
            throw new RuntimeException("Subject cannot be null");
        }
        if (this._toAddress.size() == 0) {
            throw new RuntimeException("T");
        }
    }

    public void sendEmail() throws MessagingException {
        this.checkSettings();
        Properties props = new Properties();
        props.put("mail." + protocol + ".host", this._mailHost);
        props.put("mail." + protocol + ".auth", "true");
        props.put("mail.user", this._mailUser);
        props.put("mail.password", this._mailPassword);
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage message = new MimeMessage(session);
        InternetAddress from = new InternetAddress(this._fromAddress, false);
        message.setFrom((Address)from);
        for (String toAddr : this._toAddress) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddr, false));
        }
        message.setSubject(this._subject);
        message.setSentDate(new Date());
        if (this._attachments.size() > 0) {
            MimeMultipart multipart = new MimeMultipart("related");
            for (BodyPart part : this._attachments) {
                multipart.addBodyPart(part);
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)this._body.toString(), this._mimeType);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
        } else {
            message.setContent((Object)this._body.toString(), this._mimeType);
        }
        SMTPTransport t = (SMTPTransport)session.getTransport(protocol);
        t.connect(this._mailHost, this._mailUser, this._mailPassword);
        t.sendMessage((Message)message, message.getRecipients(Message.RecipientType.TO));
        t.close();
    }

    public void setBody(String body) {
        this.setBody(body, this._mimeType);
    }

    public void setBody(String body, String mimeType) {
        this._body = new StringBuffer(body);
        this._mimeType = mimeType;
    }

    public EmailMessage setMimeType(String mimeType) {
        this._mimeType = mimeType;
        return this;
    }

    public EmailMessage println(Object str) {
        this._body.append(str);
        return this;
    }
}

