/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.swapper;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.cluster.Cluster;
import voldemort.store.readonly.swapper.AdminStoreSwapper;
import voldemort.store.readonly.swapper.HttpStoreSwapper;
import voldemort.utils.CmdUtils;
import voldemort.utils.VoldemortIOUtils;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreSwapper {
    private static final Logger logger = Logger.getLogger(StoreSwapper.class);
    protected final Cluster cluster;
    protected final ExecutorService executor;

    public StoreSwapper(Cluster cluster, ExecutorService executor) {
        this.cluster = cluster;
        this.executor = executor;
    }

    public void swapStoreData(String storeName, String basePath, long pushVersion) {
        List<String> fetched = this.invokeFetch(storeName, basePath, pushVersion);
        this.invokeSwap(storeName, fetched);
    }

    public abstract List<String> invokeFetch(String var1, String var2, long var3);

    public abstract void invokeSwap(String var1, List<String> var2);

    public abstract void invokeRollback(String var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print usage information");
        parser.accepts("cluster", "[REQUIRED] the voldemort cluster.xml file ").withRequiredArg().describedAs("cluster.xml");
        parser.accepts("name", "[REQUIRED] the name of the store to swap").withRequiredArg().describedAs("store-name");
        parser.accepts("servlet-path", "the path for the read-only management servlet").withRequiredArg().describedAs("path");
        parser.accepts("file", "[REQUIRED] uri of a directory containing the new store files").withRequiredArg().describedAs("uri");
        parser.accepts("timeout", "http timeout for the fetch in ms").withRequiredArg().describedAs("timeout ms").ofType(Integer.class);
        parser.accepts("rollback", "Rollback store to older version");
        parser.accepts("admin", "Use admin services. Default = false");
        parser.accepts("push-version", "[REQUIRED] Version of push to fetch / rollback-to").withRequiredArg().ofType(Long.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if (!((missing = CmdUtils.missing(options, "cluster", "name", "file", "push-version")).size() <= 0 || ((Object)missing).equals(ImmutableSet.of((Object)"file")) && options.has("rollback"))) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String clusterXml = (String)options.valueOf("cluster");
        String storeName = (String)options.valueOf("name");
        String mgmtPath = CmdUtils.valueOf(options, "servlet-path", "read-only/mgmt");
        String filePath = (String)options.valueOf("file");
        int timeoutMs = CmdUtils.valueOf(options, "timeout", Integer.valueOf(10800000));
        boolean useAdminServices = options.has("admin");
        boolean rollbackStore = options.has("rollback");
        Long pushVersion = (Long)options.valueOf("push-version");
        String clusterStr = FileUtils.readFileToString((File)new File(clusterXml));
        Cluster cluster = new ClusterMapper().readCluster(new StringReader(clusterStr));
        ExecutorService executor = Executors.newFixedThreadPool(cluster.getNumberOfNodes());
        StoreSwapper swapper = null;
        AdminClient adminClient = null;
        DefaultHttpClient httpClient = null;
        if (useAdminServices) {
            adminClient = new AdminClient(cluster, new AdminClientConfig());
            swapper = new AdminStoreSwapper(cluster, executor, adminClient, timeoutMs);
        } else {
            int numConnections = cluster.getNumberOfNodes() + 3;
            ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager();
            httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
            HttpParams clientParams = httpClient.getParams();
            connectionManager.setMaxTotal(numConnections);
            connectionManager.setDefaultMaxPerRoute(numConnections);
            HttpConnectionParams.setSoTimeout((HttpParams)clientParams, (int)timeoutMs);
            swapper = new HttpStoreSwapper(cluster, executor, (HttpClient)httpClient, mgmtPath);
        }
        try {
            long start = System.currentTimeMillis();
            if (rollbackStore) {
                ((StoreSwapper)swapper).invokeRollback(storeName, pushVersion);
            } else {
                swapper.swapStoreData(storeName, filePath, pushVersion);
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("Succeeded on all nodes in " + (end - start) / 1000L + " seconds."));
            Object var23_23 = null;
            if (useAdminServices && adminClient != null) {
                adminClient.stop();
            }
            executor.shutdownNow();
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            if (useAdminServices && adminClient != null) {
                adminClient.stop();
            }
            executor.shutdownNow();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
            VoldemortIOUtils.closeQuietly((HttpClient)httpClient);
            throw throwable;
        }
        executor.awaitTermination(1L, TimeUnit.SECONDS);
        VoldemortIOUtils.closeQuietly((HttpClient)httpClient);
        System.exit(0);
    }
}

