/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Date;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.Utils;

public class Slop {
    private static final byte[] spacer = new byte[]{0};
    private final ByteArray key;
    private final byte[] value;
    private final byte[] transforms;
    private final String storeName;
    private final int nodeId;
    private final Date arrived;
    private final Operation operation;

    public Slop(String storeName, Operation operation, byte[] key, byte[] value, int nodeId, Date arrived) {
        this(storeName, operation, new ByteArray(key), value, null, nodeId, arrived);
    }

    public Slop(String storeName, Operation operation, ByteArray key, byte[] value, byte[] transforms, int nodeId, Date arrived) {
        this.operation = Utils.notNull(operation);
        this.storeName = Utils.notNull(storeName);
        this.key = Utils.notNull(key);
        this.value = value;
        this.transforms = transforms;
        this.nodeId = nodeId;
        this.arrived = Utils.notNull(arrived);
    }

    public ByteArray getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getTransforms() {
        return this.transforms;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public Date getArrived() {
        return this.arrived;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public ByteArray makeKey() {
        byte[] storeName = ByteUtils.getBytes(this.getStoreName(), "UTF-8");
        byte[] opCode = new byte[]{this.operation.getOpCode()};
        byte[] nodeIdBytes = new byte[4];
        ByteUtils.writeInt(nodeIdBytes, this.nodeId, 0);
        return new ByteArray(ByteUtils.cat(opCode, spacer, storeName, spacer, nodeIdBytes, spacer, this.key.get()));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(Slop.class)) {
            return false;
        }
        Slop slop = (Slop)obj;
        return this.operation == slop.getOperation() && Objects.equal((Object)this.storeName, (Object)this.getStoreName()) && this.key.equals(slop.getKey()) && Utils.deepEquals(this.value, slop.getValue()) && Utils.deepEquals(this.transforms, slop.getTransforms()) && this.nodeId == slop.getNodeId() && Objects.equal((Object)this.arrived, (Object)slop.getArrived());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.storeName, this.operation, this.nodeId, this.arrived}) + this.key.hashCode() + Arrays.hashCode(this.value) + Arrays.hashCode(this.transforms);
    }

    public String toString() {
        return "Slop(storeName = " + this.storeName + ", operation = " + (Object)((Object)this.operation) + ", key = " + this.key + ", value = " + Arrays.toString(this.value) + ", nodeId = " + this.nodeId + ", arrived = " + this.arrived + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        PUT(0),
        DELETE(1);

        private final byte opCode;

        private Operation(byte opCode) {
            this.opCode = opCode;
        }

        public byte getOpCode() {
            return this.opCode;
        }
    }
}

