/*
 * Decompiled with CFR 0.152.
 */
package azkaban.jobtype;

import azkaban.jobExecutor.JavaProcessJob;
import azkaban.jobExecutor.Job;
import azkaban.jobExecutor.NoopJob;
import azkaban.jobExecutor.ProcessJob;
import azkaban.jobExecutor.PythonJob;
import azkaban.jobExecutor.RubyJob;
import azkaban.jobExecutor.ScriptJob;
import azkaban.jobExecutor.utils.JobExecutionException;
import azkaban.jobtype.JobTypeManagerException;
import azkaban.jobtype.JobTypePluginSet;
import azkaban.utils.Props;
import azkaban.utils.PropsUtils;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JobTypeManager {
    private final String jobTypePluginDir;
    private final ClassLoader parentLoader;
    public static final String DEFAULT_JOBTYPEPLUGINDIR = "plugins/jobtypes";
    private static final String JOBTYPECONFFILE = "plugin.properties";
    private static final String JOBTYPESYSCONFFILE = "private.properties";
    private static final String COMMONCONFFILE = "common.properties";
    private static final String COMMONSYSCONFFILE = "commonprivate.properties";
    private static final Logger logger = Logger.getLogger(JobTypeManager.class);
    private JobTypePluginSet pluginSet;

    public JobTypeManager(String jobtypePluginDir, ClassLoader parentClassLoader) {
        this.jobTypePluginDir = jobtypePluginDir;
        this.parentLoader = parentClassLoader;
        this.loadPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlugins() throws JobTypeManagerException {
        File pluginDir;
        JobTypePluginSet plugins = new JobTypePluginSet();
        this.loadDefaultTypes(plugins);
        if (this.jobTypePluginDir != null && (pluginDir = new File(this.jobTypePluginDir)).exists()) {
            logger.info((Object)("Job type plugin directory set. Loading extra job types from " + pluginDir));
            try {
                this.loadPluginJobTypes(plugins);
            }
            catch (Exception e) {
                logger.info((Object)("Plugin jobtypes failed to load. " + e.getCause()));
                throw new JobTypeManagerException((Throwable)e);
            }
        }
        JobTypeManager jobTypeManager = this;
        synchronized (jobTypeManager) {
            this.pluginSet = plugins;
        }
    }

    private void loadDefaultTypes(JobTypePluginSet plugins) throws JobTypeManagerException {
        logger.info((Object)"Loading plugin default job types");
        plugins.addPluginClass("command", ProcessJob.class);
        plugins.addPluginClass("javaprocess", JavaProcessJob.class);
        plugins.addPluginClass("noop", NoopJob.class);
        plugins.addPluginClass("python", PythonJob.class);
        plugins.addPluginClass("ruby", RubyJob.class);
        plugins.addPluginClass("script", ScriptJob.class);
    }

    private void loadPluginJobTypes(JobTypePluginSet plugins) throws JobTypeManagerException {
        File jobPluginsDir = new File(this.jobTypePluginDir);
        if (!jobPluginsDir.exists()) {
            logger.error((Object)("Job type plugin dir " + this.jobTypePluginDir + " doesn't exist. Will not load any external plugins."));
            return;
        }
        if (!jobPluginsDir.isDirectory()) {
            throw new JobTypeManagerException("Job type plugin dir " + this.jobTypePluginDir + " is not a directory!");
        }
        if (!jobPluginsDir.canRead()) {
            throw new JobTypeManagerException("Job type plugin dir " + this.jobTypePluginDir + " is not readable!");
        }
        Props commonPluginJobProps = null;
        File commonJobPropsFile = new File(jobPluginsDir, COMMONCONFFILE);
        if (commonJobPropsFile.exists()) {
            logger.info((Object)("Common plugin job props file " + commonJobPropsFile + " found. Attempt to load."));
            try {
                commonPluginJobProps = new Props(null, commonJobPropsFile);
            }
            catch (IOException e) {
                throw new JobTypeManagerException("Failed to load common plugin job properties" + e.getCause());
            }
        } else {
            logger.info((Object)("Common plugin job props file " + commonJobPropsFile + " not found. Using empty props."));
            commonPluginJobProps = new Props();
        }
        Props commonPluginLoadProps = null;
        File commonLoadPropsFile = new File(jobPluginsDir, COMMONSYSCONFFILE);
        if (commonLoadPropsFile.exists()) {
            logger.info((Object)("Common plugin load props file " + commonLoadPropsFile + " found. Attempt to load."));
            try {
                commonPluginLoadProps = new Props(null, commonLoadPropsFile);
            }
            catch (IOException e) {
                throw new JobTypeManagerException("Failed to load common plugin loader properties" + e.getCause());
            }
        } else {
            logger.info((Object)("Common plugin load props file " + commonLoadPropsFile + " not found. Using empty props."));
            commonPluginLoadProps = new Props();
        }
        plugins.setCommonPluginJobProps(commonPluginJobProps);
        plugins.setCommonPluginLoadProps(commonPluginLoadProps);
        File[] fileArray = jobPluginsDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory() && dir.canRead()) {
                try {
                    this.loadJob(dir, plugins);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to load jobtype " + dir.getName() + e.getMessage()));
                    throw new JobTypeManagerException((Throwable)e);
                }
            }
            ++n2;
        }
    }

    private void loadJob(File pluginDir, JobTypePluginSet plugins) throws JobTypeManagerException {
        String jobTypeName = pluginDir.getName();
        logger.info((Object)("Loading plugin " + jobTypeName));
        Props pluginJobProps = null;
        Props pluginLoadProps = null;
        File pluginJobPropsFile = new File(pluginDir, JOBTYPECONFFILE);
        File pluginLoadPropsFile = new File(pluginDir, JOBTYPESYSCONFFILE);
        if (!pluginLoadPropsFile.exists()) {
            logger.info((Object)("Plugin load props file " + pluginLoadPropsFile + " not found."));
            return;
        }
        try {
            Props commonPluginJobProps = plugins.getCommonPluginJobProps();
            Props commonPluginLoadProps = plugins.getCommonPluginLoadProps();
            pluginJobProps = pluginJobPropsFile.exists() ? new Props(commonPluginJobProps, pluginJobPropsFile) : new Props(commonPluginJobProps);
            pluginLoadProps = new Props(commonPluginLoadProps, pluginLoadPropsFile);
            pluginLoadProps = PropsUtils.resolveProps((Props)pluginLoadProps);
        }
        catch (Exception e) {
            throw new JobTypeManagerException("Failed to get jobtype properties" + e.getMessage());
        }
        pluginLoadProps.put("plugin.dir", pluginDir.getAbsolutePath());
        plugins.addPluginLoadProps(jobTypeName, pluginLoadProps);
        if (pluginJobProps != null) {
            plugins.addPluginJobProps(jobTypeName, pluginJobProps);
        }
        ClassLoader jobTypeLoader = this.loadJobTypeClassLoader(pluginDir, jobTypeName, plugins);
        String jobtypeClass = pluginLoadProps.get((Object)"jobtype.class");
        Class<?> clazz = null;
        try {
            clazz = jobTypeLoader.loadClass(jobtypeClass);
            plugins.addPluginClass(jobTypeName, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new JobTypeManagerException((Throwable)e);
        }
        logger.info((Object)("Verifying job plugin " + jobTypeName));
        try {
            Props fakeSysProps = new Props(pluginLoadProps);
            Props fakeJobProps = new Props(pluginJobProps);
            Job job = (Job)Utils.callConstructor(clazz, (Object[])new Object[]{"dummy", fakeSysProps, fakeJobProps, logger});
        }
        catch (Exception e) {
            logger.info((Object)("Jobtype " + jobTypeName + " failed test!"), (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
        catch (Throwable t) {
            logger.info((Object)("Jobtype " + jobTypeName + " failed test!"), t);
            throw new JobExecutionException(t);
        }
        logger.info((Object)("Loaded jobtype " + jobTypeName + " " + jobtypeClass));
    }

    private ClassLoader loadJobTypeClassLoader(File pluginDir, String jobTypeName, JobTypePluginSet plugins) {
        ArrayList<Object> resources = new ArrayList<Object>();
        Props pluginLoadProps = plugins.getPluginLoaderProps(jobTypeName);
        try {
            List jobtypeLibDirs;
            logger.info((Object)("Adding global resources for " + jobTypeName));
            List typeGlobalClassPath = pluginLoadProps.getStringList("jobtype.global.classpath", null, ",");
            if (typeGlobalClassPath != null) {
                for (String jar : typeGlobalClassPath) {
                    URL cpItem = new File(jar).toURI().toURL();
                    if (resources.contains(cpItem)) continue;
                    logger.info((Object)("adding to classpath " + cpItem));
                    resources.add(cpItem);
                }
            }
            logger.info((Object)"Adding type resources.");
            List typeClassPath = pluginLoadProps.getStringList("jobtype.classpath", null, ",");
            if (typeClassPath != null) {
                for (String jar : typeClassPath) {
                    URL cpItem = new File(jar).toURI().toURL();
                    if (resources.contains(cpItem)) continue;
                    logger.info((Object)("adding to classpath " + cpItem));
                    resources.add(cpItem);
                }
            }
            if ((jobtypeLibDirs = pluginLoadProps.getStringList("jobtype.lib.dir", null, ",")) != null) {
                for (String libDir : jobtypeLibDirs) {
                    File[] fileArray = new File(libDir).listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        if (f.getName().endsWith(".jar")) {
                            resources.add(f.toURI().toURL());
                            logger.info((Object)("adding to classpath " + f.toURI().toURL()));
                        }
                        ++n2;
                    }
                }
            }
            logger.info((Object)"Adding type override resources.");
            File[] fileArray = pluginDir.listFiles();
            int n = fileArray.length;
            int n3 = 0;
            while (n3 < n) {
                File f = fileArray[n3];
                if (f.getName().endsWith(".jar")) {
                    resources.add(f.toURI().toURL());
                    logger.info((Object)("adding to classpath " + f.toURI().toURL()));
                }
                ++n3;
            }
        }
        catch (MalformedURLException e) {
            throw new JobTypeManagerException((Throwable)e);
        }
        URLClassLoader jobTypeLoader = new URLClassLoader(resources.toArray(new URL[resources.size()]), this.parentLoader);
        return jobTypeLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job buildJobExecutor(String jobId, Props jobProps, Logger logger) throws JobTypeManagerException {
        JobTypePluginSet pluginSet = null;
        JobTypeManager jobTypeManager = this;
        synchronized (jobTypeManager) {
            pluginSet = this.pluginSet;
        }
        Job job = null;
        try {
            String jobType = jobProps.getString("type");
            if (jobType == null || jobType.length() == 0) {
                throw new JobExecutionException(String.format("The 'type' parameter for job[%s] is null or empty", jobProps, logger));
            }
            logger.info((Object)("Building " + jobType + " job executor. "));
            Class executorClass = pluginSet.getPluginClass(jobType);
            if (executorClass == null) {
                throw new JobExecutionException(String.format("Job type '" + jobType + "' is unrecognized. Could not construct job[%s] of type[%s].", jobProps, jobType));
            }
            Props pluginLoadProps = pluginSet.getPluginLoaderProps(jobType);
            Props pluginJobProps = pluginSet.getPluginJobProps(jobType);
            if (pluginJobProps != null) {
                for (String k : pluginJobProps.getKeySet()) {
                    if (jobProps.containsKey((Object)k)) continue;
                    jobProps.put(k, pluginJobProps.get((Object)k));
                }
            }
            jobProps = PropsUtils.resolveProps((Props)jobProps);
            pluginLoadProps = pluginLoadProps != null ? PropsUtils.resolveProps((Props)pluginLoadProps) : new Props();
            job = (Job)Utils.callConstructor((Class)executorClass, (Object[])new Object[]{jobId, pluginLoadProps, jobProps, logger});
        }
        catch (Exception e) {
            logger.error((Object)("Failed to build job executor for job " + jobId + e.getMessage()));
            throw new JobTypeManagerException("Failed to build job executor for job " + jobId, (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)("Failed to build job executor for job " + jobId + t.getMessage()), t);
            throw new JobTypeManagerException("Failed to build job executor for job " + jobId, t);
        }
        return job;
    }

    public void registerJobType(String jobTypeName, Class<? extends Job> jobTypeClass) {
        this.pluginSet.addPluginClass(jobTypeName, jobTypeClass);
    }
}

