/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2;

import org.apache.hadoop.metrics2.MetricsVisitor;

public abstract class Metric {
    public static final String NO_DESCRIPTION = "<<no description>>";
    private final String name;
    private final String description;

    public Metric(String name) {
        this.name = name;
        this.description = NO_DESCRIPTION;
    }

    public Metric(String name, String desc) {
        this.name = name;
        this.description = desc;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public abstract Number value();

    public abstract void visit(MetricsVisitor var1);

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metric other = (Metric)obj;
        if (!this.name.equals(other.name())) {
            return false;
        }
        if (!this.description.equals(other.description())) {
            return false;
        }
        return this.value().equals(other.value());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Metric{name='" + this.name + "' description='" + this.description + "' value=" + this.value() + '}';
    }
}

