/*
 * Decompiled with CFR 0.152.
 */
package azkaban.execapp.event;

import azkaban.execapp.event.BlockingStatus;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.Status;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public abstract class FlowWatcher {
    private static final Logger logger = Logger.getLogger(FlowWatcher.class);
    private int execId;
    private ExecutableFlow flow;
    private Map<String, BlockingStatus> map = new ConcurrentHashMap<String, BlockingStatus>();
    private boolean cancelWatch = false;

    public FlowWatcher(int execId) {
        this.execId = execId;
    }

    public void setFlow(ExecutableFlow flow) {
        this.flow = flow;
    }

    protected synchronized void handleJobFinished(String jobId, Status status) {
        if (this.cancelWatch) {
            return;
        }
        BlockingStatus block = this.map.get(jobId);
        if (block != null) {
            block.changeStatus(status);
        }
    }

    public int getExecId() {
        return this.execId;
    }

    public synchronized BlockingStatus getBlockingStatus(String jobId) {
        if (this.cancelWatch) {
            return null;
        }
        ExecutableNode node = this.flow.getExecutableNode(jobId);
        if (node == null) {
            return null;
        }
        BlockingStatus blockingStatus = this.map.get(jobId);
        if (blockingStatus == null) {
            blockingStatus = new BlockingStatus(this.execId, jobId, node.getStatus());
            this.map.put(jobId, blockingStatus);
        }
        return blockingStatus;
    }

    public Status peekStatus(String jobId) {
        ExecutableNode node = this.flow.getExecutableNode(jobId);
        if (node != null) {
            return node.getStatus();
        }
        return null;
    }

    public synchronized void failAllWatches() {
        logger.info((Object)("Failing all watches on " + this.execId));
        this.cancelWatch = true;
        for (BlockingStatus status : this.map.values()) {
            status.changeStatus(Status.KILLED);
            status.unblock();
        }
        logger.info((Object)("Successfully failed all watches on " + this.execId));
    }

    public boolean isWatchCancelled() {
        return this.cancelWatch;
    }

    public abstract void stopWatcher();
}

