/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.EmailMessage;
import azkaban.utils.Props;
import java.util.Collection;

public class AbstractMailer {
    private String clientHostname;
    private int clientPort;
    private boolean usesSSL;
    private String mailHost;
    private String mailUser;
    private String mailPassword;
    private String mailSender;
    private String azkabanName;
    private String referenceURL;

    public AbstractMailer(Props props) {
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        this.mailHost = props.getString("mail.host", "localhost");
        this.mailUser = props.getString("mail.user", "");
        this.mailPassword = props.getString("mail.password", "");
        this.mailSender = props.getString("mail.sender", "");
        this.clientHostname = props.get("server.hostname");
        this.clientPort = props.getInt("server.port");
        this.usesSSL = props.getBoolean("server.useSSL");
        this.referenceURL = this.usesSSL ? "https://" + this.clientHostname + (this.clientPort == 443 ? "/" : ":" + this.clientPort + "/") : "http://" + this.clientHostname + (this.clientPort == 80 ? "/" : ":" + this.clientPort + "/");
    }

    public String getReferenceURL() {
        return this.referenceURL;
    }

    protected EmailMessage createEmailMessage(String subject, String mimetype, Collection<String> emailList) {
        EmailMessage message = new EmailMessage(this.mailHost, this.mailUser, this.mailPassword);
        message.setFromAddress(this.mailSender);
        message.addAllToAddress(emailList);
        message.setMimeType(mimetype);
        message.setSubject(subject);
        return message;
    }

    public EmailMessage prepareEmailMessage(String subject, String mimetype, Collection<String> emailList) {
        return this.createEmailMessage(subject, mimetype, emailList);
    }

    public String getAzkabanName() {
        return this.azkabanName;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public String getMailUser() {
        return this.mailUser;
    }

    public String getMailPassword() {
        return this.mailPassword;
    }

    public String getMailSender() {
        return this.mailSender;
    }
}

