/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.data;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.io.WritableComparable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.InternalMap;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Stable
public class DataType {
    public static final byte UNKNOWN = 0;
    public static final byte NULL = 1;
    public static final byte BOOLEAN = 5;
    public static final byte BYTE = 6;
    public static final byte INTEGER = 10;
    public static final byte LONG = 15;
    public static final byte FLOAT = 20;
    public static final byte DOUBLE = 25;
    public static final byte BYTEARRAY = 50;
    public static final byte CHARARRAY = 55;
    public static final byte BIGCHARARRAY = 60;
    public static final byte MAP = 100;
    public static final byte TUPLE = 110;
    public static final byte BAG = 120;
    public static final byte GENERIC_WRITABLECOMPARABLE = 123;
    public static final byte INTERNALMAP = 127;
    public static final byte ERROR = -1;

    public static byte findType(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof DataByteArray) {
            return 50;
        }
        if (o instanceof String) {
            return 55;
        }
        if (o instanceof Tuple) {
            return 110;
        }
        if (o instanceof DataBag) {
            return 120;
        }
        if (o instanceof Integer) {
            return 10;
        }
        if (o instanceof Long) {
            return 15;
        }
        if (o instanceof InternalMap) {
            return 127;
        }
        if (o instanceof Map) {
            return 100;
        }
        if (o instanceof Float) {
            return 20;
        }
        if (o instanceof Double) {
            return 25;
        }
        if (o instanceof Boolean) {
            return 5;
        }
        if (o instanceof Byte) {
            return 6;
        }
        if (o instanceof WritableComparable) {
            return 123;
        }
        return -1;
    }

    public static byte findType(Type t) {
        if (t == null) {
            return 1;
        }
        if (t == DataByteArray.class) {
            return 50;
        }
        if (t == String.class) {
            return 55;
        }
        if (t == Integer.class) {
            return 10;
        }
        if (t == Long.class) {
            return 15;
        }
        if (t == Float.class) {
            return 20;
        }
        if (t == Double.class) {
            return 25;
        }
        if (t == Boolean.class) {
            return 5;
        }
        if (t == Byte.class) {
            return 6;
        }
        if (t == InternalMap.class) {
            return 127;
        }
        if (t instanceof Class) {
            return DataType.extractTypeFromClass(t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType impl = (ParameterizedType)t;
            Class c = (Class)impl.getRawType();
            return DataType.extractTypeFromClass(c);
        }
        return -1;
    }

    private static byte extractTypeFromClass(Type t) {
        Class c = (Class)t;
        Class<?>[] ioeInterfaces = c.getInterfaces();
        Class<?>[] interfaces = null;
        if (c.isInterface()) {
            interfaces = new Class[ioeInterfaces.length + 1];
            interfaces[0] = c;
            for (int i = 1; i < interfaces.length; ++i) {
                interfaces[i] = ioeInterfaces[i - 1];
            }
        } else {
            interfaces = ioeInterfaces;
        }
        boolean matchedWritableComparable = false;
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].getName().equals("org.apache.pig.data.Tuple")) {
                return 110;
            }
            if (interfaces[i].getName().equals("org.apache.pig.data.DataBag")) {
                return 120;
            }
            if (interfaces[i].getName().equals("java.util.Map")) {
                return 100;
            }
            if (!interfaces[i].getName().equals("org.apache.hadoop.io.WritableComparable")) continue;
            matchedWritableComparable = true;
        }
        if (matchedWritableComparable) {
            return 123;
        }
        return -1;
    }

    public static int numTypes() {
        byte[] types = DataType.genAllTypes();
        return types.length;
    }

    public static byte[] genAllTypes() {
        byte[] types = new byte[]{120, 60, 5, 6, 50, 55, 25, 20, 123, 10, 127, 15, 100, 110};
        return types;
    }

    private static String[] genAllTypeNames() {
        String[] names = new String[]{"BAG", "BIGCHARARRAY", "BOOLEAN", "BYTE", "BYTEARRAY", "CHARARRAY", "DOUBLE", "FLOAT", "GENERIC_WRITABLECOMPARABLE", "INTEGER", "INTERNALMAP", "LONG", "MAP", "TUPLE"};
        return names;
    }

    public static Map<Byte, String> genTypeToNameMap() {
        byte[] types = DataType.genAllTypes();
        String[] names = DataType.genAllTypeNames();
        HashMap<Byte, String> ret = new HashMap<Byte, String>();
        for (int i = 0; i < types.length; ++i) {
            ret.put(types[i], names[i]);
        }
        return ret;
    }

    public static Map<String, Byte> genNameToTypeMap() {
        byte[] types = DataType.genAllTypes();
        String[] names = DataType.genAllTypeNames();
        HashMap<String, Byte> ret = new HashMap<String, Byte>();
        for (int i = 0; i < types.length; ++i) {
            ret.put(names[i], types[i]);
        }
        return ret;
    }

    public static String findTypeName(Object o) {
        return DataType.findTypeName(DataType.findType(o));
    }

    public static String findTypeName(byte dt) {
        switch (dt) {
            case 1: {
                return "NULL";
            }
            case 5: {
                return "boolean";
            }
            case 6: {
                return "byte";
            }
            case 10: {
                return "int";
            }
            case 15: {
                return "long";
            }
            case 20: {
                return "float";
            }
            case 25: {
                return "double";
            }
            case 50: {
                return "bytearray";
            }
            case 60: {
                return "bigchararray";
            }
            case 55: {
                return "chararray";
            }
            case 100: {
                return "map";
            }
            case 127: {
                return "internalmap";
            }
            case 110: {
                return "tuple";
            }
            case 120: {
                return "bag";
            }
            case 123: {
                return "generic_writablecomparable";
            }
        }
        return "Unknown";
    }

    public static boolean isComplex(byte dataType) {
        return dataType == 120 || dataType == 110 || dataType == 100 || dataType == 127;
    }

    public static boolean isComplex(Object o) {
        return DataType.isComplex(DataType.findType(o));
    }

    public static boolean isAtomic(byte dataType) {
        return dataType == 50 || dataType == 55 || dataType == 60 || dataType == 10 || dataType == 15 || dataType == 20 || dataType == 25 || dataType == 5 || dataType == 6 || dataType == 123;
    }

    public static boolean isAtomic(Object o) {
        return DataType.isAtomic(DataType.findType(o));
    }

    public static boolean isSchemaType(Object o) {
        return DataType.isSchemaType(DataType.findType(o));
    }

    public static boolean isSchemaType(byte dataType) {
        return dataType == 120 || dataType == 110 || dataType == 100;
    }

    public static int compare(Object o1, Object o2) {
        byte dt1 = DataType.findType(o1);
        byte dt2 = DataType.findType(o2);
        return DataType.compare(o1, o2, dt1, dt2);
    }

    public static int compare(Object o1, Object o2, byte dt1, byte dt2) {
        if (dt1 == dt2) {
            switch (dt1) {
                case 1: {
                    return 0;
                }
                case 5: {
                    return ((Boolean)o1).compareTo((Boolean)o2);
                }
                case 6: {
                    return ((Byte)o1).compareTo((Byte)o2);
                }
                case 10: {
                    return ((Integer)o1).compareTo((Integer)o2);
                }
                case 15: {
                    return ((Long)o1).compareTo((Long)o2);
                }
                case 20: {
                    return ((Float)o1).compareTo((Float)o2);
                }
                case 25: {
                    return ((Double)o1).compareTo((Double)o2);
                }
                case 50: {
                    return ((DataByteArray)o1).compareTo(o2);
                }
                case 55: {
                    return ((String)o1).compareTo((String)o2);
                }
                case 100: {
                    Map m1 = (Map)o1;
                    Map m2 = (Map)o2;
                    int sz1 = m1.size();
                    int sz2 = m2.size();
                    if (sz1 < sz2) {
                        return -1;
                    }
                    if (sz1 > sz2) {
                        return 1;
                    }
                    TreeMap tm1 = new TreeMap(m1);
                    TreeMap tm2 = new TreeMap(m2);
                    Iterator i1 = tm1.entrySet().iterator();
                    Iterator i2 = tm2.entrySet().iterator();
                    while (i1.hasNext()) {
                        Map.Entry entry1 = i1.next();
                        Map.Entry entry2 = i2.next();
                        int c = ((String)entry1.getKey()).compareTo((String)entry2.getKey());
                        if (c != 0) {
                            return c;
                        }
                        c = DataType.compare(entry1.getValue(), entry2.getValue());
                        if (c == 0) continue;
                        return c;
                    }
                    return 0;
                }
                case 123: {
                    return ((Comparable)o1).compareTo(o2);
                }
                case 127: {
                    return -1;
                }
                case 110: {
                    return ((Tuple)o1).compareTo(o2);
                }
                case 120: {
                    return ((DataBag)o1).compareTo(o2);
                }
            }
            throw new RuntimeException("Unkown type " + dt1 + " in compare");
        }
        if (dt1 < dt2) {
            return -1;
        }
        return 1;
    }

    public static byte[] toBytes(Object o) throws ExecException {
        return DataType.toBytes(o, DataType.findType(o));
    }

    public static byte[] toBytes(Object o, byte type) throws ExecException {
        switch (type) {
            case 5: {
                byte[] byArray;
                if (((Boolean)o).booleanValue()) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 1;
                } else {
                    byte[] byArray3 = new byte[1];
                    byArray = byArray3;
                    byArray3[0] = 0;
                }
                return byArray;
            }
            case 6: {
                return new byte[]{(Byte)o};
            }
            case 10: 
            case 15: 
            case 20: 
            case 25: {
                return ((Number)o).toString().getBytes();
            }
            case 55: {
                return ((String)o).getBytes();
            }
            case 100: {
                return DataType.mapToString((Map)o).getBytes();
            }
            case 110: {
                return ((Tuple)o).toString().getBytes();
            }
            case 50: {
                return ((DataByteArray)o).get();
            }
            case 120: {
                return ((DataBag)o).toString().getBytes();
            }
            case 1: {
                return null;
            }
        }
        int errCode = 1071;
        String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a ByteArray";
        throw new ExecException(msg, errCode, 2);
    }

    public static Integer toInteger(Object o, byte type) throws ExecException {
        try {
            switch (type) {
                case 5: {
                    if (((Boolean)o).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case 6: {
                    return ((Byte)o).intValue();
                }
                case 10: {
                    return (Integer)o;
                }
                case 15: {
                    return ((Long)o).intValue();
                }
                case 20: {
                    return ((Float)o).intValue();
                }
                case 25: {
                    return ((Double)o).intValue();
                }
                case 50: {
                    return Integer.valueOf(((DataByteArray)o).toString());
                }
                case 55: {
                    return Integer.valueOf((String)o);
                }
                case 1: {
                    return null;
                }
            }
            int errCode = 1071;
            String msg = "Cannot convert a " + DataType.findTypeName(o) + " to an Integer";
            throw new ExecException(msg, errCode, 2);
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (NumberFormatException nfe) {
            int errCode = 1074;
            String msg = "Problem with formatting. Could not convert " + o + " to Integer.";
            throw new ExecException(msg, errCode, 2, nfe);
        }
        catch (Exception e) {
            int errCode = 2054;
            String msg = "Internal error. Could not convert " + o + " to Integer.";
            throw new ExecException(msg, errCode, 4);
        }
    }

    public static Integer toInteger(Object o) throws ExecException {
        return DataType.toInteger(o, DataType.findType(o));
    }

    public static Long toLong(Object o, byte type) throws ExecException {
        try {
            switch (type) {
                case 5: {
                    if (((Boolean)o).booleanValue()) {
                        return 1L;
                    }
                    return 0L;
                }
                case 6: {
                    return ((Byte)o).longValue();
                }
                case 10: {
                    return ((Integer)o).longValue();
                }
                case 15: {
                    return (Long)o;
                }
                case 20: {
                    return ((Float)o).longValue();
                }
                case 25: {
                    return ((Double)o).longValue();
                }
                case 50: {
                    return Long.valueOf(((DataByteArray)o).toString());
                }
                case 55: {
                    return Long.valueOf((String)o);
                }
                case 1: {
                    return null;
                }
            }
            int errCode = 1071;
            String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a Long";
            throw new ExecException(msg, errCode, 2);
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (NumberFormatException nfe) {
            int errCode = 1074;
            String msg = "Problem with formatting. Could not convert " + o + " to Long.";
            throw new ExecException(msg, errCode, 2, nfe);
        }
        catch (Exception e) {
            int errCode = 2054;
            String msg = "Internal error. Could not convert " + o + " to Long.";
            throw new ExecException(msg, errCode, 4);
        }
    }

    public static Long toLong(Object o) throws ExecException {
        return DataType.toLong(o, DataType.findType(o));
    }

    public static Float toFloat(Object o, byte type) throws ExecException {
        try {
            switch (type) {
                case 10: {
                    return new Float(((Integer)o).floatValue());
                }
                case 15: {
                    return new Float(((Long)o).floatValue());
                }
                case 20: {
                    return (Float)o;
                }
                case 25: {
                    return new Float(((Double)o).floatValue());
                }
                case 50: {
                    return Float.valueOf(((DataByteArray)o).toString());
                }
                case 55: {
                    return Float.valueOf((String)o);
                }
                case 1: {
                    return null;
                }
            }
            int errCode = 1071;
            String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a Float";
            throw new ExecException(msg, errCode, 2);
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (NumberFormatException nfe) {
            int errCode = 1074;
            String msg = "Problem with formatting. Could not convert " + o + " to Float.";
            throw new ExecException(msg, errCode, 2, nfe);
        }
        catch (Exception e) {
            int errCode = 2054;
            String msg = "Internal error. Could not convert " + o + " to Float.";
            throw new ExecException(msg, errCode, 4);
        }
    }

    public static Float toFloat(Object o) throws ExecException {
        return DataType.toFloat(o, DataType.findType(o));
    }

    public static Double toDouble(Object o, byte type) throws ExecException {
        try {
            switch (type) {
                case 10: {
                    return new Double(((Integer)o).doubleValue());
                }
                case 15: {
                    return new Double(((Long)o).doubleValue());
                }
                case 20: {
                    return new Double(((Float)o).doubleValue());
                }
                case 25: {
                    return (Double)o;
                }
                case 50: {
                    return Double.valueOf(((DataByteArray)o).toString());
                }
                case 55: {
                    return Double.valueOf((String)o);
                }
                case 1: {
                    return null;
                }
            }
            int errCode = 1071;
            String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a Double";
            throw new ExecException(msg, errCode, 2);
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (NumberFormatException nfe) {
            int errCode = 1074;
            String msg = "Problem with formatting. Could not convert " + o + " to Double.";
            throw new ExecException(msg, errCode, 2, nfe);
        }
        catch (Exception e) {
            int errCode = 2054;
            String msg = "Internal error. Could not convert " + o + " to Double.";
            throw new ExecException(msg, errCode, 4);
        }
    }

    public static Double toDouble(Object o) throws ExecException {
        return DataType.toDouble(o, DataType.findType(o));
    }

    public static String toString(Object o, byte type) throws ExecException {
        try {
            switch (type) {
                case 10: {
                    return ((Integer)o).toString();
                }
                case 15: {
                    return ((Long)o).toString();
                }
                case 20: {
                    return ((Float)o).toString();
                }
                case 25: {
                    return ((Double)o).toString();
                }
                case 50: {
                    return ((DataByteArray)o).toString();
                }
                case 55: {
                    return (String)o;
                }
                case 1: {
                    return null;
                }
                case 5: {
                    return ((Boolean)o).toString();
                }
                case 6: {
                    return ((Byte)o).toString();
                }
            }
            int errCode = 1071;
            String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a String";
            throw new ExecException(msg, errCode, 2);
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (ExecException ee) {
            throw ee;
        }
        catch (Exception e) {
            int errCode = 2054;
            String msg = "Internal error. Could not convert " + o + " to String.";
            throw new ExecException(msg, errCode, 4);
        }
    }

    public static String toString(Object o) throws ExecException {
        return DataType.toString(o, DataType.findType(o));
    }

    public static Map<String, Object> toMap(Object o) throws ExecException {
        if (o == null) {
            return null;
        }
        if (o instanceof Map && !(o instanceof InternalMap)) {
            try {
                return (Map)o;
            }
            catch (Exception e) {
                int errCode = 2054;
                String msg = "Internal error. Could not convert " + o + " to Map.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        int errCode = 1071;
        String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a Map";
        throw new ExecException(msg, errCode, 2);
    }

    public static Tuple toTuple(Object o) throws ExecException {
        if (o == null) {
            return null;
        }
        if (o instanceof Tuple) {
            try {
                return (Tuple)o;
            }
            catch (Exception e) {
                int errCode = 2054;
                String msg = "Internal error. Could not convert " + o + " to Tuple.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        int errCode = 1071;
        String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a Tuple";
        throw new ExecException(msg, errCode, 2);
    }

    public static DataBag toBag(Object o) throws ExecException {
        if (o == null) {
            return null;
        }
        if (o instanceof DataBag) {
            try {
                return (DataBag)o;
            }
            catch (Exception e) {
                int errCode = 2054;
                String msg = "Internal error. Could not convert " + o + " to Bag.";
                throw new ExecException(msg, errCode, 4);
            }
        }
        int errCode = 1071;
        String msg = "Cannot convert a " + DataType.findTypeName(o) + " to a DataBag";
        throw new ExecException(msg, errCode, 2);
    }

    public static void spillTupleContents(Tuple t, String label) {
        System.out.print("Tuple " + label + " ");
        Iterator<Object> i = t.getAll().iterator();
        int j = 0;
        while (i.hasNext()) {
            System.out.print(j + ":" + i.next().getClass().getName() + " ");
            ++j;
        }
        System.out.println(t.toString());
    }

    public static boolean isNumberType(byte t) {
        switch (t) {
            case 10: {
                return true;
            }
            case 15: {
                return true;
            }
            case 20: {
                return true;
            }
            case 25: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUsableType(byte t) {
        switch (t) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case -1: {
                return false;
            }
        }
        return true;
    }

    public static boolean castable(byte castType, byte inputType) {
        if (!DataType.isUsableType(castType) || !DataType.isUsableType(inputType)) {
            return false;
        }
        if (castType == inputType) {
            return true;
        }
        if (DataType.isNumberType(castType) && DataType.isNumberType(inputType)) {
            return true;
        }
        if (inputType == 50) {
            return true;
        }
        return DataType.isNumberType(inputType) && castType == 55 || DataType.isNumberType(castType) && inputType == 55;
    }

    public static byte mergeType(byte type1, byte type2) {
        if (!DataType.isUsableType(type1) || !DataType.isUsableType(type2)) {
            return -1;
        }
        if (type1 == type2) {
            return type1;
        }
        if (DataType.isNumberType(type1) && DataType.isNumberType(type2)) {
            return type1 > type2 ? type1 : type2;
        }
        if (type1 == 50) {
            return type2;
        }
        if (type2 == 50) {
            return type1;
        }
        return -1;
    }

    public static String mapToString(Map<String, Object> m) {
        boolean hasNext = false;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry<String, Object> e : m.entrySet()) {
            if (hasNext) {
                sb.append(",");
            } else {
                hasNext = true;
            }
            sb.append(e.getKey());
            sb.append("#");
            Object val = e.getValue();
            if (val == null) continue;
            sb.append(val.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static boolean equalByteArrays(byte[] lhs, byte[] rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    private static Schema.FieldSchema determineFieldSchema(byte dataType, Iterator fieldIter, long fieldNum, Class klass) throws ExecException, FrontendException, SchemaMergeException {
        switch (dataType) {
            case 1: {
                return new Schema.FieldSchema(null, 50);
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 50: 
            case 55: 
            case 100: {
                return new Schema.FieldSchema(null, dataType);
            }
            case 110: {
                Schema schema = null;
                if (fieldNum != 0L) {
                    schema = new Schema();
                    int i = 0;
                    while ((long)i < fieldNum) {
                        schema.add(DataType.determineFieldSchema(klass.cast(fieldIter.next())));
                        ++i;
                    }
                }
                return new Schema.FieldSchema(null, schema, 110);
            }
            case 120: {
                Schema schema = null;
                Schema bagSchema = null;
                if (fieldNum != 0L) {
                    ArrayList<Schema> schemas = new ArrayList<Schema>();
                    while (fieldIter.hasNext()) {
                        schemas.add(DataType.determineFieldSchema(klass.cast(fieldIter.next())).schema);
                    }
                    schema = (Schema)schemas.get(0);
                    if (null == schema) {
                        Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, null, 110);
                        bagSchema = new Schema(tupleFs);
                        bagSchema.setTwoLevelAccessRequired(true);
                        return new Schema.FieldSchema(null, bagSchema, 120);
                    }
                    int schemaSize = schema.size();
                    for (int i = 1; i < schemas.size(); ++i) {
                        Schema currSchema = (Schema)schemas.get(i);
                        if (null == currSchema || currSchema.size() != schemaSize) {
                            Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, null, 110);
                            bagSchema = new Schema(tupleFs);
                            bagSchema.setTwoLevelAccessRequired(true);
                            return new Schema.FieldSchema(null, bagSchema, 120);
                        }
                        schema = Schema.mergeSchema(schema, currSchema, false, false, false);
                    }
                    Schema.FieldSchema tupleFs = new Schema.FieldSchema(null, schema, 110);
                    bagSchema = new Schema(tupleFs);
                    bagSchema.setTwoLevelAccessRequired(true);
                }
                return new Schema.FieldSchema(null, bagSchema, 120);
            }
        }
        int errCode = 1073;
        String msg = "Cannot determine field schema";
        throw new ExecException(msg, errCode, 2);
    }

    public static Schema.FieldSchema determineFieldSchema(ResourceSchema.ResourceFieldSchema rcFieldSchema) throws ExecException, FrontendException, SchemaMergeException {
        byte dt = rcFieldSchema.getType();
        Iterator<ResourceSchema.ResourceFieldSchema> fieldIter = null;
        long fieldNum = 0L;
        if (dt == 110 || dt == 120) {
            fieldIter = Arrays.asList(rcFieldSchema.getSchema().getFields()).iterator();
            fieldNum = rcFieldSchema.getSchema().getFields().length;
        }
        return DataType.determineFieldSchema(dt, fieldIter, fieldNum, ResourceSchema.ResourceFieldSchema.class);
    }

    public static Schema.FieldSchema determineFieldSchema(Object o) throws ExecException, FrontendException, SchemaMergeException {
        byte dt = DataType.findType(o);
        Iterator<Object> fieldIter = null;
        long fieldNum = 0L;
        if (dt == 110) {
            fieldIter = ((Tuple)o).getAll().iterator();
            fieldNum = ((Tuple)o).size();
        } else if (dt == 120) {
            fieldNum = ((DataBag)o).size();
            fieldIter = ((DataBag)o).iterator();
        }
        return DataType.determineFieldSchema(dt, fieldIter, fieldNum, Object.class);
    }
}

