/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class EqualToExpr
extends BinaryComparisonOperator {
    private static final long serialVersionUID = 1L;
    private final transient Log log = LogFactory.getLog(this.getClass());

    public EqualToExpr(OperatorKey k) {
        this(k, -1);
    }

    public EqualToExpr(OperatorKey k, int rp) {
        super(k, rp);
        this.resultType = (byte)5;
    }

    public String name() {
        return "Equal To[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitEqualTo(this);
    }

    public Result getNext(Boolean bool) throws ExecException {
        switch (this.operandType) {
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 50: 
            case 55: 
            case 100: 
            case 110: {
                Object dummy = EqualToExpr.getDummy(this.operandType);
                Result r = this.accumChild(null, dummy, this.operandType);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummy, this.operandType);
                Result right = this.rhs.getNext(dummy, this.operandType);
                return this.doComparison(left, right);
            }
        }
        int errCode = 2067;
        String msg = this.getClass().getSimpleName() + " does not know how to " + "handle type: " + DataType.findTypeName(this.operandType);
        throw new ExecException(msg, errCode, 4);
    }

    private Result doComparison(Result left, Result right) throws ExecException {
        if (this.trueRef == null) {
            this.initializeRefs();
        }
        if (left.returnStatus != 0) {
            return left;
        }
        if (right.returnStatus != 0) {
            return right;
        }
        if (left.result == null || right.result == null) {
            left.result = null;
            left.returnStatus = 1;
            return left;
        }
        if (left.result instanceof Comparable && right.result instanceof Comparable) {
            left.result = ((Comparable)left.result).compareTo(right.result) == 0 ? this.trueRef : this.falseRef;
        } else if (left.result instanceof HashMap && right.result instanceof HashMap) {
            HashMap leftMap = (HashMap)left.result;
            HashMap rightMap = (HashMap)right.result;
            left.result = leftMap.equals(rightMap) ? this.trueRef : this.falseRef;
        } else {
            throw new ExecException("The left side and right side has the different types");
        }
        this.illustratorMarkup(null, left.result, (Boolean)left.result != false ? 0 : 1);
        return left;
    }

    public EqualToExpr clone() throws CloneNotSupportedException {
        EqualToExpr clone = new EqualToExpr(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

