/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.meta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.meta.FieldTypeInfo;
import org.apache.hadoop.record.meta.MapTypeID;
import org.apache.hadoop.record.meta.RecordTypeInfo;
import org.apache.hadoop.record.meta.TypeID;
import org.apache.hadoop.record.meta.VectorTypeID;

public class StructTypeID
extends TypeID {
    private ArrayList<FieldTypeInfo> typeInfos = new ArrayList();

    StructTypeID() {
        super((byte)10);
    }

    public StructTypeID(RecordTypeInfo rti) {
        super((byte)10);
        this.typeInfos.addAll(rti.getFieldTypeInfos());
    }

    void add(FieldTypeInfo ti) {
        this.typeInfos.add(ti);
    }

    public Collection<FieldTypeInfo> getFieldTypeInfos() {
        return this.typeInfos;
    }

    StructTypeID findStruct(String name) {
        for (FieldTypeInfo ti : this.typeInfos) {
            if (0 != ti.getFieldID().compareTo(name) || ti.getTypeID().getTypeVal() != 10) continue;
            return (StructTypeID)ti.getTypeID();
        }
        return null;
    }

    @Override
    void write(RecordOutput rout, String tag) throws IOException {
        rout.writeByte(this.typeVal, tag);
        this.writeRest(rout, tag);
    }

    void writeRest(RecordOutput rout, String tag) throws IOException {
        rout.writeInt(this.typeInfos.size(), tag);
        for (FieldTypeInfo ti : this.typeInfos) {
            ti.write(rout, tag);
        }
    }

    void read(RecordInput rin, String tag) throws IOException {
        int numElems = rin.readInt(tag);
        for (int i = 0; i < numElems; ++i) {
            this.typeInfos.add(this.genericReadTypeInfo(rin, tag));
        }
    }

    private FieldTypeInfo genericReadTypeInfo(RecordInput rin, String tag) throws IOException {
        String fieldName = rin.readString(tag);
        TypeID id = this.genericReadTypeID(rin, tag);
        return new FieldTypeInfo(fieldName, id);
    }

    private TypeID genericReadTypeID(RecordInput rin, String tag) throws IOException {
        byte typeVal = rin.readByte(tag);
        switch (typeVal) {
            case 1: {
                return TypeID.BoolTypeID;
            }
            case 2: {
                return TypeID.BufferTypeID;
            }
            case 3: {
                return TypeID.ByteTypeID;
            }
            case 4: {
                return TypeID.DoubleTypeID;
            }
            case 5: {
                return TypeID.FloatTypeID;
            }
            case 6: {
                return TypeID.IntTypeID;
            }
            case 7: {
                return TypeID.LongTypeID;
            }
            case 8: {
                TypeID tIDKey = this.genericReadTypeID(rin, tag);
                TypeID tIDValue = this.genericReadTypeID(rin, tag);
                return new MapTypeID(tIDKey, tIDValue);
            }
            case 9: {
                return TypeID.StringTypeID;
            }
            case 10: {
                StructTypeID stID = new StructTypeID();
                int numElems = rin.readInt(tag);
                for (int i = 0; i < numElems; ++i) {
                    stID.add(this.genericReadTypeInfo(rin, tag));
                }
                return stID;
            }
            case 11: {
                TypeID tID = this.genericReadTypeID(rin, tag);
                return new VectorTypeID(tID);
            }
        }
        throw new IOException("Unknown type read");
    }
}

