/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.expression;

import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.parser.SourceLocation;

public class BinCondExpression
extends LogicalExpression {
    public BinCondExpression(OperatorPlan plan, LogicalExpression condition, LogicalExpression lhs, LogicalExpression rhs) {
        super("BinCond", plan);
        plan.add(this);
        plan.connect(this, condition);
        plan.connect(this, lhs);
        plan.connect(this, rhs);
    }

    public LogicalExpression getCondition() throws FrontendException {
        return (LogicalExpression)this.plan.getSuccessors(this).get(0);
    }

    public LogicalExpression getLhs() throws FrontendException {
        return (LogicalExpression)this.plan.getSuccessors(this).get(1);
    }

    public LogicalExpression getRhs() throws FrontendException {
        return (LogicalExpression)this.plan.getSuccessors(this).get(2);
    }

    public void accept(PlanVisitor v) throws FrontendException {
        if (!(v instanceof LogicalExpressionVisitor)) {
            throw new FrontendException("Expected LogicalExpressionVisitor", 2222);
        }
        ((LogicalExpressionVisitor)v).visit(this);
    }

    public boolean isEqual(Operator other) throws FrontendException {
        if (other != null && other instanceof BinCondExpression) {
            BinCondExpression ao = (BinCondExpression)other;
            return ao.getCondition().isEqual(this.getCondition()) && ao.getLhs().isEqual(this.getLhs()) && ao.getRhs().isEqual(this.getRhs());
        }
        return false;
    }

    public LogicalSchema.LogicalFieldSchema getFieldSchema() throws FrontendException {
        if (this.fieldSchema != null) {
            return this.fieldSchema;
        }
        LogicalSchema.LogicalFieldSchema argFs = this.getLhs().getFieldSchema();
        this.fieldSchema = argFs.deepCopy();
        this.fieldSchema.resetUid();
        this.uidOnlyFieldSchema = this.fieldSchema.mergeUid(this.uidOnlyFieldSchema);
        return this.fieldSchema;
    }

    public LogicalExpression deepCopy(LogicalExpressionPlan lgExpPlan) throws FrontendException {
        BinCondExpression copy = new BinCondExpression(lgExpPlan, this.getCondition().deepCopy(lgExpPlan), this.getLhs().deepCopy(lgExpPlan), this.getRhs().deepCopy(lgExpPlan));
        copy.setLocation(new SourceLocation(this.location));
        return copy;
    }
}

