/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.client.rebalance.OrderedClusterTransition;
import voldemort.client.rebalance.RebalanceClientConfig;
import voldemort.client.rebalance.RebalanceClusterPlan;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.client.rebalance.task.DonorBasedRebalanceTask;
import voldemort.client.rebalance.task.RebalanceTask;
import voldemort.client.rebalance.task.StealerBasedRebalanceTask;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.server.rebalance.VoldemortRebalancingException;
import voldemort.store.StoreDefinition;
import voldemort.utils.RebalanceUtils;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalanceController {
    private static final Logger logger = Logger.getLogger(RebalanceController.class);
    private static final DecimalFormat decimalFormatter = new DecimalFormat("#.##");
    private final AdminClient adminClient;
    private final RebalanceClientConfig rebalanceConfig;

    public RebalanceController(String bootstrapUrl, RebalanceClientConfig rebalanceConfig) {
        this.adminClient = new AdminClient(bootstrapUrl, (AdminClientConfig)rebalanceConfig);
        this.rebalanceConfig = rebalanceConfig;
    }

    public RebalanceController(Cluster cluster, RebalanceClientConfig config) {
        this.adminClient = new AdminClient(cluster, (AdminClientConfig)config);
        this.rebalanceConfig = config;
    }

    public void rebalance(Cluster targetCluster) {
        Versioned<Cluster> currentVersionedCluster = RebalanceUtils.getLatestCluster(RebalanceUtils.getNodeIds(Lists.newArrayList(this.adminClient.getAdminClientCluster().getNodes())), this.adminClient);
        Cluster currentCluster = currentVersionedCluster.getValue();
        this.rebalance(currentCluster, targetCluster);
    }

    public void rebalance(Cluster currentCluster, Cluster targetCluster) {
        this.adminClient.setAdminClientCluster(targetCluster);
        List<StoreDefinition> storeDefs = RebalanceUtils.getStoreDefinition(targetCluster, this.adminClient);
        this.rebalance(currentCluster, targetCluster, storeDefs);
    }

    public void rebalance(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefs) {
        logger.info((Object)("Current cluster : " + currentCluster));
        logger.info((Object)("Final target cluster : " + targetCluster));
        logger.info((Object)("Show plan : " + this.rebalanceConfig.isShowPlanEnabled()));
        logger.info((Object)("Delete post rebalancing : " + this.rebalanceConfig.isDeleteAfterRebalancingEnabled()));
        logger.info((Object)("Stealer based rebalancing : " + this.rebalanceConfig.isStealerBasedRebalancing()));
        logger.info((Object)("Primary partition batch size : " + this.rebalanceConfig.getPrimaryPartitionBatchSize()));
        storeDefs = RebalanceUtils.validateRebalanceStore(storeDefs);
        Cluster newCurrentCluster = RebalanceUtils.getClusterWithNewNodes(currentCluster, targetCluster);
        this.adminClient.setAdminClientCluster(newCurrentCluster);
        if (!this.rebalanceConfig.isShowPlanEnabled()) {
            RebalanceUtils.validateClusterState(newCurrentCluster, this.adminClient);
            RebalanceUtils.validateReadOnlyStores(newCurrentCluster, storeDefs, this.adminClient);
            logger.info((Object)("Propagating new cluster " + newCurrentCluster + " to all nodes"));
            RebalanceUtils.propagateCluster(this.adminClient, newCurrentCluster);
        }
        this.rebalancePerClusterTransition(newCurrentCluster, targetCluster, storeDefs);
    }

    private void rebalancePerClusterTransition(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefs) {
        TreeMultimap stealerToStolenPrimaryPartitions = TreeMultimap.create();
        TreeMultimap stealerToStolenPrimaryPartitionsClone = TreeMultimap.create();
        int numTasks = 0;
        int numCrossZoneMoves = 0;
        int numPrimaryPartitionMoves = 0;
        ClusterMapper mapper = new ClusterMapper();
        for (Node stealerNode : targetCluster.getNodes()) {
            List<Integer> stolenPrimaryPartitions = RebalanceUtils.getStolenPrimaryPartitions(currentCluster, targetCluster, stealerNode.getId());
            if (stolenPrimaryPartitions.size() <= 0) continue;
            numPrimaryPartitionMoves += stolenPrimaryPartitions.size();
            stealerToStolenPrimaryPartitions.putAll((Object)stealerNode.getId(), stolenPrimaryPartitions);
            stealerToStolenPrimaryPartitionsClone.putAll((Object)stealerNode.getId(), stolenPrimaryPartitions);
        }
        Cluster currentClusterClone = mapper.readCluster(new StringReader(mapper.writeCluster(currentCluster)));
        while (!stealerToStolenPrimaryPartitionsClone.isEmpty()) {
            Cluster startCluster = mapper.readCluster(new StringReader(mapper.writeCluster(currentClusterClone)));
            int batchCompleted = 0;
            ArrayList partitionsMoved = Lists.newArrayList();
            for (Map.Entry stealerToPartition : stealerToStolenPrimaryPartitionsClone.entries()) {
                partitionsMoved.add(stealerToPartition);
                currentClusterClone = RebalanceUtils.createUpdatedCluster(currentClusterClone, (Integer)stealerToPartition.getKey(), Lists.newArrayList((Object[])new Integer[]{(Integer)stealerToPartition.getValue()}));
                if (++batchCompleted != this.rebalanceConfig.getPrimaryPartitionBatchSize()) continue;
                break;
            }
            for (Map.Entry entry : partitionsMoved) {
                stealerToStolenPrimaryPartitionsClone.remove(entry.getKey(), entry.getValue());
            }
            RebalanceClusterPlan rebalanceClusterPlan = new RebalanceClusterPlan(startCluster, currentClusterClone, storeDefs, this.rebalanceConfig.isDeleteAfterRebalancingEnabled(), this.rebalanceConfig.isStealerBasedRebalancing());
            numCrossZoneMoves += RebalanceUtils.getCrossZoneMoves(currentClusterClone, rebalanceClusterPlan);
            numTasks += RebalanceUtils.getTotalMoves(rebalanceClusterPlan);
        }
        logger.info((Object)("Total number of primary partition moves : " + numPrimaryPartitionMoves));
        logger.info((Object)("Total number of cross zone moves : " + numCrossZoneMoves));
        logger.info((Object)("Total number of tasks : " + numTasks));
        int tasksCompleted = 0;
        int primaryPartitionId = 0;
        double totalTimeMs = 0.0;
        while (!stealerToStolenPrimaryPartitions.isEmpty()) {
            Cluster transitionCluster = mapper.readCluster(new StringReader(mapper.writeCluster(currentCluster)));
            int primaryPartitionBatchSize = 0;
            ArrayList partitionsMoved = Lists.newArrayList();
            for (Map.Entry stealerToPartition : stealerToStolenPrimaryPartitions.entries()) {
                partitionsMoved.add(stealerToPartition);
                transitionCluster = RebalanceUtils.createUpdatedCluster(transitionCluster, (Integer)stealerToPartition.getKey(), Lists.newArrayList((Object[])new Integer[]{(Integer)stealerToPartition.getValue()}));
                if (++primaryPartitionBatchSize != this.rebalanceConfig.getPrimaryPartitionBatchSize()) continue;
                break;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("Partitions being moved : ");
            for (Map.Entry entry : partitionsMoved) {
                buffer.append("[ partition " + entry.getValue() + " to stealer node " + entry.getKey() + " ], ");
                stealerToStolenPrimaryPartitions.remove(entry.getKey(), entry.getValue());
            }
            RebalanceClusterPlan rebalanceClusterPlan = new RebalanceClusterPlan(currentCluster, transitionCluster, storeDefs, this.rebalanceConfig.isDeleteAfterRebalancingEnabled(), this.rebalanceConfig.isStealerBasedRebalancing());
            OrderedClusterTransition orderedClusterTransition = new OrderedClusterTransition(currentCluster, transitionCluster, storeDefs, rebalanceClusterPlan);
            logger.info((Object)"----------------");
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, buffer.toString());
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, orderedClusterTransition.toString());
            if (this.rebalanceConfig.hasOutputDirectory()) {
                RebalanceUtils.dumpCluster(currentCluster, transitionCluster, new File(this.rebalanceConfig.getOutputDirectory()));
            }
            long startTimeMs = System.currentTimeMillis();
            this.rebalancePerPartitionTransition(orderedClusterTransition);
            currentCluster = transitionCluster;
            double estimatedTimeMs = (totalTimeMs += (double)(System.currentTimeMillis() - startTimeMs)) / (double)(tasksCompleted += RebalanceUtils.getTotalMoves(rebalanceClusterPlan)) * (double)(numTasks - tasksCompleted);
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, "Completed tasks - " + tasksCompleted + ". Percent done - " + decimalFormatter.format((double)tasksCompleted * 100.0 / (double)numTasks));
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, "Primary partitions left to move - " + (numPrimaryPartitionMoves - (primaryPartitionId += primaryPartitionBatchSize)));
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, "Estimated time left for completion - " + estimatedTimeMs + " ms ( " + estimatedTimeMs / 3600000.0 + " hours )");
        }
    }

    private void rebalancePerPartitionTransition(OrderedClusterTransition orderedClusterTransition) {
        try {
            List<RebalancePartitionsInfo> rebalancePartitionsInfoList = orderedClusterTransition.getOrderedRebalancePartitionsInfoList();
            if (rebalancePartitionsInfoList.isEmpty()) {
                RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, "Skipping rebalance task id " + orderedClusterTransition.getId() + " since it is empty");
                return;
            }
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, "Starting rebalance task id " + orderedClusterTransition.getId());
            List<RebalancePartitionsInfo> rebalancePartitionPlanList = rebalancePartitionsInfoList;
            List<StoreDefinition> readOnlyStoreDefs = RebalanceUtils.filterStores(orderedClusterTransition.getStoreDefs(), true);
            List<StoreDefinition> readWriteStoreDefs = RebalanceUtils.filterStores(orderedClusterTransition.getStoreDefs(), false);
            boolean hasReadOnlyStores = readOnlyStoreDefs != null && readOnlyStoreDefs.size() > 0;
            boolean hasReadWriteStores = readWriteStoreDefs != null && readWriteStoreDefs.size() > 0;
            boolean finishedReadOnlyPhase = false;
            List<RebalancePartitionsInfo> filteredRebalancePartitionPlanList = RebalanceUtils.filterPartitionPlanWithStores(rebalancePartitionPlanList, readOnlyStoreDefs);
            this.rebalanceStateChange(orderedClusterTransition.getId(), orderedClusterTransition.getCurrentCluster(), orderedClusterTransition.getTargetCluster(), filteredRebalancePartitionPlanList, hasReadOnlyStores, hasReadWriteStores, finishedReadOnlyPhase);
            if (hasReadOnlyStores) {
                this.rebalancePerTaskTransition(orderedClusterTransition.getId(), orderedClusterTransition.getCurrentCluster(), filteredRebalancePartitionPlanList, hasReadOnlyStores, hasReadWriteStores, finishedReadOnlyPhase);
            }
            finishedReadOnlyPhase = true;
            filteredRebalancePartitionPlanList = RebalanceUtils.filterPartitionPlanWithStores(rebalancePartitionPlanList, readWriteStoreDefs);
            this.rebalanceStateChange(orderedClusterTransition.getId(), orderedClusterTransition.getCurrentCluster(), orderedClusterTransition.getTargetCluster(), filteredRebalancePartitionPlanList, hasReadOnlyStores, hasReadWriteStores, finishedReadOnlyPhase);
            if (hasReadWriteStores) {
                this.rebalancePerTaskTransition(orderedClusterTransition.getId(), orderedClusterTransition.getCurrentCluster(), filteredRebalancePartitionPlanList, hasReadOnlyStores, hasReadWriteStores, finishedReadOnlyPhase);
            }
            RebalanceUtils.printLog(orderedClusterTransition.getId(), logger, "Successfully terminated rebalance task id " + orderedClusterTransition.getId());
        }
        catch (Exception e) {
            RebalanceUtils.printErrorLog(orderedClusterTransition.getId(), logger, "Error in rebalance task id " + orderedClusterTransition.getId() + " - " + e.getMessage(), e);
            throw new VoldemortException("Rebalance failed on rebalance task id " + orderedClusterTransition.getId(), e);
        }
    }

    private void rebalanceStateChange(int taskId, Cluster currentCluster, Cluster transitionCluster, List<RebalancePartitionsInfo> rebalancePartitionPlanList, boolean hasReadOnlyStores, boolean hasReadWriteStores, boolean finishedReadOnlyStores) {
        try {
            if (!hasReadOnlyStores && !hasReadWriteStores) {
                throw new VoldemortException("Cannot get this state since it means there are no stores");
            }
            if (!hasReadOnlyStores && hasReadWriteStores && !finishedReadOnlyStores) {
                RebalanceUtils.printLog(taskId, logger, "Ignoring state change since there are no read-only stores");
            } else if (!hasReadOnlyStores && hasReadWriteStores && finishedReadOnlyStores) {
                RebalanceUtils.printLog(taskId, logger, "Cluster metadata change + rebalance state change");
                if (!this.rebalanceConfig.isShowPlanEnabled()) {
                    this.adminClient.rebalanceStateChange(currentCluster, transitionCluster, rebalancePartitionPlanList, false, true, true, true, true);
                }
            } else if (hasReadOnlyStores && !finishedReadOnlyStores) {
                RebalanceUtils.printLog(taskId, logger, "Rebalance state change");
                if (!this.rebalanceConfig.isShowPlanEnabled()) {
                    this.adminClient.rebalanceStateChange(currentCluster, transitionCluster, rebalancePartitionPlanList, false, false, true, true, true);
                }
            } else if (hasReadOnlyStores && !hasReadWriteStores && finishedReadOnlyStores) {
                RebalanceUtils.printLog(taskId, logger, "Swap + Cluster metadata change");
                if (!this.rebalanceConfig.isShowPlanEnabled()) {
                    this.adminClient.rebalanceStateChange(currentCluster, transitionCluster, rebalancePartitionPlanList, true, true, false, true, true);
                }
            } else {
                RebalanceUtils.printLog(taskId, logger, "Swap + Cluster metadata change + rebalance state change");
                if (!this.rebalanceConfig.isShowPlanEnabled()) {
                    this.adminClient.rebalanceStateChange(currentCluster, transitionCluster, rebalancePartitionPlanList, true, true, true, true, true);
                }
            }
        }
        catch (VoldemortRebalancingException e) {
            RebalanceUtils.printErrorLog(taskId, logger, "Failure while changing rebalancing state", e);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rebalancePerTaskTransition(int taskId, Cluster currentCluster, List<RebalancePartitionsInfo> rebalancePartitionPlanList, boolean hasReadOnlyStores, boolean hasReadWriteStores, boolean finishedReadOnlyStores) {
        RebalanceUtils.printLog(taskId, logger, "Submitting rebalance tasks ");
        if (this.rebalanceConfig.isShowPlanEnabled()) {
            return;
        }
        ExecutorService service = RebalanceUtils.createExecutors(this.rebalanceConfig.getMaxParallelRebalancing());
        ArrayList failedTasks = Lists.newArrayList();
        ArrayList incompleteTasks = Lists.newArrayList();
        Semaphore[] donorPermits = new Semaphore[currentCluster.getNumberOfNodes()];
        for (Node node : currentCluster.getNodes()) {
            donorPermits[node.getId()] = new Semaphore(1);
        }
        try {
            try {
                List<RebalanceTask> allTasks = this.executeTasks(taskId, service, rebalancePartitionPlanList, donorPermits);
                RebalanceUtils.printLog(taskId, logger, "All rebalance tasks were submitted ( shutting down in " + this.rebalanceConfig.getRebalancingClientTimeoutSeconds() + " sec )");
                RebalanceUtils.executorShutDown(service, this.rebalanceConfig.getRebalancingClientTimeoutSeconds());
                RebalanceUtils.printLog(taskId, logger, "Finished waiting for executors");
                ArrayList failures = Lists.newArrayList();
                for (RebalanceTask task : allTasks) {
                    if (task.hasException()) {
                        failedTasks.add(task);
                        failures.add(task.getError());
                        continue;
                    }
                    if (task.isComplete()) continue;
                    incompleteTasks.add(task);
                }
                if (failedTasks.size() > 0) {
                    throw new VoldemortRebalancingException("Rebalance task terminated unsuccessfully on tasks " + failedTasks, failures);
                }
                if (incompleteTasks.size() > 0) {
                    throw new VoldemortException("Rebalance tasks are still incomplete / running " + incompleteTasks);
                }
                Object var16_16 = null;
            }
            catch (VoldemortRebalancingException e) {
                logger.error((Object)("Failure while migrating partitions for rebalance task " + taskId));
                if (hasReadOnlyStores && hasReadWriteStores && finishedReadOnlyStores) {
                    this.adminClient.rebalanceStateChange(null, currentCluster, null, true, true, false, false, false);
                    throw e;
                } else {
                    if (!hasReadWriteStores || !finishedReadOnlyStores) throw e;
                    this.adminClient.rebalanceStateChange(null, currentCluster, null, false, true, false, false, false);
                }
                throw e;
            }
            if (service.isShutdown()) return;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (service.isShutdown()) throw throwable;
            RebalanceUtils.printErrorLog(taskId, logger, "Could not shutdown service cleanly for rebalance task " + taskId, null);
            service.shutdownNow();
            throw throwable;
        }
        RebalanceUtils.printErrorLog(taskId, logger, "Could not shutdown service cleanly for rebalance task " + taskId, null);
        service.shutdownNow();
    }

    private List<RebalanceTask> executeTasks(int taskId, ExecutorService service, List<RebalancePartitionsInfo> rebalancePartitionPlanList, Semaphore[] donorPermits) {
        ArrayList taskList = Lists.newArrayList();
        if (this.rebalanceConfig.isStealerBasedRebalancing()) {
            for (RebalancePartitionsInfo partitionsInfo : rebalancePartitionPlanList) {
                StealerBasedRebalanceTask rebalanceTask = new StealerBasedRebalanceTask(taskId, partitionsInfo, this.rebalanceConfig, donorPermits[partitionsInfo.getDonorId()], this.adminClient);
                taskList.add(rebalanceTask);
                service.execute(rebalanceTask);
            }
        } else {
            HashMap<Integer, List<RebalancePartitionsInfo>> donorNodeBasedPartitionsInfo = RebalanceUtils.groupPartitionsInfoByNode(rebalancePartitionPlanList, false);
            for (Map.Entry<Integer, List<RebalancePartitionsInfo>> entries : donorNodeBasedPartitionsInfo.entrySet()) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                DonorBasedRebalanceTask rebalanceTask = new DonorBasedRebalanceTask(taskId, entries.getValue(), this.rebalanceConfig, donorPermits[entries.getValue().get(0).getDonorId()], this.adminClient);
                taskList.add(rebalanceTask);
                service.execute(rebalanceTask);
            }
        }
        return taskList;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public void stop() {
        this.adminClient.stop();
    }
}

