/*
 * Decompiled with CFR 0.152.
 */
package voldemort.routing;

import voldemort.VoldemortException;
import voldemort.cluster.Cluster;
import voldemort.routing.ConsistentRoutingStrategy;
import voldemort.routing.RouteToAllStrategy;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.ZoneRoutingStrategy;
import voldemort.store.StoreDefinition;

public class RoutingStrategyFactory {
    public RoutingStrategy updateRoutingStrategy(StoreDefinition storeDef, Cluster cluster) {
        if ("consistent-routing".equals(storeDef.getRoutingStrategyType())) {
            return new ConsistentRoutingStrategy(cluster.getNodes(), storeDef.getReplicationFactor());
        }
        if ("all-routing".equals(storeDef.getRoutingStrategyType())) {
            return new RouteToAllStrategy(cluster.getNodes());
        }
        if ("zone-routing".equals(storeDef.getRoutingStrategyType())) {
            return new ZoneRoutingStrategy(cluster.getNodes(), storeDef.getZoneReplicationFactor(), storeDef.getReplicationFactor());
        }
        throw new VoldemortException("RoutingStrategyType:" + storeDef.getRoutingStrategyType() + " not handled by " + this.getClass());
    }
}

