/*
 * Decompiled with CFR 0.152.
 */
package voldemort.server.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanPermitWrapper {
    private final Semaphore scanPermits;
    private Map<String, AtomicLong> permitOwners;
    private final int numPermits;
    private long totalEntriesScanned;

    public ScanPermitWrapper(int numPermits) {
        this.numPermits = numPermits;
        this.scanPermits = new Semaphore(numPermits);
        this.permitOwners = Collections.synchronizedMap(new HashMap());
    }

    public static String getOwnerName() {
        return Thread.currentThread().getStackTrace()[2].getClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(AtomicLong progress) throws InterruptedException {
        this.scanPermits.acquire();
        Map<String, AtomicLong> map = this.permitOwners;
        synchronized (map) {
            this.permitOwners.put(ScanPermitWrapper.getOwnerName(), progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.scanPermits.release();
        Map<String, AtomicLong> map = this.permitOwners;
        synchronized (map) {
            AtomicLong scannedCount = this.permitOwners.get(ScanPermitWrapper.getOwnerName());
            if (scannedCount != null) {
                this.totalEntriesScanned += scannedCount.get();
            }
            this.permitOwners.remove(ScanPermitWrapper.getOwnerName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPermitOwners() {
        ArrayList<String> ownerList = new ArrayList<String>();
        Map<String, AtomicLong> map = this.permitOwners;
        synchronized (map) {
            Iterator<String> i = this.permitOwners.keySet().iterator();
            while (i.hasNext()) {
                ownerList.add(i.next());
            }
        }
        return ownerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(AtomicLong progress) {
        boolean gotPermit = this.scanPermits.tryAcquire();
        if (gotPermit) {
            Map<String, AtomicLong> map = this.permitOwners;
            synchronized (map) {
                this.permitOwners.put(ScanPermitWrapper.getOwnerName(), progress);
            }
        }
        return gotPermit;
    }

    public int availablePermits() {
        return this.scanPermits.availablePermits();
    }

    public int getGrantedPermits() {
        return this.numPermits - this.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntriesScanned() {
        long itemsScanned = 0L;
        Map<String, AtomicLong> map = this.permitOwners;
        synchronized (map) {
            for (Map.Entry<String, AtomicLong> progressEntry : this.permitOwners.entrySet()) {
                AtomicLong progress = progressEntry.getValue();
                if (progress == null) continue;
                itemsScanned += progress.get();
            }
        }
        return this.totalEntriesScanned + itemsScanned;
    }
}

