/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.metadata;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.routing.RouteToAllStrategy;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.server.rebalance.RebalancerState;
import voldemort.store.StorageEngine;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreUtils;
import voldemort.store.configuration.ConfigurationStorageEngine;
import voldemort.store.metadata.MetadataStoreListener;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.ClosableIterator;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataStore
implements StorageEngine<ByteArray, byte[], byte[]> {
    public static final String METADATA_STORE_NAME = "metadata";
    public static final String CLUSTER_KEY = "cluster.xml";
    public static final String STORES_KEY = "stores.xml";
    public static final String SERVER_STATE_KEY = "server.state";
    public static final String NODE_ID_KEY = "node.id";
    public static final String REBALANCING_STEAL_INFO = "rebalancing.steal.info.key";
    public static final Set<String> GOSSIP_KEYS = ImmutableSet.of((Object)"cluster.xml", (Object)"stores.xml");
    public static final Set<String> REQUIRED_KEYS = ImmutableSet.of((Object)"cluster.xml", (Object)"stores.xml");
    public static final Set<String> OPTIONAL_KEYS = ImmutableSet.of((Object)"server.state", (Object)"node.id", (Object)"rebalancing.steal.info.key");
    public static final Set<Object> METADATA_KEYS = ImmutableSet.builder().addAll(REQUIRED_KEYS).addAll(OPTIONAL_KEYS).build();
    private static final String ROUTING_STRATEGY_KEY = "routing.strategy";
    private final Store<String, String, String> innerStore;
    private final Map<String, Versioned<Object>> metadataCache;
    private static final ClusterMapper clusterMapper = new ClusterMapper();
    private static final StoreDefinitionsMapper storeMapper = new StoreDefinitionsMapper();
    private static final RoutingStrategyFactory routingFactory = new RoutingStrategyFactory();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    public final Lock readLock = this.lock.readLock();
    public final Lock writeLock = this.lock.writeLock();
    private final ConcurrentHashMap<String, MetadataStoreListener> storeNameTolisteners;
    private static final Logger logger = Logger.getLogger(MetadataStore.class);

    public MetadataStore(Store<String, String, String> innerStore, int nodeId) {
        this.innerStore = innerStore;
        this.metadataCache = new HashMap<String, Versioned<Object>>();
        this.storeNameTolisteners = new ConcurrentHashMap();
        this.init(nodeId);
    }

    public void addMetadataStoreListener(String storeName, MetadataStoreListener listener) {
        if (this.storeNameTolisteners == null) {
            throw new VoldemortException("MetadataStoreListener must be non-null");
        }
        this.storeNameTolisteners.put(storeName, listener);
    }

    public void remoteMetadataStoreListener(String storeName) {
        if (this.storeNameTolisteners == null) {
            throw new VoldemortException("MetadataStoreListener must be non-null");
        }
        this.storeNameTolisteners.remove(storeName);
    }

    public static MetadataStore readFromDirectory(File dir, int nodeId) {
        if (!Utils.isReadableDir(dir)) {
            throw new IllegalArgumentException("Metadata directory " + dir.getAbsolutePath() + " does not exist or can not be read.");
        }
        if (dir.listFiles() == null) {
            throw new IllegalArgumentException("No configuration found in " + dir.getAbsolutePath() + ".");
        }
        ConfigurationStorageEngine innerStore = new ConfigurationStorageEngine(METADATA_STORE_NAME, dir.getAbsolutePath());
        return new MetadataStore(innerStore, nodeId);
    }

    @Override
    public String getName() {
        return METADATA_STORE_NAME;
    }

    public synchronized void put(String key, Versioned<Object> value) {
        if (METADATA_KEYS.contains(key)) {
            this.putInner(key, this.convertObjectToString(key, value));
            this.metadataCache.put(key, value);
            if (CLUSTER_KEY.equals(key)) {
                this.updateRoutingStrategies((Cluster)value.getValue(), this.getStoreDefList());
            } else if (STORES_KEY.equals(key)) {
                this.updateRoutingStrategies(this.getCluster(), (List)value.getValue());
            }
        } else {
            throw new VoldemortException("Unhandled Key:" + key + " for MetadataStore put()");
        }
    }

    public void put(String key, Object value) {
        if (!METADATA_KEYS.contains(key)) {
            throw new VoldemortException("Unhandled Key:" + key + " for MetadataStore put()");
        }
        VectorClock version = (VectorClock)this.get(key, null).get(0).getVersion();
        this.put(key, new Versioned<Object>(value, version.incremented(this.getNodeId(), System.currentTimeMillis())));
    }

    @Override
    public synchronized void put(ByteArray keyBytes, Versioned<byte[]> valueBytes, byte[] transforms) throws VoldemortException {
        String key = ByteUtils.getString(keyBytes.get(), "UTF-8");
        Versioned<String> value = new Versioned<String>(ByteUtils.getString(valueBytes.getValue(), "UTF-8"), valueBytes.getVersion());
        Versioned<Object> valueObject = this.convertStringToObject(key, value);
        this.put(key, valueObject);
    }

    @Override
    public void close() throws VoldemortException {
        this.innerStore.close();
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        return this.innerStore.getCapability(capability);
    }

    @Override
    public synchronized List<Versioned<byte[]>> get(ByteArray keyBytes, byte[] transforms) throws VoldemortException {
        try {
            String key = ByteUtils.getString(keyBytes.get(), "UTF-8");
            if (METADATA_KEYS.contains(key)) {
                ArrayList values = Lists.newArrayList();
                Versioned<String> value = this.convertObjectToString(key, this.metadataCache.get(key));
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Key " + key + " requested, returning: " + value.getValue()));
                }
                values.add(new Versioned<byte[]>(ByteUtils.getBytes(value.getValue(), "UTF-8"), value.getVersion()));
                return values;
            }
            throw new VoldemortException("Unhandled Key:" + key + " for MetadataStore get()");
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to read metadata key:" + ByteUtils.getString(keyBytes.get(), "UTF-8") + " delete config/.temp config/.version directories and restart.", e);
        }
    }

    @Override
    public List<Versioned<byte[]>> get(String key, String transforms) throws VoldemortException {
        return this.get(new ByteArray(ByteUtils.getBytes(key, "UTF-8")), transforms == null ? null : ByteUtils.getBytes(transforms, "UTF-8"));
    }

    @JmxOperation(description="Clean all rebalancing server/cluster states from this node.", impact=1)
    public synchronized void cleanAllRebalancingState() {
        for (String key : OPTIONAL_KEYS) {
            if (key.equals(NODE_ID_KEY)) continue;
            this.innerStore.delete(key, this.getVersions(new ByteArray(ByteUtils.getBytes(key, "UTF-8"))).get(0));
        }
        this.init(this.getNodeId());
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        List<Versioned<byte[]>> values = this.get(key, null);
        ArrayList<Version> versions = new ArrayList<Version>(values.size());
        for (Versioned<byte[]> value : values) {
            versions.add(value.getVersion());
        }
        return versions;
    }

    public Cluster getCluster() {
        return (Cluster)this.metadataCache.get(CLUSTER_KEY).getValue();
    }

    public List<StoreDefinition> getStoreDefList() {
        return (List)this.metadataCache.get(STORES_KEY).getValue();
    }

    public int getNodeId() {
        return (Integer)this.metadataCache.get(NODE_ID_KEY).getValue();
    }

    public StoreDefinition getStoreDef(String storeName) {
        List<StoreDefinition> storeDefs = this.getStoreDefList();
        for (StoreDefinition storeDef : storeDefs) {
            if (!storeDef.getName().equals(storeName)) continue;
            return storeDef;
        }
        throw new VoldemortException("Store " + storeName + " not found in MetadataStore");
    }

    public VoldemortState getServerState() {
        return VoldemortState.valueOf(this.metadataCache.get(SERVER_STATE_KEY).getValue().toString());
    }

    public RebalancerState getRebalancerState() {
        return (RebalancerState)this.metadataCache.get(REBALANCING_STEAL_INFO).getValue();
    }

    public RoutingStrategy getRoutingStrategy(String storeName) {
        Map routingStrategyMap = (Map)this.metadataCache.get(ROUTING_STRATEGY_KEY).getValue();
        return (RoutingStrategy)routingStrategyMap.get(storeName);
    }

    private void updateRoutingStrategies(Cluster cluster, List<StoreDefinition> storeDefs) {
        VectorClock clock = new VectorClock();
        if (this.metadataCache.containsKey(ROUTING_STRATEGY_KEY)) {
            clock = (VectorClock)this.metadataCache.get(ROUTING_STRATEGY_KEY).getVersion();
        }
        logger.info((Object)"Updating routing strategy for all stores");
        HashMap<String, RoutingStrategy> routingStrategyMap = this.createRoutingStrategyMap(cluster, storeDefs);
        this.metadataCache.put(ROUTING_STRATEGY_KEY, new Versioned<HashMap<String, RoutingStrategy>>(routingStrategyMap, clock.incremented(this.getNodeId(), System.currentTimeMillis())));
        for (String storeName : this.storeNameTolisteners.keySet()) {
            RoutingStrategy updatedRoutingStrategy = routingStrategyMap.get(storeName);
            if (updatedRoutingStrategy == null) continue;
            try {
                this.storeNameTolisteners.get(storeName).updateRoutingStrategy(updatedRoutingStrategy);
            }
            catch (Exception e) {
                if (!logger.isEnabledFor((Priority)Level.WARN)) continue;
                logger.warn((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRebalancingState(RebalancePartitionsInfo stealInfo) {
        this.writeLock.lock();
        try {
            RebalancerState rebalancerState;
            if (ByteUtils.getString(this.get(SERVER_STATE_KEY, null).get(0).getValue(), "UTF-8").compareTo(VoldemortState.NORMAL_SERVER.toString()) == 0) {
                this.put(SERVER_STATE_KEY, (Object)VoldemortState.REBALANCING_MASTER_SERVER);
                this.initCache(SERVER_STATE_KEY);
            }
            if (!(rebalancerState = this.getRebalancerState()).update(stealInfo)) {
                throw new VoldemortException("Could not add steal information " + stealInfo + " since a plan for the same donor node " + stealInfo.getDonorId() + " ( " + rebalancerState.find(stealInfo.getDonorId()) + " ) already exists");
            }
            this.put(REBALANCING_STEAL_INFO, rebalancerState);
            this.initCache(REBALANCING_STEAL_INFO);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRebalancingState(RebalancePartitionsInfo stealInfo) {
        this.writeLock.lock();
        try {
            RebalancerState rebalancerState = this.getRebalancerState();
            if (!rebalancerState.remove(stealInfo)) {
                throw new IllegalArgumentException("Couldn't find " + stealInfo + " in " + rebalancerState + " while deleting");
            }
            if (rebalancerState.isEmpty()) {
                logger.debug((Object)"Cleaning all rebalancing state");
                this.cleanAllRebalancingState();
            } else {
                this.put(REBALANCING_STEAL_INFO, rebalancerState);
                this.initCache(REBALANCING_STEAL_INFO);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ClosableIterator<Pair<ByteArray, Versioned<byte[]>>> entries() {
        throw new VoldemortException("You cannot iterate over all entries in Metadata");
    }

    @Override
    public ClosableIterator<ByteArray> keys() {
        throw new VoldemortException("You cannot iterate over all keys in Metadata");
    }

    @Override
    public void truncate() {
        throw new VoldemortException("You cannot truncate entries in Metadata");
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        throw new VoldemortException("You cannot delete your metadata fool !!");
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        return StoreUtils.getAll(this, keys, transforms);
    }

    private void init(int nodeId) {
        logger.info((Object)"metadata init().");
        this.initCache(CLUSTER_KEY);
        this.initCache(STORES_KEY);
        this.initCache(NODE_ID_KEY, nodeId);
        if (this.getNodeId() != nodeId) {
            throw new RuntimeException("Attempt to start previous node:" + this.getNodeId() + " as node:" + nodeId + " (Did you copy config directory ? try deleting .temp .version in config dir to force clean) aborting ...");
        }
        this.initCache(REBALANCING_STEAL_INFO, new RebalancerState(new ArrayList<RebalancePartitionsInfo>()));
        this.initCache(SERVER_STATE_KEY, VoldemortState.NORMAL_SERVER.toString());
        this.updateRoutingStrategies(this.getCluster(), this.getStoreDefList());
    }

    private synchronized void initCache(String key) {
        this.metadataCache.put(key, this.convertStringToObject(key, this.getInnerValue(key)));
    }

    private void initCache(String key, Object defaultValue) {
        try {
            this.initCache(key);
        }
        catch (Exception e) {
            this.put(key, new Versioned<Object>(defaultValue));
        }
    }

    private HashMap<String, RoutingStrategy> createRoutingStrategyMap(Cluster cluster, List<StoreDefinition> storeDefs) {
        HashMap<String, RoutingStrategy> map = new HashMap<String, RoutingStrategy>();
        for (StoreDefinition store : storeDefs) {
            map.put(store.getName(), routingFactory.updateRoutingStrategy(store, cluster));
        }
        map.put(METADATA_STORE_NAME, new RouteToAllStrategy(this.getCluster().getNodes()));
        return map;
    }

    private Versioned<String> convertObjectToString(String key, Versioned<Object> value) {
        String valueStr = value.getValue().toString();
        if (CLUSTER_KEY.equals(key)) {
            valueStr = clusterMapper.writeCluster((Cluster)value.getValue());
        } else if (STORES_KEY.equals(key)) {
            valueStr = storeMapper.writeStoreList((List)value.getValue());
        } else if (REBALANCING_STEAL_INFO.equals(key)) {
            RebalancerState rebalancerState = (RebalancerState)value.getValue();
            valueStr = rebalancerState.toJsonString();
        } else if (SERVER_STATE_KEY.equals(key) || NODE_ID_KEY.equals(key)) {
            valueStr = value.getValue().toString();
        } else {
            throw new VoldemortException("Unhandled key:'" + key + "' for Object to String serialization.");
        }
        return new Versioned<String>(valueStr, value.getVersion());
    }

    private Versioned<Object> convertStringToObject(String key, Versioned<String> value) {
        Object valueObject = null;
        if (CLUSTER_KEY.equals(key)) {
            valueObject = clusterMapper.readCluster(new StringReader(value.getValue()));
        } else if (STORES_KEY.equals(key)) {
            valueObject = storeMapper.readStoreList(new StringReader(value.getValue()));
        } else if (SERVER_STATE_KEY.equals(key)) {
            valueObject = VoldemortState.valueOf(value.getValue());
        } else if (NODE_ID_KEY.equals(key)) {
            valueObject = Integer.parseInt(value.getValue());
        } else if (REBALANCING_STEAL_INFO.equals(key)) {
            String valueString = value.getValue();
            valueObject = valueString.startsWith("[") ? RebalancerState.create(valueString) : new RebalancerState(Arrays.asList(RebalancePartitionsInfo.create(valueString)));
        } else {
            throw new VoldemortException("Unhandled key:'" + key + "' for String to Object serialization.");
        }
        return new Versioned<Object>(valueObject, value.getVersion());
    }

    private void putInner(String key, Versioned<String> value) {
        this.innerStore.put(key, value, null);
    }

    private Versioned<String> getInnerValue(String key) throws VoldemortException {
        List<Versioned<String>> values = this.innerStore.get(key, null);
        if (values.size() > 1) {
            throw new VoldemortException("Inconsistent metadata found: expected 1 version but found " + values.size() + " for key:" + key);
        }
        if (values.size() > 0) {
            return values.get(0);
        }
        throw new VoldemortException("No metadata found for required key:" + key);
    }

    @Override
    public boolean isPartitionAware() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VoldemortState {
        NORMAL_SERVER,
        REBALANCING_MASTER_SERVER;

    }
}

