/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import voldemort.VoldemortException;
import voldemort.routing.RoutingStrategy;
import voldemort.server.VoldemortConfig;
import voldemort.store.StorageConfiguration;
import voldemort.store.StorageEngine;
import voldemort.store.StoreDefinition;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.readonly.SearchStrategy;
import voldemort.utils.ByteArray;
import voldemort.utils.JmxUtils;
import voldemort.utils.ReflectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyStorageConfiguration
implements StorageConfiguration {
    public static final String TYPE_NAME = "read-only";
    private final int numBackups;
    private final File storageDir;
    private final Set<ObjectName> registeredBeans;
    private final SearchStrategy searcher;
    private final int nodeId;
    private RoutingStrategy routingStrategy = null;
    private final int deleteBackupMs;

    public ReadOnlyStorageConfiguration(VoldemortConfig config) {
        this.storageDir = new File(config.getReadOnlyDataStorageDirectory());
        this.numBackups = config.getReadOnlyBackups();
        this.registeredBeans = Collections.synchronizedSet(new HashSet());
        this.searcher = (SearchStrategy)ReflectUtils.callConstructor(ReflectUtils.loadClass(config.getReadOnlySearchStrategy().trim()));
        this.nodeId = config.getNodeId();
        this.deleteBackupMs = config.getReadOnlyDeleteBackupMs();
    }

    @Override
    public void close() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        for (ObjectName name : this.registeredBeans) {
            JmxUtils.unregisterMbean(server, name);
        }
    }

    public void setRoutingStrategy(RoutingStrategy routingStrategy) {
        this.routingStrategy = routingStrategy;
    }

    @Override
    public StorageEngine<ByteArray, byte[], byte[]> getStore(StoreDefinition storeDef) {
        ReadOnlyStorageEngine store = new ReadOnlyStorageEngine(storeDef.getName(), this.searcher, this.routingStrategy, this.nodeId, new File(this.storageDir, storeDef.getName()), this.numBackups, this.deleteBackupMs);
        ObjectName objName = JmxUtils.createObjectName(JmxUtils.getPackageName(store.getClass()), storeDef.getName() + this.nodeId);
        JmxUtils.registerMbean(ManagementFactory.getPlatformMBeanServer(), JmxUtils.createModelMBean(store), objName);
        this.registeredBeans.add(objName);
        return store;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public void update(StoreDefinition storeDef) {
        throw new VoldemortException("Storage config updates not permitted for " + this.getClass().getCanonicalName());
    }
}

