/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReadOnlyStorageFormat {
    READONLY_V0("ro0", "node-chunks-v0"),
    READONLY_V1("ro1", "partition-chunks-v1"),
    READONLY_V2("ro2", "replica-chunks-with-keys-v2");

    private final String code;
    private final String displayName;

    private ReadOnlyStorageFormat(String code, String display) {
        this.code = code;
        this.displayName = display;
    }

    public String getCode() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static ReadOnlyStorageFormat fromCode(String code) {
        for (ReadOnlyStorageFormat type : ReadOnlyStorageFormat.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        throw new IllegalArgumentException("No request format '" + code + "' was found");
    }

    public String toString() {
        return this.code;
    }
}

