/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.chunk;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.store.readonly.ReadOnlyStorageFormat;
import voldemort.store.readonly.ReadOnlyStorageMetadata;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.chunk.DataFileChunkSet;
import voldemort.store.readonly.chunk.DataFileChunkSetIterator;
import voldemort.store.readonly.chunk.LocalDataFileChunk;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkedFileSet {
    private static Logger logger = Logger.getLogger(ChunkedFileSet.class);
    private final int numChunks;
    private final int nodeId;
    private final File baseDir;
    private final List<Integer> indexFileSizes;
    private final List<Integer> dataFileSizes;
    private final List<MappedByteBuffer> indexFiles;
    private final List<FileChannel> dataFiles;
    private final HashMap<Object, Integer> chunkIdToChunkStart;
    private final HashMap<Object, Integer> chunkIdToNumChunks;
    private ArrayList<Integer> nodePartitionIds;
    private RoutingStrategy routingStrategy;
    private ReadOnlyStorageFormat storageFormat;

    public ChunkedFileSet(File directory, RoutingStrategy routingStrategy, int nodeId) {
        this.baseDir = directory;
        if (!Utils.isReadableDir(directory)) {
            throw new VoldemortException(directory.getAbsolutePath() + " is not a readable directory.");
        }
        File metadataFile = new File(this.baseDir, ".metadata");
        ReadOnlyStorageMetadata metadata = new ReadOnlyStorageMetadata();
        if (Utils.isReadableFile(metadataFile)) {
            try {
                metadata = new ReadOnlyStorageMetadata(metadataFile);
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot read metadata file, assuming default values");
            }
        } else {
            logger.warn((Object)"Metadata file not found. Assuming default settings");
        }
        this.storageFormat = ReadOnlyStorageFormat.fromCode((String)metadata.get("format", ReadOnlyStorageFormat.READONLY_V0.getCode()));
        this.indexFileSizes = new ArrayList<Integer>();
        this.dataFileSizes = new ArrayList<Integer>();
        this.indexFiles = new ArrayList<MappedByteBuffer>();
        this.dataFiles = new ArrayList<FileChannel>();
        this.chunkIdToChunkStart = new HashMap();
        this.chunkIdToNumChunks = new HashMap();
        this.nodeId = nodeId;
        this.setRoutingStrategy(routingStrategy);
        switch (this.storageFormat) {
            case READONLY_V0: {
                this.initVersion0();
                break;
            }
            case READONLY_V1: {
                this.initVersion1();
                break;
            }
            case READONLY_V2: {
                this.initVersion2();
                break;
            }
            default: {
                throw new VoldemortException("Invalid chunked storage format type " + (Object)((Object)this.storageFormat));
            }
        }
        this.numChunks = this.indexFileSizes.size();
        logger.trace((Object)("Opened chunked file set for " + this.baseDir + " with " + this.indexFileSizes.size() + " chunks and format  " + (Object)((Object)this.storageFormat)));
    }

    public DataFileChunkSet toDataFileChunkSet() {
        ArrayList dataFileChunks = Lists.newArrayList();
        for (FileChannel dataFile : this.dataFiles) {
            dataFileChunks.add(new LocalDataFileChunk(dataFile));
        }
        return new DataFileChunkSet(dataFileChunks, this.dataFileSizes);
    }

    public ReadOnlyStorageFormat getReadOnlyStorageFormat() {
        return this.storageFormat;
    }

    public void initVersion0() {
        if (this.baseDir.list() != null && this.baseDir.list().length <= 1) {
            try {
                new File(this.baseDir, "0.index").createNewFile();
                new File(this.baseDir, "0.data").createNewFile();
                logger.info((Object)"No index or data files found, creating empty files 0.index and 0.data.");
            }
            catch (IOException e) {
                throw new VoldemortException("Error creating empty read-only files.", e);
            }
        }
        int chunkId = 0;
        while (true) {
            File index = new File(this.baseDir, Integer.toString(chunkId) + ".index");
            File data = new File(this.baseDir, Integer.toString(chunkId) + ".data");
            if (!index.exists() && !data.exists()) break;
            if (index.exists() ^ data.exists()) {
                throw new VoldemortException("One of the following does not exist: " + index.toString() + " and " + data.toString() + ".");
            }
            long indexLength = index.length();
            long dataLength = data.length();
            this.validateFileSizes(indexLength, dataLength);
            this.indexFileSizes.add((int)indexLength);
            this.dataFileSizes.add((int)dataLength);
            this.dataFiles.add(this.openChannel(data));
            this.indexFiles.add(this.mapFile(index));
            ++chunkId;
        }
        if (chunkId == 0) {
            throw new VoldemortException("No data chunks found in directory " + this.baseDir.toString());
        }
    }

    public void initVersion1() {
        int globalChunkId = 0;
        if (this.nodePartitionIds != null) {
            for (Integer partitionId : this.nodePartitionIds) {
                int chunkId = 0;
                while (true) {
                    String fileName = Integer.toString(partitionId) + "_" + Integer.toString(chunkId);
                    File index = new File(this.baseDir, fileName + ".index");
                    File data = new File(this.baseDir, fileName + ".data");
                    if (!index.exists() && !data.exists()) {
                        if (chunkId != 0) break;
                        try {
                            new File(this.baseDir, fileName + ".index").createNewFile();
                            new File(this.baseDir, fileName + ".data").createNewFile();
                            logger.info((Object)("No index or data files found, creating empty chunk files for partition " + partitionId));
                        }
                        catch (IOException e) {
                            throw new VoldemortException("Error creating empty read-only files for partition " + partitionId, e);
                        }
                    } else if (index.exists() ^ data.exists()) {
                        throw new VoldemortException("One of the following does not exist: " + index.toString() + " or " + data.toString() + ".");
                    }
                    if (chunkId == 0) {
                        this.chunkIdToChunkStart.put(partitionId, globalChunkId);
                    }
                    long indexLength = index.length();
                    long dataLength = data.length();
                    this.validateFileSizes(indexLength, dataLength);
                    this.indexFileSizes.add((int)indexLength);
                    this.dataFileSizes.add((int)dataLength);
                    this.dataFiles.add(this.openChannel(data));
                    this.indexFiles.add(this.mapFile(index));
                    ++chunkId;
                    ++globalChunkId;
                }
                this.chunkIdToNumChunks.put(partitionId, chunkId);
            }
            if (this.indexFileSizes.size() == 0) {
                throw new VoldemortException("No chunk files found in directory " + this.baseDir.toString());
            }
        }
    }

    public void initVersion2() {
        int globalChunkId = 0;
        if (this.nodePartitionIds != null) {
            for (Node node : this.routingStrategy.getNodes()) {
                for (int partitionId : node.getPartitionIds()) {
                    List<Integer> routingPartitionList = this.routingStrategy.getReplicatingPartitionList(partitionId);
                    Pair<Integer, Integer> bucket = null;
                    for (int replicaType = 0; replicaType < routingPartitionList.size(); ++replicaType) {
                        if (!this.nodePartitionIds.contains(routingPartitionList.get(replicaType))) continue;
                        if (bucket == null) {
                            bucket = Pair.create(routingPartitionList.get(0), replicaType);
                            int chunkId = 0;
                            while (true) {
                                String fileName = Integer.toString(bucket.getFirst()) + "_" + Integer.toString(bucket.getSecond()) + "_" + Integer.toString(chunkId);
                                File index = new File(this.baseDir, fileName + ".index");
                                File data = new File(this.baseDir, fileName + ".data");
                                if (!index.exists() && !data.exists()) {
                                    if (chunkId != 0) break;
                                    try {
                                        new File(this.baseDir, fileName + ".index").createNewFile();
                                        new File(this.baseDir, fileName + ".data").createNewFile();
                                        logger.info((Object)("No index or data files found, creating empty files for partition " + routingPartitionList.get(0) + " and replica type " + replicaType));
                                    }
                                    catch (IOException e) {
                                        throw new VoldemortException("Error creating empty read-only files for partition " + routingPartitionList.get(0) + " and replica type " + replicaType, e);
                                    }
                                } else if (index.exists() ^ data.exists()) {
                                    throw new VoldemortException("One of the following does not exist: " + index.toString() + " or " + data.toString() + ".");
                                }
                                if (chunkId == 0) {
                                    this.chunkIdToChunkStart.put(bucket, globalChunkId);
                                }
                                long indexLength = index.length();
                                long dataLength = data.length();
                                this.validateFileSizes(indexLength, dataLength);
                                this.indexFileSizes.add((int)indexLength);
                                this.dataFileSizes.add((int)dataLength);
                                this.dataFiles.add(this.openChannel(data));
                                this.indexFiles.add(this.mapFile(index));
                                ++chunkId;
                                ++globalChunkId;
                            }
                            this.chunkIdToNumChunks.put(bucket, chunkId);
                            continue;
                        }
                        throw new VoldemortException("Found a collision for master partition for bucket named " + bucket);
                    }
                }
            }
            if (this.indexFileSizes.size() == 0) {
                throw new VoldemortException("No chunk files found in directory " + this.baseDir.toString());
            }
        }
    }

    public HashMap<Object, Integer> getChunkIdToNumChunks() {
        return this.chunkIdToNumChunks;
    }

    private void setRoutingStrategy(RoutingStrategy routingStrategy) {
        this.routingStrategy = routingStrategy;
        this.nodePartitionIds = null;
        for (Node node : routingStrategy.getNodes()) {
            if (node.getId() != this.nodeId) continue;
            this.nodePartitionIds = new ArrayList();
            this.nodePartitionIds.addAll(node.getPartitionIds());
            break;
        }
    }

    public void validateFileSizes(long indexLength, long dataLength) {
        if (indexLength > Integer.MAX_VALUE || dataLength > Integer.MAX_VALUE) {
            throw new VoldemortException("Index or data file exceeds 2147483647 bytes.");
        }
        if (indexLength % (long)(this.getKeyHashSize() + 4) != 0L) {
            throw new VoldemortException("Invalid index file, file length must be a multiple of " + (this.getKeyHashSize() + 4) + " but is only " + indexLength + " bytes.");
        }
        if (dataLength < 4L * indexLength / (long)(this.getKeyHashSize() + 4)) {
            throw new VoldemortException("Invalid data file, file length must not be less than num_index_entries * 4 bytes, but data file is only " + dataLength + " bytes.");
        }
    }

    public void close() {
        for (int chunk = 0; chunk < this.numChunks; ++chunk) {
            FileChannel channel = this.dataFileFor(chunk);
            try {
                channel.close();
                continue;
            }
            catch (IOException e) {
                logger.error((Object)"Error while closing file.", (Throwable)e);
            }
        }
    }

    private FileChannel openChannel(File file) {
        try {
            return new FileInputStream(file).getChannel();
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    private MappedByteBuffer mapFile(File file) {
        try {
            FileChannel channel = new FileInputStream(file).getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            channel.close();
            return buffer;
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public byte[] keyToStorageFormat(byte[] key) {
        switch (this.getReadOnlyStorageFormat()) {
            case READONLY_V0: 
            case READONLY_V1: {
                return ByteUtils.md5(key);
            }
            case READONLY_V2: {
                return ByteUtils.copy(ByteUtils.md5(key), 0, 8);
            }
        }
        throw new VoldemortException("Unknown read-only storage format");
    }

    private int getKeyHashSize() {
        switch (this.getReadOnlyStorageFormat()) {
            case READONLY_V0: 
            case READONLY_V1: {
                return 16;
            }
            case READONLY_V2: {
                return 8;
            }
        }
        throw new VoldemortException("Unknown read-only storage format");
    }

    public int getChunkForKey(byte[] key) {
        switch (this.storageFormat) {
            case READONLY_V0: {
                return ReadOnlyUtils.chunk(ByteUtils.md5(key), this.numChunks);
            }
            case READONLY_V1: {
                List<Integer> routingPartitionList = this.routingStrategy.getPartitionList(key);
                routingPartitionList.retainAll(this.nodePartitionIds);
                if (routingPartitionList.size() != 1) {
                    return -1;
                }
                return this.chunkIdToChunkStart.get(routingPartitionList.get(0)) + ReadOnlyUtils.chunk(ByteUtils.md5(key), this.chunkIdToNumChunks.get(routingPartitionList.get(0)));
            }
            case READONLY_V2: {
                List<Integer> routingPartitionList = this.routingStrategy.getPartitionList(key);
                Pair<Integer, Integer> bucket = null;
                for (int replicaType = 0; replicaType < routingPartitionList.size(); ++replicaType) {
                    if (!this.nodePartitionIds.contains(routingPartitionList.get(replicaType))) continue;
                    if (bucket == null) {
                        bucket = Pair.create(routingPartitionList.get(0), replicaType);
                        continue;
                    }
                    return -1;
                }
                if (bucket == null) {
                    return -1;
                }
                return this.chunkIdToChunkStart.get(bucket) + ReadOnlyUtils.chunk(ByteUtils.md5(key), this.chunkIdToNumChunks.get(bucket));
            }
        }
        return -1;
    }

    public byte[] readValue(byte[] key, int chunk, int valueLocation) {
        FileChannel dataFile = this.dataFileFor(chunk);
        try {
            switch (this.storageFormat) {
                case READONLY_V0: 
                case READONLY_V1: {
                    ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
                    dataFile.read(sizeBuffer, valueLocation);
                    int valueSize = sizeBuffer.getInt(0);
                    ByteBuffer valueBuffer = ByteBuffer.allocate(valueSize);
                    dataFile.read(valueBuffer, valueLocation + 4);
                    return valueBuffer.array();
                }
                case READONLY_V2: {
                    int headerSize = 10;
                    ByteBuffer sizeBuffer = ByteBuffer.allocate(headerSize);
                    dataFile.read(sizeBuffer, valueLocation);
                    valueLocation += headerSize;
                    short numKeyValues = sizeBuffer.getShort(0);
                    int keySize = sizeBuffer.getInt(2);
                    int valueSize = sizeBuffer.getInt(6);
                    do {
                        if (keySize == -1 && valueSize == -1) {
                            sizeBuffer.clear();
                            dataFile.read(sizeBuffer, valueLocation);
                            keySize = sizeBuffer.getInt(0);
                            valueSize = sizeBuffer.getInt(4);
                            valueLocation += 8;
                        }
                        ByteBuffer buffer = ByteBuffer.allocate(keySize + valueSize);
                        dataFile.read(buffer, valueLocation);
                        if (ByteUtils.compare(key, buffer.array(), 0, keySize) == 0) {
                            return ByteUtils.copy(buffer.array(), keySize, keySize + valueSize);
                        }
                        valueLocation += keySize + valueSize;
                        valueSize = -1;
                        keySize = -1;
                    } while ((numKeyValues = (short)(numKeyValues - 1)) > 0);
                    return new byte[0];
                }
            }
            throw new VoldemortException("Storage format not supported ");
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
    }

    public ByteBuffer indexFileFor(int chunk) {
        return this.indexFiles.get(chunk).duplicate();
    }

    public FileChannel dataFileFor(int chunk) {
        return this.dataFiles.get(chunk);
    }

    public int getIndexFileSize(int chunk) {
        return this.indexFileSizes.get(chunk);
    }

    public int getDataFileSize(int chunk) {
        return this.dataFileSizes.get(chunk);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ROCollidedEntriesIterator
    extends DataFileChunkSetIterator<Pair<ByteBuffer, ByteBuffer>> {
        private MessageDigest md5er = ByteUtils.getDigest("md5");

        public ROCollidedEntriesIterator(DataFileChunkSet dataFileChunkSet) {
            this(dataFileChunkSet, new ReentrantReadWriteLock());
        }

        public ROCollidedEntriesIterator(DataFileChunkSet dataFileChunkSet, ReadWriteLock modificationLock) {
            super(dataFileChunkSet, true, modificationLock);
        }

        @Override
        public Pair<ByteBuffer, ByteBuffer> next() {
            if (!this.hasNext()) {
                throw new VoldemortException("Reached the end");
            }
            try {
                ByteBuffer keyBuffer = ByteBuffer.allocate(8);
                ByteBuffer numKeyValsBuffer = ByteBuffer.allocate(2);
                this.getCurrentChunk().read(numKeyValsBuffer, this.getCurrentOffsetInChunk());
                int tupleCount = numKeyValsBuffer.getShort(0);
                int offsetMoved = 2;
                ByteBuffer keyValueLength = ByteBuffer.allocate(8);
                for (int tupleId = 0; tupleId < tupleCount; ++tupleId) {
                    this.getCurrentChunk().read(keyValueLength, this.getCurrentOffsetInChunk() + (long)offsetMoved);
                    int keyLength = keyValueLength.getInt(0);
                    int valueLength = keyValueLength.getInt(4);
                    if (keyBuffer.hasRemaining()) {
                        ByteBuffer tempKeyBuffer = ByteBuffer.allocate(keyLength);
                        this.getCurrentChunk().read(tempKeyBuffer, this.getCurrentOffsetInChunk() + (long)keyLength + (long)valueLength);
                        keyBuffer.put(ByteUtils.copy(this.md5er.digest(tempKeyBuffer.array()), 0, 8));
                    }
                    offsetMoved += 8 + keyLength + valueLength;
                    keyValueLength.clear();
                }
                ByteBuffer finalValue = ByteBuffer.allocate(offsetMoved);
                this.getCurrentChunk().read(finalValue, this.getCurrentOffsetInChunk());
                this.updateOffset(this.getCurrentOffsetInChunk() + (long)offsetMoved);
                Pair<ByteBuffer, ByteBuffer> pair = Pair.create(keyBuffer, finalValue);
                Object var11_13 = null;
                this.md5er.reset();
                return pair;
            }
            catch (IOException e) {
                try {
                    logger.error((Object)e);
                    throw new VoldemortException(e);
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    this.md5er.reset();
                    throw throwable;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ROEntriesIterator
    extends DataFileChunkSetIterator<Pair<ByteArray, Versioned<byte[]>>> {
        public ROEntriesIterator(ChunkedFileSet chunkedFileSet, ReadWriteLock modificationLock) {
            super(chunkedFileSet.toDataFileChunkSet(), false, modificationLock);
        }

        @Override
        public Pair<ByteArray, Versioned<byte[]>> next() {
            if (!this.hasNext()) {
                throw new VoldemortException("Reached the end");
            }
            try {
                ByteBuffer sizeBuffer = ByteBuffer.allocate(8);
                this.getCurrentChunk().read(sizeBuffer, this.getCurrentOffsetInChunk());
                int keySize = sizeBuffer.getInt(0);
                int valueSize = sizeBuffer.getInt(4);
                ByteBuffer keyAndValueBuffer = ByteBuffer.allocate(keySize + valueSize);
                this.getCurrentChunk().read(keyAndValueBuffer, this.getCurrentOffsetInChunk() + 8L);
                this.updateOffset(this.getCurrentOffsetInChunk() + 8L + (long)keySize + (long)valueSize);
                return Pair.create(new ByteArray(ByteUtils.copy(keyAndValueBuffer.array(), 0, keySize)), Versioned.value(ByteUtils.copy(keyAndValueBuffer.array(), keySize, keySize + valueSize)));
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new VoldemortException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ROKeyIterator
    extends DataFileChunkSetIterator<ByteArray> {
        public ROKeyIterator(ChunkedFileSet chunkedFileSet, ReadWriteLock modificationLock) {
            super(chunkedFileSet.toDataFileChunkSet(), false, modificationLock);
        }

        @Override
        public ByteArray next() {
            if (!this.hasNext()) {
                throw new VoldemortException("Reached the end");
            }
            try {
                ByteBuffer sizeBuffer = ByteBuffer.allocate(8);
                this.getCurrentChunk().read(sizeBuffer, this.getCurrentOffsetInChunk());
                int keySize = sizeBuffer.getInt(0);
                int valueSize = sizeBuffer.getInt(4);
                ByteBuffer keyBuffer = ByteBuffer.allocate(keySize);
                this.getCurrentChunk().read(keyBuffer, this.getCurrentOffsetInChunk() + 8L);
                this.updateOffset(this.getCurrentOffsetInChunk() + 8L + (long)keySize + (long)valueSize);
                return new ByteArray(keyBuffer.array());
            }
            catch (IOException e) {
                logger.error((Object)e);
                throw new VoldemortException(e);
            }
        }
    }
}

