/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.InvalidMetadataException;
import voldemort.store.UnreachableStoreException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PutPipelineData;
import voldemort.store.routed.Response;
import voldemort.store.routed.action.AbstractKeyBasedAction;
import voldemort.store.slop.HintedHandoff;
import voldemort.store.slop.Slop;
import voldemort.utils.ByteArray;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerformParallelPutRequests
extends AbstractKeyBasedAction<ByteArray, Void, PutPipelineData> {
    private final int preferred;
    private final int required;
    private final long timeoutMs;
    private final Map<Integer, NonblockingStore> nonblockingStores;
    private final FailureDetector failureDetector;
    private byte[] transforms;
    private final HintedHandoff hintedHandoff;
    public boolean enableHintedHandoff;

    public PerformParallelPutRequests(PutPipelineData pipelineData, Pipeline.Event completeEvent, ByteArray key, byte[] transforms, FailureDetector failureDetector, int preferred, int required, long timeoutMs, Map<Integer, NonblockingStore> nonblockingStores, HintedHandoff hintedHandoff) {
        super(pipelineData, completeEvent, key);
        this.failureDetector = failureDetector;
        this.preferred = preferred;
        this.required = required;
        this.timeoutMs = timeoutMs;
        this.transforms = transforms;
        this.nonblockingStores = nonblockingStores;
        this.hintedHandoff = hintedHandoff;
        this.enableHintedHandoff = hintedHandoff != null;
    }

    public boolean isHintedHandoffEnabled() {
        return this.enableHintedHandoff;
    }

    @Override
    public void execute(final Pipeline pipeline) {
        CountDownLatch attemptsLatch;
        ConcurrentHashMap responses;
        block30: {
            Node master = ((PutPipelineData)this.pipelineData).getMaster();
            final Versioned<byte[]> versionedCopy = ((PutPipelineData)this.pipelineData).getVersionedCopy();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Serial put requests determined master node as " + master.getId() + ", submitting remaining requests in parallel"));
            }
            List<Node> nodes = ((PutPipelineData)this.pipelineData).getNodes();
            int firstParallelNodeIndex = nodes.indexOf(master) + 1;
            int attempts = nodes.size() - firstParallelNodeIndex;
            int blocks = Math.min(this.preferred - 1, attempts);
            responses = new ConcurrentHashMap();
            attemptsLatch = new CountDownLatch(attempts);
            final CountDownLatch blocksLatch = new CountDownLatch(blocks);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Attempting " + attempts + " " + pipeline.getOperation().getSimpleName() + " operations in parallel"));
            }
            for (int i = firstParallelNodeIndex; i < firstParallelNodeIndex + attempts; ++i) {
                final Node node = nodes.get(i);
                ((PutPipelineData)this.pipelineData).incrementNodeIndex();
                NonblockingStoreCallback callback = new NonblockingStoreCallback(){

                    public void requestComplete(Object result, long requestTime) {
                        if (PerformParallelPutRequests.this.logger.isTraceEnabled()) {
                            PerformParallelPutRequests.this.logger.trace((Object)(pipeline.getOperation().getSimpleName() + " response received (" + requestTime + " ms.) from node " + node.getId()));
                        }
                        Response<Object, Object> response = new Response<Object, Object>(node, PerformParallelPutRequests.this.key, result, requestTime);
                        responses.put(node.getId(), response);
                        if (PerformParallelPutRequests.this.logger.isDebugEnabled()) {
                            PerformParallelPutRequests.this.logger.debug((Object)("Finished secondary PUT for key " + PerformParallelPutRequests.this.key + " (keyRef: " + System.identityHashCode(PerformParallelPutRequests.this.key) + "); took " + requestTime + " ms on node " + node.getId() + "(" + node.getHost() + ")"));
                        }
                        if (PerformParallelPutRequests.this.isHintedHandoffEnabled() && pipeline.isFinished() && response.getValue() instanceof UnreachableStoreException) {
                            Slop slop = new Slop(((PutPipelineData)PerformParallelPutRequests.this.pipelineData).getStoreName(), Slop.Operation.PUT, (ByteArray)PerformParallelPutRequests.this.key, (byte[])versionedCopy.getValue(), PerformParallelPutRequests.this.transforms, node.getId(), new Date());
                            ((PutPipelineData)PerformParallelPutRequests.this.pipelineData).addFailedNode(node);
                            PerformParallelPutRequests.this.hintedHandoff.sendHintSerial(node, versionedCopy.getVersion(), slop);
                        }
                        attemptsLatch.countDown();
                        blocksLatch.countDown();
                        if (PerformParallelPutRequests.this.logger.isTraceEnabled()) {
                            PerformParallelPutRequests.this.logger.trace((Object)(attemptsLatch.getCount() + " attempts remaining. Will block " + " for " + blocksLatch.getCount() + " more "));
                        }
                        if (pipeline.isFinished() && response.getValue() instanceof Exception && !(response.getValue() instanceof ObsoleteVersionException)) {
                            if (response.getValue() instanceof InvalidMetadataException) {
                                ((PutPipelineData)PerformParallelPutRequests.this.pipelineData).reportException((InvalidMetadataException)response.getValue());
                                PerformParallelPutRequests.this.logger.warn((Object)("Received invalid metadata problem after a successful " + pipeline.getOperation().getSimpleName() + " call on node " + node.getId() + ", store '" + ((PutPipelineData)PerformParallelPutRequests.this.pipelineData).getStoreName() + "'"));
                            } else {
                                PerformParallelPutRequests.this.handleResponseError(response, pipeline, PerformParallelPutRequests.this.failureDetector);
                            }
                        }
                    }
                };
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Submitting " + pipeline.getOperation().getSimpleName() + " request on node " + node.getId()));
                }
                NonblockingStore store = this.nonblockingStores.get(node.getId());
                store.submitPutRequest((ByteArray)this.key, versionedCopy, this.transforms, callback, this.timeoutMs);
            }
            try {
                long ellapsedNs = System.nanoTime() - ((PutPipelineData)this.pipelineData).getStartTimeNs();
                long remainingNs = this.timeoutMs * 1000000L - ellapsedNs;
                if (remainingNs > 0L) {
                    blocksLatch.await(remainingNs, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException e) {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block30;
                this.logger.warn((Object)e, (Throwable)e);
            }
        }
        for (Map.Entry responseEntry : responses.entrySet()) {
            Response response = (Response)responseEntry.getValue();
            if (response.getValue() instanceof Exception) {
                if (response.getValue() instanceof ObsoleteVersionException) {
                    responses.remove(responseEntry.getKey());
                    continue;
                }
                if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                return;
            }
            ((PutPipelineData)this.pipelineData).incrementSuccesses();
            this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
            ((PutPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
            responses.remove(responseEntry.getKey());
        }
        boolean quorumSatisfied = true;
        if (((PutPipelineData)this.pipelineData).getSuccesses() < this.required) {
            long ellapsedNs = System.nanoTime() - ((PutPipelineData)this.pipelineData).getStartTimeNs();
            long remainingNs = this.timeoutMs * 1000000L - ellapsedNs;
            if (remainingNs > 0L) {
                block31: {
                    try {
                        attemptsLatch.await(remainingNs, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException e) {
                        if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block31;
                        this.logger.warn((Object)e, (Throwable)e);
                    }
                }
                for (Map.Entry responseEntry : responses.entrySet()) {
                    Response response = (Response)responseEntry.getValue();
                    if (response.getValue() instanceof Exception) {
                        if (response.getValue() instanceof ObsoleteVersionException) {
                            responses.remove(responseEntry.getKey());
                            continue;
                        }
                        if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                        return;
                    }
                    ((PutPipelineData)this.pipelineData).incrementSuccesses();
                    this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
                    ((PutPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
                    responses.remove(responseEntry.getKey());
                }
            }
            if (((PutPipelineData)this.pipelineData).getSuccesses() < this.required) {
                ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientOperationalNodesException(this.required + " " + pipeline.getOperation().getSimpleName() + "s required, but only " + ((PutPipelineData)this.pipelineData).getSuccesses() + " succeeded", new ArrayList<Node>(((PutPipelineData)this.pipelineData).getReplicationSet()), new ArrayList<Node>(((PutPipelineData)this.pipelineData).getNodes()), new ArrayList<Node>(((PutPipelineData)this.pipelineData).getFailedNodes()), ((PutPipelineData)this.pipelineData).getFailures()));
                pipeline.abort();
                quorumSatisfied = false;
            }
        }
        if (quorumSatisfied) {
            if (((PutPipelineData)this.pipelineData).getZonesRequired() != null) {
                int zonesSatisfied = ((PutPipelineData)this.pipelineData).getZoneResponses().size();
                if (zonesSatisfied >= ((PutPipelineData)this.pipelineData).getZonesRequired() + 1) {
                    pipeline.addEvent(this.completeEvent);
                } else {
                    long timeMs = (System.nanoTime() - ((PutPipelineData)this.pipelineData).getStartTimeNs()) / 1000000L;
                    if (this.timeoutMs - timeMs > 0L) {
                        block32: {
                            try {
                                attemptsLatch.await(this.timeoutMs - timeMs, TimeUnit.MILLISECONDS);
                            }
                            catch (InterruptedException e) {
                                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block32;
                                this.logger.warn((Object)e, (Throwable)e);
                            }
                        }
                        for (Map.Entry responseEntry : responses.entrySet()) {
                            Response response = (Response)responseEntry.getValue();
                            if (response.getValue() instanceof Exception) {
                                if (!this.handleResponseError(response, pipeline, this.failureDetector)) continue;
                                return;
                            }
                            ((PutPipelineData)this.pipelineData).incrementSuccesses();
                            this.failureDetector.recordSuccess(response.getNode(), response.getRequestTime());
                            ((PutPipelineData)this.pipelineData).getZoneResponses().add(response.getNode().getZoneId());
                            responses.remove(responseEntry.getKey());
                        }
                    }
                    if (((PutPipelineData)this.pipelineData).getZoneResponses().size() >= ((PutPipelineData)this.pipelineData).getZonesRequired() + 1) {
                        pipeline.addEvent(this.completeEvent);
                    } else {
                        ((PutPipelineData)this.pipelineData).setFatalError(new InsufficientZoneResponsesException(((PutPipelineData)this.pipelineData).getZonesRequired() + 1 + " " + pipeline.getOperation().getSimpleName() + "s required zone, but only " + zonesSatisfied + " succeeded. Failing nodes : " + ((PutPipelineData)this.pipelineData).getFailedNodes()));
                        pipeline.abort();
                    }
                }
            } else {
                pipeline.addEvent(this.completeEvent);
            }
        }
    }
}

