/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.EnumMap;
import java.util.Map;
import voldemort.cluster.Cluster;
import voldemort.store.stats.ClusterWideCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlopStats {
    private final Map<Tracked, ClusterWideCounter> counters = new EnumMap<Tracked, ClusterWideCounter>(Tracked.class);

    public SlopStats(Cluster cluster) {
        for (Tracked slopCounter : Tracked.values()) {
            this.counters.put(slopCounter, new ClusterWideCounter(cluster));
        }
    }

    public Map<Integer, Long> asMap(Tracked metric) {
        return this.counters.get((Object)metric).asMap();
    }

    public Map<Integer, Long> byZone(Tracked metric) {
        return this.counters.get((Object)metric).byZone();
    }

    public Long getCount(Tracked metric, int nodeId) {
        return this.counters.get((Object)metric).getCount(nodeId);
    }

    public Long getTotalCount(Tracked metric) {
        return this.counters.get((Object)metric).getTotalCount();
    }

    public void clearCount(Tracked metric) {
        this.counters.get((Object)metric).clearCount();
    }

    public void clearCount(Tracked metric, int nodeId) {
        this.counters.get((Object)metric).clearCount(nodeId);
    }

    public void incrementCount(Tracked metric, int nodeId) {
        this.counters.get((Object)metric).incrementCount(nodeId);
    }

    public void setCount(Tracked metric, int nodeId, Long value) {
        this.counters.get((Object)metric).setCount(nodeId, value);
    }

    public void setAll(Tracked metric, Map<Integer, Long> newValues) {
        this.counters.get((Object)metric).setAll(newValues);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tracked {
        OUTSTANDING("outstanding");

        private final String name;

        private Tracked(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

