/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingStore<K, V, T>
implements Store<K, V, T> {
    private final Store<K, V, T> innerStore;

    public DelegatingStore(Store<K, V, T> innerStore) {
        this.innerStore = Utils.notNull(innerStore);
    }

    @Override
    public void close() throws VoldemortException {
        this.innerStore.close();
    }

    @Override
    public boolean delete(K key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.innerStore.delete(key, version);
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys, Map<K, T> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        return this.innerStore.getAll(keys, transforms);
    }

    @Override
    public List<Versioned<V>> get(K key, T transform) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        return this.innerStore.get(key, transform);
    }

    @Override
    public String getName() {
        return this.innerStore.getName();
    }

    @Override
    public void put(K key, Versioned<V> value, T transform) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        this.innerStore.put(key, value, transform);
    }

    public Store<K, V, T> getInnerStore() {
        return this.innerStore;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        return this.innerStore.getCapability(capability);
    }

    public String toString() {
        return this.innerStore.toString();
    }

    @Override
    public List<Version> getVersions(K key) {
        return this.innerStore.getVersions(key);
    }
}

