/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.store.InsufficientOperationalNodesException;
import voldemort.store.InsufficientZoneResponsesException;
import voldemort.store.InvalidMetadataException;
import voldemort.store.StoreTimeoutException;
import voldemort.store.UnreachableStoreException;
import voldemort.versioning.ObsoleteVersionException;

public class PipelineRoutedStats {
    private ConcurrentHashMap<Class<? extends Exception>, AtomicLong> errCountMap = new ConcurrentHashMap();
    private AtomicLong severeExceptionCount;
    private AtomicLong benignExceptionCount;

    PipelineRoutedStats() {
        this.errCountMap.put(InvalidMetadataException.class, new AtomicLong(0L));
        this.errCountMap.put(InsufficientOperationalNodesException.class, new AtomicLong(0L));
        this.errCountMap.put(InsufficientZoneResponsesException.class, new AtomicLong(0L));
        this.errCountMap.put(UnreachableStoreException.class, new AtomicLong(0L));
        this.errCountMap.put(StoreTimeoutException.class, new AtomicLong(0L));
        this.errCountMap.put(ObsoleteVersionException.class, new AtomicLong(0L));
        this.severeExceptionCount = new AtomicLong(0L);
        this.benignExceptionCount = new AtomicLong(0L);
    }

    @JmxGetter(name="numSevereExceptions", description="Number of exceptions considered serious errors")
    public long getNumSevereExceptions() {
        return this.severeExceptionCount.get();
    }

    @JmxGetter(name="numBenignExceptions", description="Number of exceptions considered benign")
    public long getNumBenignExceptions() {
        return this.benignExceptionCount.get();
    }

    @JmxGetter(name="numInsufficientOperationalNodesExceptions", description="Number of client operations failed due to sufficient nodes not being up")
    public long getNumInsufficientOperationalNodesExceptions() {
        return this.errCountMap.get(InsufficientOperationalNodesException.class).get();
    }

    @JmxGetter(name="numInsufficientZoneResponsesExceptions", description="Number of client operations failed due to sufficient nodes not up across zones")
    public long getNumInsufficientZoneResponsesExceptions() {
        return this.errCountMap.get(InsufficientZoneResponsesException.class).get();
    }

    @JmxGetter(name="numInvalidMetadataExceptions", description="Number of times the metadata was invalid at the client")
    public long getNumInvalidMetadataExceptions() {
        return this.errCountMap.get(InvalidMetadataException.class).get();
    }

    @JmxGetter(name="numUnreachableStoreExceptions", description="Number of requests incomplete since some server could not be reached")
    public long getNumUnreachableStoreExceptions() {
        return this.errCountMap.get(UnreachableStoreException.class).get();
    }

    @JmxGetter(name="numStoreTimeoutExceptions", description="Number of requests timed out since some server was overloaded/unavailable")
    public long getNumStoreTimeoutExceptions() {
        return this.errCountMap.get(StoreTimeoutException.class).get();
    }

    @JmxGetter(name="numObsoleteVersionExceptions", description="Number of requests that got a ObsoleteVersionException as response")
    public long getNumObsoleteVersionExceptions() {
        return this.errCountMap.get(ObsoleteVersionException.class).get();
    }

    @JmxGetter(name="getExceptionCountsAsString", description="Returns counts of all the Exceptions seen so far as a string")
    public String getExceptionCountsAsString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Class<? extends Exception>, AtomicLong> pair : this.errCountMap.entrySet()) {
            result.append(pair.getKey().getName() + ":" + pair.getValue().get() + "\n");
        }
        return result.toString();
    }

    public void reportException(Exception e) {
        if (this.isSevere(e)) {
            this.severeExceptionCount.incrementAndGet();
        } else {
            this.benignExceptionCount.incrementAndGet();
        }
        this.errCountMap.putIfAbsent(e.getClass(), new AtomicLong(0L));
        this.errCountMap.get(e.getClass()).incrementAndGet();
    }

    private boolean isSevere(Exception ve) {
        return ve instanceof InsufficientOperationalNodesException || ve instanceof InsufficientZoneResponsesException || ve instanceof InvalidMetadataException;
    }
}

