/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import voldemort.store.stats.RequestCounter;
import voldemort.store.stats.Tracked;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreStats {
    private final StoreStats parent;
    private final Map<Tracked, RequestCounter> counters = new EnumMap<Tracked, RequestCounter>(Tracked.class);

    public StoreStats() {
        this(null);
    }

    public StoreStats(StoreStats parent) {
        for (Tracked tracked : Tracked.values()) {
            this.counters.put(tracked, new RequestCounter(300000, true));
        }
        this.parent = parent;
    }

    public void recordTime(Tracked op, long timeNS) {
        this.recordTime(op, timeNS, 0L, 0L, 0L);
    }

    public void recordPutTimeAndSize(long timeNS, long size) {
        this.recordTime(Tracked.PUT, timeNS, 0L, size, 0L);
    }

    public void recordGetTime(long timeNS, boolean emptyResponse, long totalBytes) {
        this.recordTime(Tracked.GET, timeNS, emptyResponse ? 1L : 0L, totalBytes, 0L);
    }

    public void recordGetAllTime(long timeNS, int requested, int returned, long totalBytes) {
        this.recordTime(Tracked.GET_ALL, timeNS, requested - returned, totalBytes, requested);
    }

    private void recordTime(Tracked op, long timeNS, long numEmptyResponses, long size, long getAllAggregateRequests) {
        this.counters.get((Object)op).addRequest(timeNS, numEmptyResponses, size, getAllAggregateRequests);
        if (this.parent != null) {
            this.parent.recordTime(op, timeNS, numEmptyResponses, size, getAllAggregateRequests);
        }
    }

    public long getCount(Tracked op) {
        return this.counters.get((Object)op).getCount();
    }

    public float getThroughput(Tracked op) {
        return this.counters.get((Object)op).getThroughput();
    }

    public float getThroughputInBytes(Tracked op) {
        return this.counters.get((Object)op).getThroughputInBytes();
    }

    public double getAvgTimeInMs(Tracked op) {
        return this.counters.get((Object)op).getAverageTimeInMs();
    }

    public long getNumEmptyResponses(Tracked op) {
        return this.counters.get((Object)op).getNumEmptyResponses();
    }

    public long getMaxLatencyInMs(Tracked op) {
        return this.counters.get((Object)op).getMaxLatencyInMs();
    }

    public long getQ95LatencyInMs(Tracked op) {
        return this.counters.get((Object)op).getQ95LatencyMs();
    }

    public long getQ99LatencyInMs(Tracked op) {
        return this.counters.get((Object)op).getQ99LatencyMs();
    }

    public Map<Tracked, RequestCounter> getCounters() {
        return Collections.unmodifiableMap(this.counters);
    }

    public long getMaxSizeInBytes(Tracked op) {
        return this.counters.get((Object)op).getMaxSizeInBytes();
    }

    public double getAvgSizeinBytes(Tracked op) {
        return this.counters.get((Object)op).getAverageSizeInBytes();
    }

    public double getGetAllAverageCount() {
        long total = this.getGetAllAggregatedCount();
        return total == 0L ? 0.0 : (double)(total / this.counters.get((Object)Tracked.GET_ALL).getCount());
    }

    public long getGetAllAggregatedCount() {
        return this.counters.get((Object)Tracked.GET_ALL).getGetAllAggregatedCount();
    }

    public long getGetAllMaxCount() {
        return this.counters.get((Object)Tracked.GET_ALL).getGetAllMaxCount();
    }
}

