/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import org.apache.log4j.Logger;

public class DynamicThrottleLimit {
    private long perNodeRate = 0L;
    private long dynamicRatePerSecond = 0L;
    private int numJobs = 0;
    private static final Logger logger = Logger.getLogger(DynamicThrottleLimit.class);

    public DynamicThrottleLimit(long val) {
        this.dynamicRatePerSecond = this.perNodeRate = val;
    }

    public synchronized long getRate() {
        return this.dynamicRatePerSecond;
    }

    public synchronized void incrementNumJobs() {
        ++this.numJobs;
        this.dynamicRatePerSecond = this.numJobs > 0 ? this.perNodeRate / (long)this.numJobs : this.perNodeRate;
        logger.debug((Object)("# Jobs = " + this.numJobs + ". Updating throttling rate to : " + this.dynamicRatePerSecond + " bytes / sec"));
    }

    public synchronized void decrementNumJobs() {
        if (this.numJobs > 0) {
            --this.numJobs;
        }
        this.dynamicRatePerSecond = this.numJobs > 0 ? this.perNodeRate / (long)this.numJobs : this.perNodeRate;
        logger.debug((Object)("# Jobs = " + this.numJobs + ". Updating throttling rate to : " + this.dynamicRatePerSecond + " bytes / sec"));
    }

    public synchronized long getSpeculativeRate() {
        long dynamicRate = 0L;
        int totalJobs = this.numJobs + 1;
        dynamicRate = totalJobs > 0 ? this.perNodeRate / (long)totalJobs : this.perNodeRate;
        return dynamicRate;
    }
}

