/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import java.io.Serializable;
import voldemort.annotations.concurrency.NotThreadsafe;

@NotThreadsafe
public final class ClockEntry
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short nodeId;
    private final long version;

    public ClockEntry(short nodeId, long version) {
        if (nodeId < 0) {
            throw new IllegalArgumentException("Node id " + nodeId + " is not in the range (0, " + Short.MAX_VALUE + ").");
        }
        if (version < 1L) {
            throw new IllegalArgumentException("Version " + version + " is not in the range (1, " + Short.MAX_VALUE + ").");
        }
        this.nodeId = nodeId;
        this.version = version;
    }

    public ClockEntry clone() {
        try {
            return (ClockEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public short getNodeId() {
        return this.nodeId;
    }

    public long getVersion() {
        return this.version;
    }

    public ClockEntry incremented() {
        return new ClockEntry(this.nodeId, this.version + 1L);
    }

    public int hashCode() {
        return this.nodeId + ((int)this.version << 16);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(ClockEntry.class)) {
            ClockEntry v = (ClockEntry)o;
            return v.getNodeId() == this.getNodeId() && v.getVersion() == this.getVersion();
        }
        return false;
    }

    public String toString() {
        return this.nodeId + ":" + this.version;
    }
}

