/*
 * Decompiled with CFR 0.152.
 */
package voldemort.cluster;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.cluster.Node;
import voldemort.cluster.Zone;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="Metadata about the physical servers on which the Voldemort cluster runs")
@Threadsafe
public class Cluster
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int numberOfTags;
    private final Map<Integer, Node> nodesById;
    private final Map<Integer, Zone> zonesById;

    public Cluster(String name, List<Node> nodes) {
        this(name, nodes, new ArrayList<Zone>());
    }

    public Cluster(String name, List<Node> nodes, List<Zone> zones) {
        this.name = Utils.notNull(name);
        if (zones.size() != 0) {
            this.zonesById = new LinkedHashMap<Integer, Zone>(zones.size());
            for (Zone zone : zones) {
                if (this.zonesById.containsKey(zone.getId())) {
                    throw new IllegalArgumentException("Zone id " + zone.getId() + " appears twice in the zone list.");
                }
                this.zonesById.put(zone.getId(), zone);
            }
        } else {
            this.zonesById = new LinkedHashMap<Integer, Zone>(1);
            this.zonesById.put(0, new Zone());
        }
        this.nodesById = new LinkedHashMap<Integer, Node>(nodes.size());
        for (Node node : nodes) {
            if (this.nodesById.containsKey(node.getId())) {
                throw new IllegalArgumentException("Node id " + node.getId() + " appears twice in the node list.");
            }
            this.nodesById.put(node.getId(), node);
        }
        this.numberOfTags = this.getNumberOfTags(nodes);
    }

    private int getNumberOfTags(List<Node> nodes) {
        ArrayList<Integer> tags = new ArrayList<Integer>();
        for (Node node : nodes) {
            tags.addAll(node.getPartitionIds());
        }
        Collections.sort(tags);
        for (int i = 0; i < this.numberOfTags; ++i) {
            if ((Integer)tags.get(i) == i) continue;
            throw new IllegalArgumentException("Invalid tag assignment.");
        }
        return tags.size();
    }

    @JmxGetter(name="name", description="The name of the cluster")
    public String getName() {
        return this.name;
    }

    public Collection<Node> getNodes() {
        return this.nodesById.values();
    }

    public Collection<Zone> getZones() {
        return this.zonesById.values();
    }

    public Zone getZoneById(int id) {
        Zone zone = this.zonesById.get(id);
        if (zone == null) {
            if (id == 0) {
                throw new VoldemortException("Incorrect configuration. Default zone ID:" + id + " required but not specified.");
            }
            throw new VoldemortException("No such zone in cluster: " + id + " Available zones : " + this.displayZones());
        }
        return zone;
    }

    private String displayZones() {
        String zoneIDS = "{";
        for (Zone z : this.getZones()) {
            if (zoneIDS.length() != 1) {
                zoneIDS = zoneIDS + ",";
            }
            zoneIDS = zoneIDS + z.getId();
        }
        zoneIDS = zoneIDS + "}";
        return zoneIDS;
    }

    public int getNumberOfZones() {
        return this.zonesById.size();
    }

    public Node getNodeById(int id) {
        Node node = this.nodesById.get(id);
        if (node == null) {
            throw new VoldemortException("No such node in cluster: " + id);
        }
        return node;
    }

    @JmxGetter(name="numberOfNodes", description="The number of nodes in the cluster.")
    public int getNumberOfNodes() {
        return this.nodesById.size();
    }

    public int getNumberOfPartitions() {
        return this.numberOfTags;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Cluster('");
        builder.append(this.getName());
        builder.append("', [");
        for (Node n : this.getNodes()) {
            builder.append(n.toString());
            builder.append('\n');
        }
        builder.append("])");
        return builder.toString();
    }

    public String toString(boolean isDetailed) {
        if (!isDetailed) {
            return this.toString();
        }
        StringBuilder builder = new StringBuilder("Cluster [" + this.getName() + "] Nodes [" + this.getNumberOfNodes() + "] Zones [" + this.getNumberOfZones() + "] Partitions [" + this.getNumberOfPartitions() + "]");
        builder.append(" Zone Info [" + this.getZones() + "]");
        builder.append(" Node Info [" + this.getNodes() + "]");
        return builder.toString();
    }

    public boolean equals(Object second) {
        if (this == second) {
            return true;
        }
        if (second == null || second.getClass() != this.getClass()) {
            return false;
        }
        Cluster secondCluster = (Cluster)second;
        if (this.getZones().size() != secondCluster.getZones().size()) {
            return false;
        }
        if (this.getNodes().size() != secondCluster.getNodes().size()) {
            return false;
        }
        for (Zone zoneA : this.getZones()) {
            Zone zoneB;
            try {
                zoneB = secondCluster.getZoneById(zoneA.getId());
            }
            catch (VoldemortException e) {
                return false;
            }
            if (zoneB == null || zoneB.getProximityList().size() != zoneA.getProximityList().size()) {
                return false;
            }
            for (int index = 0; index < zoneA.getProximityList().size(); ++index) {
                if (zoneA.getProximityList().get(index) == zoneB.getProximityList().get(index)) continue;
                return false;
            }
        }
        for (Node nodeA : this.getNodes()) {
            Node nodeB;
            try {
                nodeB = secondCluster.getNodeById(nodeA.getId());
            }
            catch (VoldemortException e) {
                return false;
            }
            if (nodeA.getNumberOfPartitions() != nodeB.getNumberOfPartitions()) {
                return false;
            }
            if (nodeA.getZoneId() != nodeB.getZoneId()) {
                return false;
            }
            if (Sets.newHashSet(nodeA.getPartitionIds()).equals(Sets.newHashSet(nodeB.getPartitionIds()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hc = this.getNodes().size();
        for (Node node : this.getNodes()) {
            hc ^= node.getHost().hashCode();
        }
        return hc;
    }
}

