/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.routed.action;

import voldemort.store.routed.Pipeline;
import voldemort.store.routed.PutPipelineData;
import voldemort.store.routed.action.AbstractAction;
import voldemort.utils.ByteArray;
import voldemort.utils.Time;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementClock
extends AbstractAction<ByteArray, Void, PutPipelineData> {
    private final Versioned<byte[]> versioned;
    private final Time time;

    public IncrementClock(PutPipelineData pipelineData, Pipeline.Event completeEvent, Versioned<byte[]> versioned, Time time) {
        super(pipelineData, completeEvent);
        this.versioned = versioned;
        this.time = time;
    }

    @Override
    public void execute(Pipeline pipeline) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pipeline.getOperation().getSimpleName() + " versioning data - was: " + this.versioned.getVersion()));
        }
        VectorClock versionedClock = (VectorClock)this.versioned.getVersion();
        versionedClock.incrementVersion(((PutPipelineData)this.pipelineData).getMaster().getId(), this.time.getMilliseconds());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(pipeline.getOperation().getSimpleName() + " versioned data - now: " + this.versioned.getVersion()));
        }
        pipeline.addEvent(this.completeEvent);
    }
}

