/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxSetter;
import voldemort.store.stats.ClientSocketStats;

@JmxManaged(description="Voldemort socket pool.")
public class ClientSocketStatsJmx {
    private final ClientSocketStats stats;

    public ClientSocketStatsJmx(ClientSocketStats stats) {
        this.stats = stats;
    }

    @JmxGetter(name="socketsCreated", description="Number of sockets created.")
    public int getConnectionsCreated() {
        return this.stats.getConnectionsCreated();
    }

    @JmxGetter(name="socketsDestroyed", description="Number of sockets destroyed.")
    public int getConnectionsDestroyed() {
        return this.stats.getConnectionsDestroyed();
    }

    @JmxGetter(name="socketsCheckedout", description="Number of sockets checked out.")
    public int getConnectionsCheckinout() {
        return this.stats.getConnectionsCheckedout();
    }

    @JmxGetter(name="waitMsAverage", description="Average ms to wait to get a socket.")
    public double getWaitMsAverage() {
        return (double)this.stats.getAveWaitUs() / 1000.0;
    }

    @JmxGetter(name="waitMsQ50th", description="50th percentile wait time to get a connection.")
    public double getWaitMsQ50th() {
        return (double)this.stats.getWaitHistogram().getQuantile(0.5) / 1000.0;
    }

    @JmxGetter(name="waitMsQ99th", description="99th percentile wait time to get a connection.")
    public double getWaitMsQ99th() {
        return (double)this.stats.getWaitHistogram().getQuantile(0.99) / 1000.0;
    }

    @JmxGetter(name="socketsActive", description="Total number of sockets, checkedin and checkout.")
    public int getConnActive() {
        int result = -1;
        try {
            result = this.stats.getConnectionsActive(this.stats.getDestination());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @JmxGetter(name="socketsInPool", description="Total number of sockets in the pool.")
    public int getConnAvailable() {
        int result = -1;
        try {
            result = this.stats.getConnectionsInPool(this.stats.getDestination());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @JmxGetter(name="monitoringInterval", description="The number of checkouts over which performance statics are calculated.")
    public int getMonitoringInterval() {
        return this.stats.getMonitoringInterval();
    }

    @JmxSetter(name="monitoringInterval", description="The number of checkouts over which performance statics are calculated.")
    public void setMonitoringInterval(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Monitoring interval must be a positive number.");
        }
        this.stats.setMonitoringInterval(count);
    }
}

