/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.generic;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryData;
import org.apache.avro.util.Utf8;

public class GenericData {
    private static final GenericData INSTANCE = new GenericData();

    public static GenericData get() {
        return INSTANCE;
    }

    protected GenericData() {
    }

    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!(datum instanceof IndexedRecord)) {
                    return false;
                }
                IndexedRecord fields = (IndexedRecord)datum;
                for (Schema.Field f : schema.getFields()) {
                    if (this.validate(f.schema(), fields.get(f.pos()))) continue;
                    return false;
                }
                return true;
            }
            case ENUM: {
                return schema.getEnumSymbols().contains(datum.toString());
            }
            case ARRAY: {
                if (!(datum instanceof Collection)) {
                    return false;
                }
                for (Object element : (Collection)datum) {
                    if (this.validate(schema.getElementType(), element)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                if (!(datum instanceof Map)) {
                    return false;
                }
                Map map = (Map)datum;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.validate(schema.getValueType(), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                for (Schema type : schema.getTypes()) {
                    if (!this.validate(type, datum)) continue;
                    return true;
                }
                return false;
            }
            case FIXED: {
                return datum instanceof GenericFixed && ((GenericFixed)datum).bytes().length == schema.getFixedSize();
            }
            case STRING: {
                return this.isString(datum);
            }
            case BYTES: {
                return this.isBytes(datum);
            }
            case INT: {
                return datum instanceof Integer;
            }
            case LONG: {
                return datum instanceof Long;
            }
            case FLOAT: {
                return datum instanceof Float;
            }
            case DOUBLE: {
                return datum instanceof Double;
            }
            case BOOLEAN: {
                return datum instanceof Boolean;
            }
            case NULL: {
                return datum == null;
            }
        }
        return false;
    }

    public String toString(Object datum) {
        StringBuilder buffer = new StringBuilder();
        this.toString(datum, buffer);
        return buffer.toString();
    }

    protected void toString(Object datum, StringBuilder buffer) {
        if (datum instanceof IndexedRecord) {
            buffer.append("{");
            int count = 0;
            IndexedRecord record = (IndexedRecord)datum;
            for (Schema.Field f : record.getSchema().getFields()) {
                this.toString(f.name(), buffer);
                buffer.append(": ");
                this.toString(record.get(f.pos()), buffer);
                if (++count >= record.getSchema().getFields().size()) continue;
                buffer.append(", ");
            }
            buffer.append("}");
        } else if (datum instanceof Collection) {
            Collection array = (Collection)datum;
            buffer.append("[");
            long last = array.size() - 1;
            int i = 0;
            for (Object element : array) {
                this.toString(element, buffer);
                if ((long)i++ >= last) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        } else if (datum instanceof Map) {
            buffer.append("{");
            int count = 0;
            Map map = (Map)datum;
            for (Map.Entry entry : map.entrySet()) {
                this.toString(entry.getKey(), buffer);
                buffer.append(": ");
                this.toString(entry.getValue(), buffer);
                if (++count >= map.size()) continue;
                buffer.append(", ");
            }
            buffer.append("}");
        } else if (datum instanceof CharSequence) {
            buffer.append("\"");
            buffer.append(datum);
            buffer.append("\"");
        } else if (datum instanceof ByteBuffer) {
            buffer.append("{\"bytes\": \"");
            ByteBuffer bytes = (ByteBuffer)datum;
            for (int i = bytes.position(); i < bytes.limit(); ++i) {
                buffer.append((char)bytes.get(i));
            }
            buffer.append("\"}");
        } else {
            buffer.append(datum);
        }
    }

    public Schema induce(Object datum) {
        if (datum instanceof IndexedRecord) {
            return ((IndexedRecord)datum).getSchema();
        }
        if (datum instanceof Collection) {
            Schema elementType = null;
            for (Object element : (Collection)datum) {
                if (elementType == null) {
                    elementType = this.induce(element);
                    continue;
                }
                if (elementType.equals(this.induce(element))) continue;
                throw new AvroTypeException("No mixed type arrays.");
            }
            if (elementType == null) {
                throw new AvroTypeException("Empty array: " + datum);
            }
            return Schema.createArray(elementType);
        }
        if (datum instanceof Map) {
            Map map = (Map)datum;
            Schema value = null;
            for (Map.Entry entry : map.entrySet()) {
                if (value == null) {
                    value = this.induce(entry.getValue());
                    continue;
                }
                if (value.equals(this.induce(entry.getValue()))) continue;
                throw new AvroTypeException("No mixed type map values.");
            }
            if (value == null) {
                throw new AvroTypeException("Empty map: " + datum);
            }
            return Schema.createMap(value);
        }
        if (datum instanceof GenericFixed) {
            return Schema.createFixed(null, null, null, ((GenericFixed)datum).bytes().length);
        }
        if (datum instanceof CharSequence) {
            return Schema.create(Schema.Type.STRING);
        }
        if (datum instanceof ByteBuffer) {
            return Schema.create(Schema.Type.BYTES);
        }
        if (datum instanceof Integer) {
            return Schema.create(Schema.Type.INT);
        }
        if (datum instanceof Long) {
            return Schema.create(Schema.Type.LONG);
        }
        if (datum instanceof Float) {
            return Schema.create(Schema.Type.FLOAT);
        }
        if (datum instanceof Double) {
            return Schema.create(Schema.Type.DOUBLE);
        }
        if (datum instanceof Boolean) {
            return Schema.create(Schema.Type.BOOLEAN);
        }
        if (datum == null) {
            return Schema.create(Schema.Type.NULL);
        }
        throw new AvroTypeException("Can't create schema for: " + datum);
    }

    public int resolveUnion(Schema union, Object datum) {
        int i = 0;
        for (Schema type : union.getTypes()) {
            if (this.instanceOf(type, datum)) {
                return i;
            }
            ++i;
        }
        throw new AvroRuntimeException("Not in union " + union + ": " + datum);
    }

    protected boolean instanceOf(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!this.isRecord(datum)) {
                    return false;
                }
                return schema.getName() == null || schema.getName().equals(this.getRecordSchema(datum).getName());
            }
            case ENUM: {
                return this.isEnum(datum);
            }
            case ARRAY: {
                return this.isArray(datum);
            }
            case MAP: {
                return this.isMap(datum);
            }
            case FIXED: {
                return this.isFixed(datum);
            }
            case STRING: {
                return this.isString(datum);
            }
            case BYTES: {
                return this.isBytes(datum);
            }
            case INT: {
                return datum instanceof Integer;
            }
            case LONG: {
                return datum instanceof Long;
            }
            case FLOAT: {
                return datum instanceof Float;
            }
            case DOUBLE: {
                return datum instanceof Double;
            }
            case BOOLEAN: {
                return datum instanceof Boolean;
            }
            case NULL: {
                return datum == null;
            }
        }
        throw new AvroRuntimeException("Unexpected type: " + schema);
    }

    protected boolean isArray(Object datum) {
        return datum instanceof Collection;
    }

    protected boolean isRecord(Object datum) {
        return datum instanceof IndexedRecord;
    }

    protected Schema getRecordSchema(Object record) {
        return ((GenericContainer)record).getSchema();
    }

    protected boolean isEnum(Object datum) {
        return datum instanceof GenericEnumSymbol;
    }

    protected boolean isMap(Object datum) {
        return datum instanceof Map;
    }

    protected boolean isFixed(Object datum) {
        return datum instanceof GenericFixed;
    }

    protected boolean isString(Object datum) {
        return datum instanceof CharSequence;
    }

    protected boolean isBytes(Object datum) {
        return datum instanceof ByteBuffer;
    }

    public int hashCode(Object o, Schema s) {
        if (o == null) {
            return 0;
        }
        int hashCode = 1;
        switch (s.getType()) {
            case RECORD: {
                IndexedRecord r = (IndexedRecord)o;
                for (Schema.Field f : s.getFields()) {
                    if (f.order() == Schema.Field.Order.IGNORE) continue;
                    hashCode = this.hashCodeAdd(hashCode, r.get(f.pos()), f.schema());
                }
                return hashCode;
            }
            case ARRAY: {
                Collection a = (Collection)o;
                Schema elementType = s.getElementType();
                for (Object e : a) {
                    hashCode = this.hashCodeAdd(hashCode, e, elementType);
                }
                return hashCode;
            }
            case UNION: {
                return this.hashCode(o, s.getTypes().get(this.resolveUnion(s, o)));
            }
            case ENUM: {
                return s.getEnumOrdinal(o.toString());
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                return (o instanceof Utf8 ? o : new Utf8(o.toString())).hashCode();
            }
        }
        return o.hashCode();
    }

    protected int hashCodeAdd(int hashCode, Object o, Schema s) {
        return 31 * hashCode + this.hashCode(o, s);
    }

    public int compare(Object o1, Object o2, Schema s) {
        if (o1 == o2) {
            return 0;
        }
        switch (s.getType()) {
            case RECORD: {
                if (!(o1 instanceof IndexedRecord)) {
                    return ((Comparable)o1).compareTo(o2);
                }
                IndexedRecord r1 = (IndexedRecord)o1;
                IndexedRecord r2 = (IndexedRecord)o2;
                for (Schema.Field f : s.getFields()) {
                    int pos;
                    int compare;
                    if (f.order() == Schema.Field.Order.IGNORE || (compare = this.compare(r1.get(pos = f.pos()), r2.get(pos), f.schema())) == 0) continue;
                    return f.order() == Schema.Field.Order.DESCENDING ? -compare : compare;
                }
                return 0;
            }
            case ENUM: {
                return s.getEnumOrdinal(o1.toString()) - s.getEnumOrdinal(o2.toString());
            }
            case ARRAY: {
                Collection a1 = (Collection)o1;
                Collection a2 = (Collection)o2;
                Iterator e1 = a1.iterator();
                Iterator e2 = a2.iterator();
                Schema elementType = s.getElementType();
                while (e1.hasNext() && e2.hasNext()) {
                    int compare = this.compare(e1.next(), e2.next(), elementType);
                    if (compare == 0) continue;
                    return compare;
                }
                return e1.hasNext() ? 1 : (e2.hasNext() ? -1 : 0);
            }
            case MAP: {
                throw new AvroRuntimeException("Can't compare maps!");
            }
            case UNION: {
                int i1 = this.resolveUnion(s, o1);
                int i2 = this.resolveUnion(s, o2);
                return i1 == i2 ? this.compare(o1, o2, s.getTypes().get(i1)) : i1 - i2;
            }
            case NULL: {
                return 0;
            }
            case STRING: {
                Utf8 u1 = o1 instanceof Utf8 ? (Utf8)o1 : new Utf8(o1.toString());
                Utf8 u2 = o2 instanceof Utf8 ? (Utf8)o2 : new Utf8(o2.toString());
                return u1.compareTo(u2);
            }
        }
        return ((Comparable)o1).compareTo(o2);
    }

    public static class EnumSymbol
    implements GenericEnumSymbol {
        private String symbol;

        public EnumSymbol(String symbol) {
            this.symbol = symbol;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GenericEnumSymbol && this.symbol.equals(o.toString());
        }

        public int hashCode() {
            return this.symbol.hashCode();
        }

        @Override
        public String toString() {
            return this.symbol;
        }
    }

    public static class Fixed
    implements GenericFixed,
    Comparable<Fixed> {
        private byte[] bytes;

        public Fixed(Schema schema) {
            this.bytes(new byte[schema.getFixedSize()]);
        }

        public Fixed(byte[] bytes) {
            this.bytes(bytes);
        }

        protected Fixed() {
        }

        public void bytes(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte[] bytes() {
            return this.bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof GenericFixed && Arrays.equals(this.bytes, ((GenericFixed)o).bytes());
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public String toString() {
            return Arrays.toString(this.bytes);
        }

        @Override
        public int compareTo(Fixed that) {
            return BinaryData.compareBytes(this.bytes, 0, this.bytes.length, that.bytes, 0, that.bytes.length);
        }
    }

    public static class Array<T>
    extends AbstractList<T>
    implements GenericArray<T>,
    Comparable<GenericArray<T>> {
        private static final Object[] EMPTY = new Object[0];
        private final Schema schema;
        private int size;
        private Object[] elements = EMPTY;

        public Array(int capacity, Schema schema) {
            if (schema == null || !Schema.Type.ARRAY.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not an array schema: " + schema);
            }
            this.schema = schema;
            if (capacity != 0) {
                this.elements = new Object[capacity];
            }
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void clear() {
            this.size = 0;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int position = 0;

                @Override
                public boolean hasNext() {
                    return this.position < Array.this.size;
                }

                @Override
                public T next() {
                    return Array.this.elements[this.position++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public T get(int i) {
            return (T)this.elements[i];
        }

        @Override
        public boolean add(T o) {
            if (this.size == this.elements.length) {
                Object[] newElements = new Object[this.size * 3 / 2 + 1];
                System.arraycopy(this.elements, 0, newElements, 0, this.size);
                this.elements = newElements;
            }
            this.elements[this.size++] = o;
            return true;
        }

        @Override
        public T peek() {
            return (T)(this.size < this.elements.length ? this.elements[this.size] : null);
        }

        @Override
        public int hashCode() {
            return GenericData.get().hashCode(this, this.schema);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Array)) {
                return false;
            }
            Array that = (Array)o;
            if (!this.schema.equals(that.schema)) {
                return false;
            }
            return this.compareTo(that) == 0;
        }

        @Override
        public int compareTo(GenericArray<T> that) {
            return GenericData.get().compare(this, that, this.getSchema());
        }

        @Override
        public void reverse() {
            int left = 0;
            for (int right = this.elements.length - 1; left < right; ++left, --right) {
                Object tmp = this.elements[left];
                this.elements[left] = this.elements[right];
                this.elements[right] = tmp;
            }
        }

        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            int count = 0;
            for (T e : this) {
                buffer.append(e == null ? "null" : e.toString());
                if (++count >= this.size()) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            return buffer.toString();
        }
    }

    public static class Record
    implements GenericRecord,
    Comparable<Record> {
        private final Schema schema;
        private final Object[] values;

        public Record(Schema schema) {
            if (schema == null || !Schema.Type.RECORD.equals((Object)schema.getType())) {
                throw new AvroRuntimeException("Not a record schema: " + schema);
            }
            this.schema = schema;
            this.values = new Object[schema.getFields().size()];
        }

        @Override
        public Schema getSchema() {
            return this.schema;
        }

        @Override
        public void put(String key, Object value) {
            this.values[this.schema.getField((String)key).pos()] = value;
        }

        @Override
        public void put(int i, Object v) {
            this.values[i] = v;
        }

        @Override
        public Object get(String key) {
            Schema.Field field = this.schema.getField(key);
            if (field == null) {
                return null;
            }
            return this.values[field.pos()];
        }

        @Override
        public Object get(int i) {
            return this.values[i];
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record that = (Record)o;
            if (!this.schema.getFullName().equals(that.schema.getFullName())) {
                return false;
            }
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return GenericData.get().hashCode(this, this.schema);
        }

        @Override
        public int compareTo(Record that) {
            return GenericData.get().compare(this, that, this.schema);
        }

        public String toString() {
            return GenericData.get().toString(this);
        }
    }
}

