/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.admin;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.admin.SocketAndStreams;
import voldemort.store.socket.SocketDestination;
import voldemort.utils.ByteUtils;
import voldemort.utils.pool.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketResourceFactory
implements ResourceFactory<SocketDestination, SocketAndStreams> {
    public static final Logger logger = Logger.getLogger(SocketResourceFactory.class);
    private final int soTimeoutMs;
    private final int socketBufferSize;
    private final AtomicInteger created;
    private final AtomicInteger destroyed;
    private final boolean socketKeepAlive;
    private final Map<SocketDestination, Long> lastClosedTimestamps;

    public SocketResourceFactory(int soTimeoutMs, int socketBufferSize) {
        this(soTimeoutMs, socketBufferSize, false);
    }

    public SocketResourceFactory(int soTimeoutMs, int socketBufferSize, boolean socketKeepAlive) {
        this.soTimeoutMs = soTimeoutMs;
        this.created = new AtomicInteger(0);
        this.destroyed = new AtomicInteger(0);
        this.socketBufferSize = socketBufferSize;
        this.socketKeepAlive = socketKeepAlive;
        this.lastClosedTimestamps = new ConcurrentHashMap<SocketDestination, Long>();
    }

    @Override
    public void destroy(SocketDestination dest, SocketAndStreams sands) throws Exception {
        sands.getSocket().close();
        int numDestroyed = this.destroyed.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Destroyed socket " + numDestroyed + " connection to " + dest.getHost() + ":" + dest.getPort()));
        }
    }

    @Override
    public SocketAndStreams create(SocketDestination dest) throws Exception {
        Socket socket = new Socket();
        socket.setReceiveBufferSize(this.socketBufferSize);
        socket.setSendBufferSize(this.socketBufferSize);
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(this.soTimeoutMs);
        socket.setKeepAlive(this.socketKeepAlive);
        socket.connect(new InetSocketAddress(dest.getHost(), dest.getPort()), this.soTimeoutMs);
        this.recordSocketCreation(dest, socket);
        SocketAndStreams sands = new SocketAndStreams(socket, dest.getRequestFormatType());
        this.negotiateProtocol(sands, dest.getRequestFormatType());
        return sands;
    }

    private void negotiateProtocol(SocketAndStreams socket, RequestFormatType type) throws IOException {
        DataOutputStream outputStream = socket.getOutputStream();
        byte[] proposal = ByteUtils.getBytes(type.getCode(), "UTF-8");
        ((OutputStream)outputStream).write(proposal);
        ((OutputStream)outputStream).flush();
        DataInputStream inputStream = socket.getInputStream();
        byte[] responseBytes = new byte[2];
        inputStream.readFully(responseBytes);
        String response = ByteUtils.getString(responseBytes, "UTF-8");
        if (response.equals("ok")) {
            return;
        }
        if (response.equals("no")) {
            throw new VoldemortException(type.getDisplayName() + " is not an acceptable protcol for the server.");
        }
        throw new VoldemortException("Unknown server response: " + response);
    }

    private void recordSocketCreation(SocketDestination dest, Socket socket) throws SocketException {
        int numCreated = this.created.incrementAndGet();
        logger.debug((Object)("Created socket " + numCreated + " for " + dest.getHost() + ":" + dest.getPort() + " using protocol " + dest.getRequestFormatType().getCode()));
        int sendBufferSize = socket.getSendBufferSize();
        int receiveBufferSize = socket.getReceiveBufferSize();
        if (receiveBufferSize != this.socketBufferSize) {
            logger.debug((Object)("Requested socket receive buffer size was " + this.socketBufferSize + " bytes but actual size is " + receiveBufferSize + " bytes."));
        }
        if (sendBufferSize != this.socketBufferSize) {
            logger.debug((Object)("Requested socket send buffer size was " + this.socketBufferSize + " bytes but actual size is " + sendBufferSize + " bytes."));
        }
    }

    @Override
    public boolean validate(SocketDestination dest, SocketAndStreams sands) {
        boolean isValid;
        long lastClosedTimestamp = this.getLastClosedTimestamp(dest);
        if (sands.getCreateTimestamp() <= lastClosedTimestamp) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Socket connection " + sands + " was created on " + new Date(sands.getCreateTimestamp() / 1000000L) + " before socket pool was closed and re-created (on " + new Date(lastClosedTimestamp / 1000000L) + ")"));
            }
            return false;
        }
        Socket s = sands.getSocket();
        boolean bl = isValid = !s.isClosed() && s.isBound() && s.isConnected();
        if (!isValid && logger.isDebugEnabled()) {
            logger.debug((Object)("Socket connection " + sands + " is no longer valid, closing."));
        }
        return isValid;
    }

    public int getTimeout() {
        return this.soTimeoutMs;
    }

    public int getNumberCreated() {
        return this.created.get();
    }

    public int getNumberDestroyed() {
        return this.destroyed.get();
    }

    @Override
    public void close() {
    }

    private long getLastClosedTimestamp(SocketDestination socketDestination) {
        Long lastClosedTimestamp = this.lastClosedTimestamps.get(socketDestination);
        return lastClosedTimestamp != null ? lastClosedTimestamp : 0L;
    }

    public void setLastClosedTimestamp(SocketDestination socketDestination) {
        this.lastClosedTimestamps.put(socketDestination, System.nanoTime());
    }
}

