/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.socket.clientrequest.AbstractStoreClientRequest;
import voldemort.utils.ByteArray;
import voldemort.versioning.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVersionsClientRequest
extends AbstractStoreClientRequest<List<Version>> {
    private final ByteArray key;

    public GetVersionsClientRequest(String storeName, RequestFormat requestFormat, RequestRoutingType requestRoutingType, ByteArray key) {
        super(storeName, requestFormat, requestRoutingType);
        this.key = key;
    }

    @Override
    public boolean isCompleteResponse(ByteBuffer buffer) {
        return this.requestFormat.isCompleteGetVersionResponse(buffer);
    }

    @Override
    protected void formatRequestInternal(DataOutputStream outputStream) throws IOException {
        this.requestFormat.writeGetVersionRequest(outputStream, this.storeName, this.key, this.requestRoutingType);
    }

    @Override
    protected List<Version> parseResponseInternal(DataInputStream inputStream) throws IOException {
        return this.requestFormat.readGetVersionResponse(inputStream);
    }
}

