/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pair<F, S>
implements Serializable,
Function<F, S> {
    private static final long serialVersionUID = 1L;
    private final F first;
    private final S second;

    public static final <F, S> Pair<F, S> create(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public S apply(F from) {
        if (from == null ? this.first == null : from.equals(this.first)) {
            return this.second;
        }
        return null;
    }

    public final F getFirst() {
        return this.first;
    }

    public final S getSecond() {
        return this.second;
    }

    public final int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equal(this.first, other.first) && Objects.equal(this.second, other.second);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ " + this.first + ", " + this.second + " ]");
        return builder.toString();
    }
}

