/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server.web;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.server.web.DbColumn;
import org.h2.server.web.DbSchema;
import org.h2.util.New;

public class DbTableOrView {
    final DbSchema schema;
    final String name;
    final String quotedName;
    final boolean isView;
    DbColumn[] columns;

    DbTableOrView(DbSchema dbSchema, ResultSet resultSet) throws SQLException {
        this.schema = dbSchema;
        this.name = resultSet.getString("TABLE_NAME");
        String string = resultSet.getString("TABLE_TYPE");
        this.isView = "VIEW".equals(string);
        this.quotedName = dbSchema.contents.quoteIdentifier(this.name);
    }

    void readColumns(DatabaseMetaData databaseMetaData) throws SQLException {
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schema.name, this.name, null);
        ArrayList<DbColumn> arrayList = New.arrayList();
        while (resultSet.next()) {
            DbColumn dbColumn = new DbColumn(this.schema.contents, resultSet);
            arrayList.add(dbColumn);
        }
        resultSet.close();
        this.columns = new DbColumn[arrayList.size()];
        arrayList.toArray(this.columns);
    }
}

